/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.model.data.Annotation;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.model.data.LogModelEvent;
import com.moonlit.logfaces.client.model.data.LogModelListener;
import com.moonlit.logfaces.client.widgets.TooltipHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class OverviewBar
implements LogModelListener {
    private static Logger log = LogManager.getLogger(OverviewBar.class);
    protected int ANNOTATION_HEIGHT = 4;
    protected int INSET = 0;
    protected LogView view;
    protected LogDataModel model;
    protected Canvas canvas;
    protected Image buffer;
    protected Map<Integer, Annotation> positions = new HashMap<Integer, Annotation>();
    protected Cursor handCursor;
    protected Cursor defaultCursor;
    protected TooltipHandler tooltip;
    protected int itemHight;

    public OverviewBar(Composite parent, LogView view) {
        this.view = view;
        this.model = view.getModel();
        this.model.addListener(this);
        this.handCursor = new Cursor(null, 21);
        this.createControl(parent);
    }

    protected Control createControl(Composite parent) {
        this.canvas = new Canvas(parent, 262144);
        this.tooltip = new TooltipHandler(this.canvas.getShell());
        this.defaultCursor = this.canvas.getCursor();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                OverviewBar.this.doubleBufferPaint(event.gc);
            }
        });
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                OverviewBar.this.handleDispose();
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                OverviewBar.this.handleMouseDown(event);
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                OverviewBar.this.handleMouseMove(event);
            }
        });
        this.canvas.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                OverviewBar.this.tooltip.hideTooltip();
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        return this.canvas;
    }

    public void setItemHight(int hight) {
        this.itemHight = hight;
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.canvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.buffer != null) {
            Rectangle r = this.buffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.buffer.dispose();
                this.buffer = null;
            }
        }
        if (this.buffer == null) {
            this.buffer = new Image((Device)this.canvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.buffer);
        try {
            gc.setBackground(this.canvas.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            this.doPaint(gc);
            dest.drawImage(this.buffer, 0, 0);
        }
        finally {
            gc.dispose();
        }
    }

    protected void doPaint(GC gc) {
    }

    protected void redraw(Object why) {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            GC gc = new GC((Drawable)this.canvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
            if (Util.isMac()) {
                this.canvas.update();
            }
        }
    }

    public Control getControl() {
        return this.canvas;
    }

    protected void handleDispose() {
        if (this.buffer != null) {
            this.buffer.dispose();
        }
        this.handCursor.dispose();
        this.tooltip.dispose();
    }

    protected void handleMouseDown(MouseEvent event) {
        Annotation annotation = this.mouse2annotation(event.y);
        if (annotation != null) {
            this.view.handleOverviewSelection(annotation.getLocation(), event.y);
        }
        this.tooltip.hideTooltip();
    }

    protected void handleMouseMove(MouseEvent event) {
    }

    protected Annotation mouse2annotation(int y) {
        return null;
    }

    public void setView(LogView view) {
        this.view = view;
        this.model = view.getModel();
        this.model.addListener(this);
        this.setItemHight(view.getTableViewer().getTable().getItemHeight());
        this.redraw(view);
    }

    @Override
    public void modelUpdated(LogModelEvent event) {
        try {
            if (this.view.isActive()) {
                this.redraw((Object)event);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

