/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.dialogs.PatternsTestDialog;
import com.moonlit.logfaces.client.model.RegexModel;
import com.moonlit.logfaces.client.model.RegexVO;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NamedRegexComposite
extends Composite {
    private ImageHolder images = ImageHolder.getInstance();
    private RegexModel model = RegexModel.getInstance();
    private RegexVO namedRegex;
    private Button buttonAdd;
    private Button buttonRemove;
    private Button buttonRename;
    private Button buttonClear;
    private Button buttonDuplicate;
    private Button buttonNumeric;
    private Combo combo;
    private Combo comboPattern;
    private Combo comboGroup;

    public NamedRegexComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        this.setLayout((Layout)gridLayout);
        this.createToolbarComposite();
        this.createRegexComposite();
        this.populate(this.model.size() == 0 ? null : this.model.getRegexes().get(0));
        this.pack();
    }

    public void apply() {
        if (this.namedRegex == null) {
            return;
        }
        this.namedRegex.setExpression(this.comboPattern.getText());
        this.namedRegex.setGroup(this.comboGroup.getText());
        this.namedRegex.setNumeric(this.buttonNumeric.getSelection());
        this.model.store(this.namedRegex);
    }

    private void createToolbarComposite() {
        String tooltip = "Name of this regular expression will be used\nas a custom category in analysis views.";
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        label.setText("Regex name");
        label.setToolTipText(tooltip);
        GridData gd = new GridData(4, 2, true, false, 1, 1);
        gd.widthHint = 150;
        this.combo = new Combo((Composite)this, 8);
        this.combo.setLayoutData((Object)gd);
        this.combo.setToolTipText(tooltip);
        this.combo.setVisibleItemCount(this.model.size());
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedRegexComposite.this.apply();
                NamedRegexComposite.this.namedRegex = NamedRegexComposite.this.model.get(NamedRegexComposite.this.combo.getText());
                NamedRegexComposite.this.namedRegex = NamedRegexComposite.this.namedRegex != null ? NamedRegexComposite.this.namedRegex.clone() : null;
                NamedRegexComposite.this.combo.setText(NamedRegexComposite.this.namedRegex != null ? NamedRegexComposite.this.namedRegex.getName() : "");
                NamedRegexComposite.this.display();
            }
        });
        this.buttonAdd = new Button((Composite)this, 0);
        this.buttonAdd.setToolTipText("Define new expression");
        this.buttonAdd.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.buttonAdd.setImage(this.images.getImage("icons/add.gif"));
        this.buttonAdd.setFocus();
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedRegexComposite.this.apply();
                InputDialog input = new InputDialog(NamedRegexComposite.this.getShell(), "Define new expression", "Expression name is used as category in anaysis views", "my special log files", null);
                if (input.open() != 0 || input.getValue().length() == 0) {
                    return;
                }
                NamedRegexComposite.this.populate(NamedRegexComposite.this.model.create(input.getValue()));
            }
        });
        this.buttonDuplicate = new Button((Composite)this, 0);
        this.buttonDuplicate.setToolTipText("Duplicate this expression");
        this.buttonDuplicate.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.buttonDuplicate.setImage(this.images.getImage("/icons/copy.gif"));
        this.buttonDuplicate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedRegexComposite.this.apply();
                if (NamedRegexComposite.this.namedRegex == null) {
                    return;
                }
                InputDialog input = new InputDialog(NamedRegexComposite.this.getShell(), "Duplicate expression", "Expression name:", String.format("%s (copy)", NamedRegexComposite.this.namedRegex.getName()), null);
                if (input.open() != 0 || input.getValue().length() == 0) {
                    return;
                }
                RegexVO regex = NamedRegexComposite.this.namedRegex.clone();
                regex.setName(input.getValue());
                NamedRegexComposite.this.model.store(regex);
                NamedRegexComposite.this.populate(regex);
            }
        });
        this.buttonRename = new Button((Composite)this, 0);
        this.buttonRename.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.buttonRename.setToolTipText("rename this expression");
        this.buttonRename.setImage(this.images.getImage("icons/eclipse3_edit.gif"));
        this.buttonRename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedRegexComposite.this.apply();
                if (NamedRegexComposite.this.namedRegex == null) {
                    return;
                }
                InputDialog input = new InputDialog(NamedRegexComposite.this.getShell(), "Rename expression", "Expression name:", NamedRegexComposite.this.namedRegex.getName(), null);
                if (input.open() != 0 || input.getValue().length() == 0) {
                    return;
                }
                NamedRegexComposite.this.namedRegex = NamedRegexComposite.this.model.rename(NamedRegexComposite.this.combo.getText(), input.getValue());
                NamedRegexComposite.this.populate(NamedRegexComposite.this.namedRegex);
            }
        });
        this.buttonRemove = new Button((Composite)this, 0);
        this.buttonRemove.setToolTipText("delete this expression");
        this.buttonRemove.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.buttonRemove.setImage(this.images.getImage("icons/close.gif"));
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedRegexComposite.this.apply();
                if (NamedRegexComposite.this.namedRegex == null) {
                    return;
                }
                if (!MessageDialog.openQuestion((Shell)NamedRegexComposite.this.getShell(), (String)"Please confirm", (String)String.format("Delete the '%s' expression ?", NamedRegexComposite.this.combo.getText()))) {
                    return;
                }
                NamedRegexComposite.this.model.remove(NamedRegexComposite.this.namedRegex.getName());
                RegexVO regex = NamedRegexComposite.this.model.size() == 0 ? null : NamedRegexComposite.this.model.getRegexes().get(0);
                NamedRegexComposite.this.populate(regex);
            }
        });
        this.buttonClear = new Button((Composite)this, 0);
        this.buttonClear.setToolTipText("remove all expressions");
        this.buttonClear.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.buttonClear.setImage(this.images.getImage("icons/eclipse3_clear.gif"));
        this.buttonClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NamedRegexComposite.this.combo.getItemCount() == 0) {
                    return;
                }
                if (!MessageDialog.openQuestion((Shell)NamedRegexComposite.this.getShell(), (String)"Please confirm", (String)"Remove ALL expression?")) {
                    return;
                }
                NamedRegexComposite.this.model.clear();
                NamedRegexComposite.this.populate(null);
            }
        });
    }

    private void createRegexComposite() {
        String tooltip = "Actual regular expression for parsing log lines\nMust contain at least one named or unnamed group\nwhich will be used for extracting data from text.";
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        label.setText("Pattern");
        label.setToolTipText(tooltip);
        GridData gd = new GridData(4, 2, true, true, 6, 1);
        gd.widthHint = 150;
        this.comboPattern = new Combo((Composite)this, 4);
        this.comboPattern.setToolTipText(tooltip);
        this.comboPattern.setLayoutData((Object)gd);
        for (String string : this.model.getOptions("pattern")) {
            this.comboPattern.add(string);
        }
        tooltip = "Name of the group which shall be used for data extraction\nWhen regular expression contains more than one group\nThen we want to know which to use\nLeave blank for the first group";
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        label.setText("Use this group");
        label.setToolTipText(tooltip);
        this.comboGroup = new Combo((Composite)this, 4);
        this.comboGroup.setToolTipText(tooltip);
        this.comboGroup.setLayoutData((Object)gd);
        this.comboGroup.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NamedRegexComposite.this.apply();
                NamedRegexComposite.this.comboGroup.removeAll();
                for (String group : NamedRegexComposite.this.namedRegex.getPattern().groupNames()) {
                    NamedRegexComposite.this.comboGroup.add(group);
                }
                NamedRegexComposite.this.comboGroup.setText(NamedRegexComposite.this.namedRegex.getGroup());
            }
        });
        tooltip = "Indicate whether the group captured by this expression\nwill be a numeric or textual value\nleave blank if not sure.";
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        label.setText("");
        label.setToolTipText(tooltip);
        this.buttonNumeric = new Button((Composite)this, 32);
        this.buttonNumeric.setText("Capture numeric values only");
        this.buttonNumeric.setToolTipText(tooltip);
        this.buttonNumeric.setSelection(this.namedRegex != null ? this.namedRegex.isNumeric() : false);
        this.buttonNumeric.setLayoutData((Object)new GridData(4, 2, true, true, 6, 1));
        this.buttonNumeric.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedRegexComposite.this.namedRegex.setNumeric(NamedRegexComposite.this.buttonNumeric.getSelection());
            }
        });
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        label.setText("");
        Button buttonTest = new Button((Composite)this, 0);
        buttonTest.setText("TEST");
        buttonTest.setToolTipText("Test this expression with some input\nOnce you are satisfied with the result, the expression is ready for use.");
        buttonTest.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        buttonTest.setImage(this.images.getButtonImage("icons/level_debug3.gif"));
        buttonTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedRegexComposite.this.apply();
                if (NamedRegexComposite.this.namedRegex == null) {
                    return;
                }
                PatternsTestDialog dialog = new PatternsTestDialog(NamedRegexComposite.this.getShell(), NamedRegexComposite.this.namedRegex.getExpression());
                dialog.open();
            }
        });
    }

    private void populate(RegexVO current) {
        this.combo.removeAll();
        this.combo.setVisibleItemCount(this.model.size());
        for (RegexVO regex : this.model.getRegexes()) {
            this.combo.add(regex.getName());
            if (!regex.equals(current)) continue;
            this.combo.select(this.combo.getItemCount() - 1);
        }
        this.namedRegex = current;
        this.display();
    }

    private void display() {
        this.combo.setEnabled(this.model.size() > 0);
        this.buttonRemove.setEnabled(this.namedRegex != null);
        this.buttonRename.setEnabled(this.namedRegex != null);
        this.buttonClear.setEnabled(this.model.size() > 0);
        this.buttonDuplicate.setEnabled(this.namedRegex != null);
        this.comboPattern.setEnabled(this.namedRegex != null);
        this.comboPattern.setText(this.namedRegex != null ? this.namedRegex.getExpression() : "");
        this.comboGroup.setEnabled(this.namedRegex != null);
        this.comboGroup.setText(this.namedRegex != null ? this.namedRegex.getGroup() : "");
        this.buttonNumeric.setSelection(this.namedRegex != null ? this.namedRegex.isNumeric() : false);
        this.buttonNumeric.setEnabled(this.namedRegex != null);
    }
}

