/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.model.EventStyle;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LevelStylesComposite
extends Composite {
    private Button fgButton;
    private Button bgButton;
    private Button defaultButton;
    private Table table;
    private Table iconsTable;
    private Map<Integer, EventStyle> styles;
    private ImageHolder images = ImageHolder.getInstance();

    public LevelStylesComposite(Composite parent, int style) {
        super(parent, style);
        this.styles = EventStyles.getInstance().getStyles();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText("Select line below to customize foreground, background and icons.");
        label.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.createTable();
        this.createIconsTable();
        this.fgButton = new Button((Composite)this, 0);
        this.fgButton.setText("Foreground");
        this.fgButton.setEnabled(false);
        this.fgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = LevelStylesComposite.this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                RGB rgb = new ColorDialog(LevelStylesComposite.this.getShell()).open();
                if (rgb == null) {
                    return;
                }
                TableItem[] tableItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    LfsLevel level = (LfsLevel)item.getData();
                    EventStyle style = LevelStylesComposite.this.styles.get(level.intLevel());
                    style.setForeground(new Color(null, rgb));
                    item.setForeground(style.getForeground());
                    ++n2;
                }
                LevelStylesComposite.this.table.deselectAll();
                LevelStylesComposite.this.iconsTable.deselectAll();
                LevelStylesComposite.this.fgButton.setEnabled(false);
                LevelStylesComposite.this.bgButton.setEnabled(false);
            }
        });
        this.bgButton = new Button((Composite)this, 0);
        this.bgButton.setText("Background");
        this.bgButton.setEnabled(false);
        this.bgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = LevelStylesComposite.this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                RGB rgb = new ColorDialog(LevelStylesComposite.this.getShell()).open();
                if (rgb == null) {
                    return;
                }
                TableItem[] tableItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    LfsLevel level = (LfsLevel)item.getData();
                    EventStyle style = LevelStylesComposite.this.styles.get(level.intLevel());
                    style.setBackground(new Color(null, rgb));
                    item.setBackground(style.getBackground());
                    ++n2;
                }
                LevelStylesComposite.this.table.deselectAll();
                LevelStylesComposite.this.iconsTable.deselectAll();
                LevelStylesComposite.this.fgButton.setEnabled(false);
                LevelStylesComposite.this.bgButton.setEnabled(false);
            }
        });
        this.defaultButton = new Button((Composite)this, 0);
        this.defaultButton.setText("Use defaults");
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelStylesComposite.this.styles = EventStyles.getInstance().getDefaultStyles();
                LevelStylesComposite.this.populateTable();
                LevelStylesComposite.this.fgButton.setEnabled(false);
                LevelStylesComposite.this.bgButton.setEnabled(false);
                LevelStylesComposite.this.table.deselectAll();
                LevelStylesComposite.this.iconsTable.deselectAll();
            }
        });
        this.pack();
    }

    private void createTable() {
        this.table = new Table((Composite)this, 68354);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        gridData.heightHint = 200;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(false);
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = LevelStylesComposite.this.table.getSelection();
                LevelStylesComposite.this.fgButton.setEnabled(selection.length > 0);
                LevelStylesComposite.this.bgButton.setEnabled(selection.length > 0);
            }
        });
        this.populateTable();
    }

    private void populateTable() {
        this.table.removeAll();
        for (LfsLevel level : LfsLevel.toList()) {
            TableItem item = new TableItem(this.table, 0);
            EventStyle style = this.styles.get(level.intLevel());
            if (style == null) continue;
            item.setImage(0, style.getImage());
            item.setText(0, "This is how " + level.toString() + " will be displayed");
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
            item.setData((Object)level);
        }
    }

    private void createIconsTable() {
        this.iconsTable = new Table((Composite)this, 68356);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        gridData.heightHint = 280;
        this.iconsTable.setLayoutData((Object)gridData);
        this.iconsTable.setLinesVisible(false);
        this.iconsTable.setHeaderVisible(false);
        this.iconsTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = LevelStylesComposite.this.iconsTable.getSelection();
                if (selection.length > 0) {
                    LevelStylesComposite.this.updateIcon((String)selection[0].getData());
                }
            }
        });
        int counter = 1;
        this.addCustomImage("icons/trace.gif", counter++);
        this.addCustomImage("icons/level_debug3.gif", counter++);
        this.addCustomImage("icons/message_info.gif", counter++);
        this.addCustomImage("icons/task_warning_misc.gif", counter++);
        this.addCustomImage("icons/message_error.gif", counter++);
        this.addCustomImage("icons/level_fatal2.gif", counter++);
        this.addCustomImage("/icons/eclipse3_stop.gif", counter++);
        this.addCustomImage("icons/eclipse3_help.gif", counter++);
        this.addCustomImage("icons/exclude.gif", counter++);
        this.addCustomImage("/icons/custom1.png", counter++);
        this.addCustomImage("/icons/custom2.png", counter++);
        this.addCustomImage("/icons/custom3.png", counter++);
        this.addCustomImage("/icons/custom4.png", counter++);
        this.addCustomImage("/icons/custom5.png", counter++);
        this.addCustomImage("/icons/custom6.png", counter++);
        this.addCustomImage("/icons/custom7.png", counter++);
    }

    private void addCustomImage(String resource, int counter) {
        TableItem item = new TableItem(this.iconsTable, 1);
        item.setImage(this.images.getImage(resource));
        item.setText("icon-" + counter);
        item.setData((Object)resource);
    }

    private void updateIcon(String resource) {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"", (String)"Select entry on the left to assign the image");
            return;
        }
        TableItem[] tableItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LfsLevel level = (LfsLevel)item.getData();
            EventStyle style = this.styles.get(level.intLevel());
            style.setImageResource(resource);
            style.setImage(this.images.getImage(resource));
            item.setImage(style.getImage());
            ++n2;
        }
    }

    public Map<Integer, EventStyle> getStyles() {
        return this.styles;
    }
}

