/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.google.common.collect.Sets;
import com.moonlit.logfaces.client.actions.FollowEventAction;
import com.moonlit.logfaces.client.actions.QueryGisAction;
import com.moonlit.logfaces.client.gis.GIS;
import com.moonlit.logfaces.client.gis.GisLocation;
import com.moonlit.logfaces.client.gis.GisOverlayPainter;
import com.moonlit.logfaces.client.types.TimeRange;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.ToolTipManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.input.CenterMapListener;
import org.jxmapviewer.input.PanMouseInputListener;
import org.jxmapviewer.input.ZoomMouseWheelListenerCursor;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.jxmapviewer.viewer.WaypointPainter;

public class GisComposite
extends Composite {
    private GIS gis = GIS.getInstance();
    private JXMapViewer mapViewer;
    private WaypointPainter<GisLocation> painter;
    private static TileFactory tileFactory = new DefaultTileFactory((TileFactoryInfo)new OSMTileFactoryInfo());

    public GisComposite(Composite parent) {
        super(parent, 0x1040000);
        this.setLayoutData(new GridData(1808));
        this.mapViewer = new JXMapViewer();
        Frame frame = SWT_AWT.new_Frame((Composite)this);
        frame.setPreferredSize(new Dimension(600, 600));
        frame.setLayout(new GridLayout(1, 1));
        frame.add((Component)this.mapViewer);
        this.mapViewer.setTileFactory(tileFactory);
        PanMouseInputListener mia = new PanMouseInputListener(this.mapViewer);
        this.mapViewer.addMouseListener((MouseListener)mia);
        this.mapViewer.addMouseMotionListener((MouseMotionListener)mia);
        this.mapViewer.addMouseListener((MouseListener)new CenterMapListener(this.mapViewer));
        this.mapViewer.addMouseWheelListener((MouseWheelListener)new ZoomMouseWheelListenerCursor(this.mapViewer));
        this.painter = new GisOverlayPainter();
        this.mapViewer.setOverlayPainter(this.painter);
        ToolTipManager.sharedInstance().setInitialDelay(0);
    }

    public void setPosition(int zoom, double lat, double lon) {
        this.mapViewer.setZoom(zoom);
        this.mapViewer.setCenterPosition(new GeoPosition(lat, lon));
    }

    public void dispose() {
        this.save();
    }

    public void save() {
        if (!this.isDisposed()) {
            GeoPosition center = this.mapViewer.getCenterPosition();
            this.gis.savePosition(center.getLatitude(), center.getLongitude(), this.mapViewer.getZoom());
        }
    }

    public void clear() {
        this.mapViewer.removeAll();
        this.painter.setWaypoints((Set)Sets.newHashSet());
        this.mapViewer.setAddressLocation(this.gis.getDefaultLocation().getPosition());
        this.mapViewer.repaint();
    }

    public void display(Set<GisLocation> locations, boolean refresh) {
        this.mapViewer.removeAll();
        for (GisLocation location : locations) {
            this.mapViewer.add((Component)location.getButton());
        }
        this.painter.setWaypoints(locations);
        this.mapViewer.repaint();
    }

    public void centerAt(Set<GisLocation> locations) {
        if (!locations.isEmpty()) {
            this.mapViewer.setAddressLocation(locations.iterator().next().getPosition());
        }
        this.mapViewer.recenterToAddressLocation();
    }

    public int getZoom() {
        return this.mapViewer.getZoom();
    }

    public GeoPosition getCenter() {
        return this.mapViewer.getCenterPosition();
    }

    public void displayContextMenu(final GisLocation location) {
        if (!this.isVisible()) {
            return;
        }
        MenuManager menuMgr = new MenuManager("exportPopup");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new FollowEventAction(location));
                MenuManager subMenu = new MenuManager(String.format("Query '%s' related data..", location.getIp()));
                subMenu.add((IAction)new QueryGisAction(location, TimeRange.BEFORE_1_HOUR, TimeZone.getDefault()));
                subMenu.add((IAction)new QueryGisAction(location, TimeRange.BEFORE_2_HOURS, TimeZone.getDefault()));
                subMenu.add((IAction)new QueryGisAction(location, TimeRange.BEFORE_4_HOURS, TimeZone.getDefault()));
                subMenu.add((IAction)new QueryGisAction(location, TimeRange.BEFORE_8_HOURS, TimeZone.getDefault()));
                subMenu.add((IAction)new QueryGisAction(location, TimeRange.BEFORE_1_DAY, TimeZone.getDefault()));
                subMenu.add((IAction)new QueryGisAction(location, TimeRange.BEFORE_2_DAY, TimeZone.getDefault()));
                subMenu.add((IAction)new QueryGisAction(location, TimeRange.BEFORE_1_WEEK, TimeZone.getDefault()));
                subMenu.add((IAction)new QueryGisAction(location, TimeRange.BEFORE_2_WEEKS, TimeZone.getDefault()));
                subMenu.add((IAction)new QueryGisAction(location, TimeRange.BEFORE_1_MONTH, TimeZone.getDefault()));
                manager.add((IContributionItem)subMenu);
            }
        });
        Point point = this.getDisplay().getCursorLocation();
        Menu menu = menuMgr.createContextMenu((Control)this);
        menu.setLocation(point);
        menu.setVisible(true);
    }
}

