/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.widgets.IEditableColumn;
import com.moonlit.logfaces.client.widgets.IEditableItem;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class EditableTree
extends Tree {
    private TreeEditor editor;
    private TreeItem selectedItem;
    private int selectedColumnIndex = -1;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (EditableTree.this.editor.getEditor() != null && !EditableTree.this.editor.getEditor().isDisposed()) {
                EditableTree.this.editor.getEditor().dispose();
            }
        }
    };

    public EditableTree(Composite parent, int style) {
        super(parent, style);
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TreeItem item;
                if (e.keyCode == 13 && (item = EditableTree.this.getSelectedItem()) != null && EditableTree.this.selectedColumnIndex == -1) {
                    int i = 0;
                    while (i < EditableTree.this.getColumnCount()) {
                        if (EditableTree.this.getColumn(i) instanceof IEditableColumn) {
                            EditableTree.this.selectedColumnIndex = i;
                            EditableTree.this.activateEditor();
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TreeItem item;
                IEditableColumn column;
                if (EditableTree.this.selectedItem != null && EditableTree.this.selectedColumnIndex != -1 && EditableTree.this.editor.getEditor() != null && !EditableTree.this.editor.getEditor().isDisposed() && (column = (IEditableColumn)EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex)).isEditable()) {
                    column.destroyEditor();
                }
                if ((item = EditableTree.this.getItem(new Point(e.x, e.y))) != null) {
                    int columnIndex = -1;
                    int i = 0;
                    while (i < EditableTree.this.getColumnCount()) {
                        if (EditableTree.this.getColumn(i) instanceof IEditableColumn && ((IEditableColumn)EditableTree.this.getColumn(i)).isEditable() && item.getBounds(i).contains(e.x, e.y)) {
                            columnIndex = i;
                        }
                        ++i;
                    }
                    if (columnIndex != -1 && item == EditableTree.this.selectedItem && columnIndex == EditableTree.this.selectedColumnIndex) {
                        EditableTree.this.activateEditor();
                    }
                    EditableTree.this.selectedItem = item;
                    EditableTree.this.selectedColumnIndex = columnIndex;
                }
            }
        });
        this.editor = new TreeEditor((Tree)this);
        this.editor.horizontalAlignment = 0x1000000;
        this.editor.grabHorizontal = true;
    }

    protected void checkSubclass() {
    }

    private TreeItem getSelectedItem() {
        if (this.getSelectionCount() != 1) {
            return null;
        }
        return this.getSelection()[0];
    }

    private TreeItem selectNextRow() {
        int row;
        if (this.getSelectionCount() != 1) {
            return null;
        }
        TreeItem item = this.getSelection()[0];
        if (item.getParentItem() == null && !item.getExpanded() && (row = this.indexOf(item) + 1) < this.getItemCount()) {
            TreeItem[] selection = new TreeItem[]{this.getItem(row)};
            this.setSelection(selection);
            return selection[0];
        }
        if (item.getParentItem() == null && item.getExpanded() && (row = 0) < item.getItemCount()) {
            TreeItem[] selection = new TreeItem[]{item.getItem(row)};
            this.setSelection(selection);
            return selection[0];
        }
        if (item.getParentItem() != null && item.getParentItem().getExpanded() && (row = item.getParentItem().indexOf(item) + 1) < item.getParentItem().getItemCount()) {
            TreeItem[] selection = new TreeItem[]{item.getParentItem().getItem(row)};
            this.setSelection(selection);
            return selection[0];
        }
        return null;
    }

    private TreeItem selectPreviousRow() {
        int index;
        if (this.getSelectionCount() != 1) {
            return null;
        }
        TreeItem item = this.getSelection()[0];
        if (item.getParentItem() != null && (index = item.getParentItem().indexOf(item) - 1) >= 0) {
            TreeItem[] selection = new TreeItem[]{item.getParentItem().getItem(0)};
            this.setSelection(selection);
            return selection[0];
        }
        index = item.getParent().indexOf(item) + 1;
        if (index >= 0) {
            TreeItem[] selection = new TreeItem[]{item.getParent().getItem(0)};
            this.setSelection(selection);
            return selection[0];
        }
        return null;
    }

    private void activateEditor() {
        TreeItem item = this.getSelectedItem();
        if (item == null || !(item instanceof IEditableItem)) {
            return;
        }
        if (this.selectedColumnIndex == -1 || !(this.getColumn(this.selectedColumnIndex) instanceof IEditableColumn)) {
            return;
        }
        IEditableColumn column = (IEditableColumn)this.getColumn(this.selectedColumnIndex);
        if (!column.isEditable() || !((IEditableItem)item).canEdit(this.selectedColumnIndex)) {
            return;
        }
        Control newEditor = column.getEditor((Item)item, this.selectedColumnIndex);
        if (newEditor != null) {
            item.removeDisposeListener(this.disposeListener);
            item.addDisposeListener(this.disposeListener);
            newEditor.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 16) {
                        ((IEditableColumn)EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex)).destroyEditor();
                        do {
                            ++EditableTree.this.selectedColumnIndex;
                        } while (EditableTree.this.selectedColumnIndex < EditableTree.this.getColumnCount() && (!(EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex) instanceof IEditableColumn) || !((IEditableColumn)EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex)).isEditable()));
                        if (EditableTree.this.selectedColumnIndex < EditableTree.this.getColumnCount()) {
                            EditableTree.this.activateEditor();
                        } else if (EditableTree.this.selectNextRow() != null) {
                            EditableTree.this.selectedColumnIndex = -1;
                            do {
                                ++EditableTree.this.selectedColumnIndex;
                            } while (EditableTree.this.selectedColumnIndex < EditableTree.this.getColumnCount() && (!(EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex) instanceof IEditableColumn) || !((IEditableColumn)EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex)).isEditable()));
                            EditableTree.this.activateEditor();
                        } else {
                            EditableTree.this.setFocus();
                            EditableTree.this.selectedColumnIndex = -1;
                        }
                        e.doit = false;
                    } else if (e.detail == 8) {
                        ((IEditableColumn)EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex)).destroyEditor();
                        do {
                            --EditableTree.this.selectedColumnIndex;
                        } while (EditableTree.this.selectedColumnIndex >= 0 && (!(EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex) instanceof IEditableColumn) || !((IEditableColumn)EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex)).isEditable()));
                        if (EditableTree.this.selectedColumnIndex >= 0) {
                            EditableTree.this.activateEditor();
                        } else if (EditableTree.this.selectPreviousRow() != null) {
                            EditableTree.this.selectedColumnIndex = EditableTree.this.getColumnCount();
                            do {
                                --EditableTree.this.selectedColumnIndex;
                            } while (EditableTree.this.selectedColumnIndex >= 0 && (!(EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex) instanceof IEditableColumn) || !((IEditableColumn)EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex)).isEditable()));
                            EditableTree.this.activateEditor();
                        } else {
                            EditableTree.this.setFocus();
                            EditableTree.this.selectedColumnIndex = -1;
                        }
                        e.doit = false;
                    } else if (e.detail == 2) {
                        ((IEditableColumn)EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex)).destroyEditor();
                        EditableTree.this.setFocus();
                        EditableTree.this.selectedColumnIndex = -1;
                        e.doit = false;
                    }
                }
            });
            newEditor.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x1000001 && !(EditableTree.this.editor.getEditor() instanceof Combo)) {
                        ((IEditableColumn)EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex)).destroyEditor();
                        if (EditableTree.this.selectPreviousRow() != null) {
                            EditableTree.this.activateEditor();
                        } else {
                            EditableTree.this.setFocus();
                        }
                        e.doit = false;
                    } else if (e.keyCode == 0x1000002 && !(EditableTree.this.editor.getEditor() instanceof Combo)) {
                        ((IEditableColumn)EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex)).destroyEditor();
                        if (EditableTree.this.selectNextRow() != null) {
                            EditableTree.this.activateEditor();
                        } else {
                            EditableTree.this.setFocus();
                        }
                        e.doit = false;
                    }
                }
            });
            newEditor.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (!(EditableTree.this.editor.getEditor() instanceof Combo)) {
                        ((IEditableColumn)EditableTree.this.getColumn(EditableTree.this.selectedColumnIndex)).destroyEditor();
                    }
                }
            });
            this.editor.setEditor(newEditor, item, this.selectedColumnIndex);
            newEditor.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EditableTree.this.editor.getEditor().setFocus();
                }
            });
        }
    }
}

