/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.widgets.IEditableColumn;
import com.moonlit.logfaces.client.widgets.IEditableItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EditableTableColumn
extends TableColumn
implements IEditableColumn {
    public static final int TEXT = 0;
    public static final int CURRENCY = 1;
    protected boolean editable = true;
    protected TableItem item = null;
    protected int index = -1;
    protected Control editor;

    public EditableTableColumn(Table parent, int style) {
        super(parent, style);
    }

    public EditableTableColumn(Table parent, int style, int index) {
        super(parent, style, index);
    }

    protected void checkSubclass() {
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public Control getEditor(Item item, int index) {
        this.item = (TableItem)item;
        this.index = index;
        this.editor = new Text((Composite)this.getParent(), 0);
        ((Text)this.editor).setText(this.item.getText(index));
        ((Text)this.editor).selectAll();
        return this.editor;
    }

    @Override
    public void destroyEditor() {
        if (this.editor != null && !this.editor.isDisposed()) {
            if (this.item != null && this.index != -1) {
                this.setItemValue(this.index, ((Text)this.editor).getText());
            }
            this.editor.dispose();
        }
        this.editor = null;
    }

    protected void setItemValue(int index, String value) {
        String oldValue = this.item.getText(index);
        this.item.setText(index, value);
        if (this.item instanceof IEditableItem && !oldValue.equals(value)) {
            ((IEditableItem)this.item).itemEdited(index, value);
        }
    }
}

