/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.net.ConnectionProfile;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.client.widgets.RuleComposite;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.Rule;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.jfree.util.Log;

public class CriteriaComposite
extends ScrolledComposite {
    private Composite content;
    private CriteriaFilter criteria;
    private Button clearButton;
    private Button copyButton;
    private Button pasteButton;
    private Button tagsButton;
    private boolean escape;
    private boolean escapeVisible;
    private List<RuleComposite> composites = new ArrayList<RuleComposite>();

    public CriteriaComposite(Composite parent) {
        super(parent, 768);
        this.criteria = null;
        this.escape = false;
        this.escapeVisible = false;
        this.create();
    }

    public CriteriaComposite(Composite parent, CriteriaFilter criteria) {
        super(parent, 768);
        this.criteria = criteria;
        this.escape = false;
        this.escapeVisible = false;
        this.create();
    }

    public CriteriaComposite(Composite parent, QueryVO query) {
        super(parent, 768);
        this.criteria = query.getCriteria();
        this.escape = query.isEscapeSql();
        this.escapeVisible = ConnectionProfile.getInstance().isDbEscapeSql();
        this.create();
    }

    private void create() {
        ImageHolder images = ImageHolder.getInstance();
        this.setLayout((Layout)new FillLayout());
        this.content = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        this.content.setLayout((Layout)gridLayout);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        Composite bbar = new Composite(this.content, 0);
        bbar.setLayout((Layout)gridLayout);
        bbar.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Button addRuleSet = new Button(bbar, 0);
        addRuleSet.setText("Add OR set");
        addRuleSet.setImage(images.getButtonImage("icons/add.gif"));
        addRuleSet.setToolTipText("Create OR rule set");
        addRuleSet.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        addRuleSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rule rule = CriteriaComposite.this.criteria.addRule();
                rule.newCondition();
                RuleComposite rc = CriteriaComposite.this.addRule(rule);
                rc.prompt();
                CriteriaComposite.this.clearButton.setEnabled(true);
                CriteriaComposite.this.copyButton.setEnabled(true);
            }
        });
        this.copyButton = new Button(bbar, 0);
        this.copyButton.setText("Copy");
        this.copyButton.setImage(images.getButtonImage("/icons/copy.gif"));
        this.copyButton.setToolTipText("Copy this criteria to clipboard");
        this.copyButton.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CriteriaComposite.this.copy();
            }
        });
        this.pasteButton = new Button(bbar, 0);
        this.pasteButton.setText("Paste");
        this.pasteButton.setImage(images.getButtonImage("/icons/copy2.gif"));
        this.pasteButton.setToolTipText("Paste criteria from clipboard");
        this.pasteButton.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.pasteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CriteriaComposite.this.paste();
            }
        });
        this.clearButton = new Button(bbar, 0);
        this.clearButton.setText("Clear");
        this.clearButton.setEnabled(this.criteria != null && this.criteria.getRules().size() > 0);
        this.clearButton.setImage(images.getButtonImage("icons/eclipse3_clear.gif"));
        this.clearButton.setToolTipText("Remove all criteria rules");
        this.clearButton.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CriteriaComposite.this.clear();
            }
        });
        final Button escapeButton = new Button(bbar, 32);
        escapeButton.setText("Escape SQL");
        escapeButton.setVisible(this.escapeVisible);
        escapeButton.setSelection(this.escape);
        escapeButton.setToolTipText("Force server to escape special characters\nin SQL statements when using LIKE clause");
        escapeButton.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        escapeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CriteriaComposite.this.escape = escapeButton.getSelection();
            }
        });
        this.tagsButton = new Button(bbar, 0);
        this.tagsButton.setText("Use tag...");
        this.tagsButton.setEnabled(TagsModel.getInstance().size() > 0);
        this.tagsButton.setImage(images.getButtonImage("icons/tag.gif"));
        this.tagsButton.setToolTipText("Use criteria from one of the tags");
        this.tagsButton.setLayoutData((Object)new GridData(3, 2, true, false, 1, 1));
        this.tagsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CriteriaComposite.this.hookTagsMenu();
            }
        });
        this.populate();
        this.setContent((Control)this.content);
        this.setMinSize(500, 500);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
    }

    public boolean isEscape() {
        return this.escape;
    }

    private void clear() {
        for (RuleComposite rc : this.composites) {
            rc.dispose();
        }
        this.criteria.clear();
        this.composites.clear();
        this.clearButton.setEnabled(false);
        this.getParent().layout(true);
        this.layout(true);
    }

    private void copy() {
        try {
            this.getCriteria();
            StringWriter writer = new StringWriter();
            XMLMemento memento = XMLMemento.createWriteRoot((String)"query");
            Utils.serializeCriteria((IMemento)memento, this.criteria);
            memento.save((Writer)writer);
            String copy = writer.toString();
            Clipboard cb = new Clipboard(Display.getDefault());
            cb.setContents(new Object[]{copy}, new Transfer[]{TextTransfer.getInstance()});
        }
        catch (Exception e) {
            Log.error((Object)e);
        }
    }

    private void paste() {
        Clipboard cb = new Clipboard(Display.getDefault());
        Object object = cb.getContents((Transfer)TextTransfer.getInstance());
        if (object == null) {
            return;
        }
        try {
            StringReader reader = new StringReader(object.toString());
            XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
            CriteriaFilter temp = Utils.unserializeCriteria((IMemento)memento);
            this.clear();
            this.criteria = temp;
            this.populate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void populate() {
        if (this.criteria != null) {
            for (Rule rule : this.criteria.getRules()) {
                this.addRule(rule);
            }
            this.clearButton.setEnabled(true);
            this.copyButton.setEnabled(true);
            this.pasteButton.setEnabled(true);
        }
    }

    private void hookTagsMenu() {
        MenuManager menuMgr = new MenuManager("tagsPopup");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (TagVO tag : TagsModel.getInstance().getTags()) {
                    manager.add((IAction)new TagAction(tag));
                }
            }
        });
        Point point = this.toDisplay(this.tagsButton.getLocation());
        point.y += this.tagsButton.getSize().y;
        point.y += 8;
        Menu menu = menuMgr.createContextMenu((Control)this.tagsButton);
        menu.setLocation(point);
        menu.setVisible(true);
    }

    public RuleComposite addRule(Rule rule) {
        RuleComposite composite = new RuleComposite(this, rule);
        composite.setLayoutData(new GridData(4, 2, true, false, 1, 1));
        composite.setFirst(this.composites.size() == 0);
        this.composites.add(composite);
        this.layout(true);
        this.showControl((Control)composite);
        return composite;
    }

    public void removeRule(RuleComposite composite) {
        this.criteria.removeRule(composite.getRule());
        this.composites.remove((Object)composite);
        composite.dispose();
        if (this.composites.size() != 0) {
            this.composites.get(0).setFirst(true);
        }
        this.clearButton.setEnabled(this.composites.size() > 0);
        this.getParent().layout(true);
        this.layout(true);
    }

    public void layout(boolean changed) {
        int h = 0;
        for (RuleComposite rc : this.composites) {
            h += rc.getSize().y;
        }
        this.setMinSize(500, h + 50);
        this.content.layout(true);
        super.layout(changed);
    }

    public Composite getContent() {
        return this.content;
    }

    public CriteriaFilter getCriteria() {
        for (RuleComposite rc : this.composites) {
            rc.apply();
        }
        return this.criteria;
    }

    public void setCriteria(CriteriaFilter criteria) {
        if (criteria == null) {
            return;
        }
        this.criteria = criteria;
        for (RuleComposite rc : this.composites) {
            rc.dispose();
        }
        this.composites.clear();
        this.populate();
    }

    class TagAction
    extends Action {
        TagVO tag;

        public TagAction(TagVO tag) {
            this.setText(tag.getName());
            this.setToolTipText("Use this tag criteria");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/tag.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
            this.tag = tag;
        }

        public void run() {
            if (this.tag.getCriteria() != null) {
                CriteriaComposite.this.setCriteria(this.tag.getCriteria().clone());
            }
        }
    }
}

