/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.model.RepositoryModel;
import com.moonlit.logfaces.client.net.ConnectionProfile;
import com.moonlit.logfaces.client.widgets.HintableField;
import com.moonlit.logfaces.client.widgets.RuleComposite;
import com.moonlit.logfaces.server.criteria.Condition;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.Operation;
import java.util.List;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConditionComposite
extends Composite {
    private Condition condition;
    private Combo valueCombo;
    private Combo attrCombo;
    private Combo actionCombo;
    private Button addButton;
    private Label orLabel;
    private RuleComposite ruleComposite;
    private HintableField hints;

    public ConditionComposite(RuleComposite ruleComposite, Condition condition) {
        super(ruleComposite.getContent(), 0);
        this.condition = condition;
        this.ruleComposite = ruleComposite;
        this.create();
    }

    public void setFirst(boolean first) {
        this.addButton.setVisible(first);
        this.orLabel.setVisible(!first);
    }

    public void prompt() {
        this.attrCombo.deselectAll();
        this.attrCombo.setFocus();
        if (Util.isWindows()) {
            this.attrCombo.setListVisible(true);
        }
    }

    public void apply() {
        this.condition.setValue((Object)this.valueCombo.getText());
    }

    private void create() {
        ConditionComposite container = this;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        container.setLayout((Layout)gridLayout);
        this.addButton = new Button((Composite)container, 0);
        this.addButton.setVisible(false);
        this.addButton.setImage(ImageHolder.getInstance().getImage("icons/and.png"));
        this.addButton.setToolTipText("Add AND condition to the rule set");
        this.addButton.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionComposite.this.ruleComposite.newCondition();
            }
        });
        this.orLabel = new Label((Composite)container, 0);
        this.orLabel.setText("and");
        this.orLabel.setVisible(false);
        this.orLabel.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        List attributes = EventAttribute.toDisplayList();
        attributes.remove(EventAttribute.loggerTimeStamp.name());
        this.attrCombo = new Combo((Composite)container, 8);
        GridData gd = new GridData(4, 2, false, false, 1, 1);
        gd.minimumWidth = 120;
        gd.widthHint = 120;
        this.attrCombo.setLayoutData((Object)gd);
        this.attrCombo.setVisibleItemCount(attributes.size());
        this.attrCombo.addSelectionListener((SelectionListener)new AttributeSelector());
        for (String attr : attributes) {
            this.attrCombo.add(attr);
        }
        if (this.condition.getAttribute() != null) {
            this.attrCombo.setText(this.condition.getAttribute());
        }
        this.actionCombo = new Combo((Composite)container, 8);
        gd = new GridData(4, 2, false, false, 1, 1);
        gd.minimumWidth = 140;
        gd.widthHint = 140;
        this.actionCombo.setLayoutData((Object)gd);
        this.actionCombo.addSelectionListener((SelectionListener)new OperationSelector());
        this.actionCombo.setVisibleItemCount(10);
        this.populateOperations();
        if (this.condition.getOperation() != null) {
            this.actionCombo.setText(this.condition.getOperation().toString());
        }
        gd = new GridData(4, 2, true, false, 1, 1);
        gd.minimumWidth = 160;
        gd.widthHint = 160;
        this.valueCombo = new Combo((Composite)container, 4);
        this.valueCombo.setLayoutData((Object)gd);
        this.valueCombo.setVisibleItemCount(20);
        this.populateValues();
        if (this.condition.getValue() != null) {
            this.valueCombo.setText(this.condition.getValue().toString());
        }
        Button clear = new Button((Composite)container, 0);
        clear.setImage(ImageHolder.getInstance().getImage("icons/trash.gif"));
        clear.setToolTipText("Remove this condition");
        clear.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionComposite.this.ruleComposite.removeCondition(ConditionComposite.this);
            }
        });
    }

    public void populateOperations() {
        block3: for (Operation operation : this.condition.getPossibleOperations()) {
            switch (operation) {
                case regex: 
                case noregex: {
                    if (!ConnectionProfile.getInstance().isDbRegexSupported()) continue block3;
                    this.actionCombo.add(operation.toString());
                    break;
                }
                default: {
                    this.actionCombo.add(operation.toString());
                }
            }
        }
    }

    private void populateValues() {
        EventAttribute attr = EventAttribute.fromString((String)this.attrCombo.getText());
        if (attr == null) {
            return;
        }
        List values = null;
        switch (attr) {
            case domainName: {
                values = RepositoryModel.getInstance().getDomainNames();
                break;
            }
            case hostName: {
                values = RepositoryModel.getInstance().getHostNames();
                break;
            }
            case loggerName: {
                values = RepositoryModel.getInstance().getLoggerNames();
                break;
            }
            case throwableInfo: {
                values = RepositoryModel.getInstance().listExceptions();
                break;
            }
            default: {
                values = this.condition.getPossibleValues();
            }
        }
        this.valueCombo.removeAll();
        this.valueCombo.setItems(values.toArray(new String[values.size()]));
        if (this.hints == null) {
            this.hints = new HintableField((Control)this.valueCombo, (IControlContentAdapter)new ComboContentAdapter(), this.valueCombo.getItems());
        } else {
            this.hints.setProposals(this.valueCombo.getItems());
        }
    }

    public Condition getCondition() {
        return this.condition;
    }

    class AttributeSelector
    extends SelectionAdapter {
        AttributeSelector() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ConditionComposite.this.attrCombo.getSelectionIndex() == -1) {
                return;
            }
            ConditionComposite.this.condition.setAttribute(ConditionComposite.this.attrCombo.getText());
            ConditionComposite.this.actionCombo.removeAll();
            ConditionComposite.this.populateOperations();
            ConditionComposite.this.actionCombo.setFocus();
            ConditionComposite.this.actionCombo.deselectAll();
            if (Util.isWindows()) {
                ConditionComposite.this.actionCombo.setListVisible(true);
            }
            ConditionComposite.this.populateValues();
        }
    }

    class OperationSelector
    extends SelectionAdapter {
        OperationSelector() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ConditionComposite.this.actionCombo.getSelectionIndex() == -1) {
                return;
            }
            Operation operation = Operation.fromString((String)ConditionComposite.this.actionCombo.getText());
            ConditionComposite.this.condition.setOperation(operation);
            ConditionComposite.this.valueCombo.setFocus();
            if (Util.isWindows()) {
                ConditionComposite.this.valueCombo.setListVisible(ConditionComposite.this.valueCombo.getItemCount() > 0);
            }
        }
    }
}

