/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BalloonHandler {
    public static BalloonHandler instance;
    private Display display;
    private Shell tipShell;
    private StyledText label;
    private boolean restore = true;
    private Color bgcolor = new Color(null, 240, 243, 243);

    public static BalloonHandler getInstance() {
        if (instance == null) {
            instance = new BalloonHandler();
        }
        return instance;
    }

    private BalloonHandler() {
        this.display = Display.getDefault();
        final Image image = ImageHolder.getInstance().getImage("icons/faces64.png");
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                final Clicker clicker = new Clicker();
                BalloonHandler.this.tipShell = new Shell(BalloonHandler.this.display, 16385);
                BalloonHandler.this.tipShell.setBackground(BalloonHandler.this.bgcolor);
                GridLayout gridLayout = new GridLayout();
                gridLayout.numColumns = 3;
                gridLayout.horizontalSpacing = 2;
                gridLayout.verticalSpacing = 5;
                gridLayout.marginHeight = 6;
                gridLayout.marginWidth = 6;
                BalloonHandler.this.tipShell.setLayout((Layout)gridLayout);
                BalloonHandler.this.tipShell.setLayoutData((Object)new GridData(1808));
                Label icon = new Label((Composite)BalloonHandler.this.tipShell, 64);
                icon.setBackground(BalloonHandler.this.bgcolor);
                icon.setImage(image);
                icon.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
                icon.addMouseListener((MouseListener)clicker);
                Label stub = new Label((Composite)BalloonHandler.this.tipShell, 0);
                stub.setText("  ");
                stub.setBackground(BalloonHandler.this.bgcolor);
                stub.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
                BalloonHandler.this.label = new StyledText((Composite)BalloonHandler.this.tipShell, 66);
                BalloonHandler.this.label.setBackground(BalloonHandler.this.bgcolor);
                BalloonHandler.this.label.setEditable(false);
                BalloonHandler.this.label.setEnabled(false);
                BalloonHandler.this.label.setLayoutData((Object)new GridData(4, 2, true, true, 1, 1));
                final Button button = new Button((Composite)BalloonHandler.this.tipShell, 32);
                button.setSelection(true);
                button.setText("Show application when disposed");
                button.setBackground(BalloonHandler.this.bgcolor);
                button.setForeground(new Color(null, 128, 128, 128));
                button.setLayoutData((Object)new GridData(2, 2, true, true, 3, 1));
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).BalloonHandler.this.restore = button.getSelection();
                        clicker.mouseDown(null);
                    }
                });
                BalloonHandler.this.tipShell.addMouseListener((MouseListener)clicker);
                BalloonHandler.this.tipShell.pack();
                BalloonHandler.this.tipShell.setVisible(false);
            }
        });
    }

    public void show(final LoggingEventVO event) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Object message;
                    Rectangle rect = BalloonHandler.this.display.getClientArea();
                    String title = event.isThrown() ? String.format("Exception in %s [%s]", event.getDomainName(), event.getHostName()) : String.format("%s from %s [%s]", LfsLevel.toLevel((int)event.getLoggerLevel()), event.getDomainName(), event.getHostName());
                    StringBuffer buff = new StringBuffer();
                    buff.append(String.format("%s%n", title));
                    buff.append(String.format("%s%n", event.getLoggerName()));
                    if (event.isThrown()) {
                        buff.append(String.format("%s%n", Utils.getExceptionClass(event)));
                    }
                    if (((String)(message = event.getMessage())).length() > 80) {
                        message = ((String)message).substring(0, 79) + "...";
                    }
                    buff.append((String)message);
                    BalloonHandler.this.label.setText(buff.toString());
                    StyleRange range1 = new StyleRange();
                    range1.start = 0;
                    range1.length = title.length();
                    range1.foreground = ImageHolder.FG_RED;
                    range1.fontStyle = 1;
                    BalloonHandler.this.label.setStyleRange(range1);
                    BalloonHandler.this.label.setToolTipText(event.getMessage());
                    Point size = BalloonHandler.this.tipShell.computeSize(-1, -1);
                    BalloonHandler.this.tipShell.setBounds(rect.width - size.x - 15, rect.height - size.y - 10, size.x + 5, size.y);
                    BalloonHandler.this.tipShell.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void hideTooltip() {
        this.tipShell.setVisible(false);
    }

    public void dispose() {
        this.label.dispose();
        this.tipShell.dispose();
    }

    class Clicker
    extends MouseAdapter {
        Clicker() {
        }

        public void mouseDown(MouseEvent event) {
            BalloonHandler.this.tipShell.setVisible(false);
            Shell appShell = Application.getShell();
            if (BalloonHandler.this.restore) {
                appShell.setVisible(true);
                appShell.getShell().setMinimized(false);
                appShell.setFocus();
            }
        }
    }
}

