/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.actions.OpenLogPerspectiveAction;
import com.moonlit.logfaces.client.dialogs.LogPerspectiveDlg;
import com.moonlit.logfaces.client.editors.LogEditor;
import com.moonlit.logfaces.client.editors.LogEditorInput;
import com.moonlit.logfaces.client.model.ContextListener;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.LogPerspectivesModel;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.prefs.PersistentCounter;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;

public class WorkspaceView
extends ViewPart
implements IPartListener {
    private static Logger log = LogManager.getLogger(WorkspaceView.class);
    private TableViewer viewer;
    private OpenAction openAction;
    private NewAction newAction;
    private RemoveAction removeAction;
    private ModifyAction modifyAction;
    private DuplicateAction duplicateAction;
    public static final String ID = "com.moonlit.logfaces.client.WorkspaceView";

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setInput((Object)LogPerspectivesModel.getInstance());
        this.viewer.getControl().setBackground(EventStyles.BG_LFS);
        LogPerspectivesModel.getInstance().addContextListener(new ContextListener(){

            @Override
            public void contextChanged() {
                WorkspaceView.this.refresh();
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.hookActionBar();
        this.hookDoubleClickAction();
        WorkspaceView me = this;
        Display.getDefault().asyncExec(() -> this.getSite().getWorkbenchWindow().getActivePage().addPartListener((IPartListener)me));
    }

    private void refresh() {
        Display.getDefault().asyncExec(() -> {
            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                this.viewer.refresh();
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WorkspaceView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookActionBar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IAction)this.openAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)this.newAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            manager.add((IAction)this.newAction);
        } else {
            manager.add((IAction)this.openAction);
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IAction)this.newAction);
            manager.add((IAction)this.duplicateAction);
            manager.add((IAction)this.removeAction);
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IAction)this.modifyAction);
        }
    }

    private void makeActions() {
        this.openAction = new OpenAction();
        this.newAction = new NewAction();
        this.removeAction = new RemoveAction();
        this.modifyAction = new ModifyAction();
        this.duplicateAction = new DuplicateAction();
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WorkspaceView.this.openAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private PerspectiveVO getSelectedPerspective() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        if (window != null && !this.viewer.getSelection().isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            return (PerspectiveVO)selection.getFirstElement();
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        try {
            if (part == null) {
                return;
            }
            if (part instanceof LogEditor) {
                LogEditor myEditor = (LogEditor)part;
                if (this.viewer.getTable().isDisposed()) {
                    return;
                }
                TableItem[] items = this.viewer.getTable().getItems();
                this.viewer.getTable().deselectAll();
                int i = 0;
                while (i < items.length) {
                    if (((PerspectiveVO)items[i].getData()).getName().equals(myEditor.getTitle())) {
                        this.viewer.getTable().select(i);
                        return;
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    class DuplicateAction
    extends Action
    implements ActionFactory.IWorkbenchAction {
        public DuplicateAction() {
            this.setText("Duplicate");
            this.setToolTipText("Duplicate selected perspective");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/copy.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            PerspectiveVO vo = WorkspaceView.this.getSelectedPerspective();
            if (vo == null) {
                return;
            }
            PerspectiveVO perspective = vo.clone();
            perspective.setName(String.format("%s (copy)", vo.getName()));
            LogPerspectiveDlg dialog = new LogPerspectiveDlg(WorkspaceView.this.getSite().getShell(), perspective);
            if (dialog.open() == 0) {
                LogPerspectivesModel.getInstance().addPerspective(perspective);
                new OpenLogPerspectiveAction(perspective).run();
                return;
            }
        }

        public void dispose() {
        }
    }

    class ModifyAction
    extends Action {
        private IStructuredSelection selection;

        public ModifyAction() {
            this.setText("Modify");
            this.setToolTipText("Modify perspective settings");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/preferences.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void selectionChanged(IWorkbenchPart part, ISelection incoming) {
            if (incoming instanceof IStructuredSelection) {
                this.selection = (IStructuredSelection)incoming;
                this.setEnabled(this.selection.size() == 1);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (LfsConnector.getInstance().getConnection() == null) {
                MessageDialog.openError((Shell)WorkspaceView.this.getSite().getShell(), (String)"Error", (String)"Not connected to server");
                return;
            }
            PerspectiveVO vo = WorkspaceView.this.getSelectedPerspective();
            if (vo != null) {
                String oldName = vo.getName();
                LogPerspectiveDlg dialog = new LogPerspectiveDlg(WorkspaceView.this.getSite().getShell(), vo);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    LogPerspectivesModel.getInstance().removePerspective(oldName);
                    LogPerspectivesModel.getInstance().addPerspective(vo);
                }
            }
        }
    }

    class NewAction
    extends Action {
        public NewAction() {
            this.setText("Add");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/add.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            PerspectiveVO vo = new PerspectiveVO();
            JexlCriteria criteria = new JexlCriteria();
            criteria.addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.TRACE.toString());
            vo.setCriteria((CriteriaFilter)criteria);
            vo.setName("New perspective (" + PersistentCounter.getInstance().getCounter() + ")");
            vo.setActivated(true);
            LogPerspectiveDlg dialog = new LogPerspectiveDlg(WorkspaceView.this.getSite().getShell(), vo);
            if (dialog.open() == 0) {
                LogPerspectivesModel.getInstance().addPerspective(vo);
                new OpenLogPerspectiveAction(vo).run();
                return;
            }
        }
    }

    class OpenAction
    extends Action
    implements ActionFactory.IWorkbenchAction {
        public OpenAction() {
            this.setText("Activate");
            this.setToolTipText("Activate selected log perspectives");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/run_exc.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void dispose() {
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)WorkspaceView.this.viewer.getSelection();
            PerspectiveVO vo = (PerspectiveVO)selection.getFirstElement();
            if (vo != null) {
                new OpenLogPerspectiveAction(vo).run();
            }
        }
    }

    class RemoveAction
    extends Action {
        private IStructuredSelection selection;

        public RemoveAction() {
            this.setText("Remove");
            this.setToolTipText("Delete selected log perspectives");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/close.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void selectionChanged(IWorkbenchPart part, ISelection incoming) {
            if (incoming instanceof IStructuredSelection) {
                this.selection = (IStructuredSelection)incoming;
                this.setEnabled(this.selection.size() >= 1);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            IWorkbenchWindow window = WorkspaceView.this.getSite().getWorkbenchWindow();
            if (window != null && !WorkspaceView.this.viewer.getSelection().isEmpty()) {
                IStructuredSelection selection = (IStructuredSelection)WorkspaceView.this.viewer.getSelection();
                Object[] items = selection.toArray();
                IWorkbenchPage page = window.getActivePage();
                if (!MessageDialog.openConfirm(null, (String)"Confirm", (String)"Remove the selected perspectives from workspace?\n\n(operation can't be recovered)")) {
                    return;
                }
                int i = 0;
                while (i < items.length) {
                    PerspectiveVO vo = (PerspectiveVO)items[i];
                    IEditorPart editor = page.findEditor((IEditorInput)new LogEditorInput(vo));
                    if (editor != null) {
                        page.closeEditor(editor, true);
                    }
                    LogPerspectivesModel.getInstance().removePerspective(vo.getName());
                    ++i;
                }
            }
        }
    }
}

