/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import java.awt.Color;
import java.awt.Paint;
import java.util.Random;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class StackedChartSwt {
    private StackedRenderer renderer;
    private Color[] colors = new Color[]{new Color(230, 240, 255), new Color(240, 255, 240), new Color(255, 255, 255), new Color(255, 255, 240), new Color(255, 240, 240), new Color(240, 240, 240)};

    public StackedChartSwt() {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        JFreeChart chart = this.createStackedChart(this.createStackedDataset());
        ChartComposite chartComposite = new ChartComposite((Composite)shell, 0, chart, 680, 420, 300, 200, 2600, 2600, true, false, false, false, false, false);
        chartComposite.setLayoutData((Object)new GridData(1808));
        chartComposite.setRangeZoomable(false);
        chartComposite.setMenu(null);
        chartComposite.addChartMouseListener((ChartMouseListener)new ThisMouseListener());
        shell.setSize(815, 600);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private JFreeChart createStackedChart(TableXYDataset tablexydataset) {
        DateAxis dateaxis = new DateAxis();
        dateaxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        NumberAxis numberaxis = new NumberAxis("Event counts");
        this.renderer = new StackedRenderer();
        XYPlot plot = new XYPlot((XYDataset)tablexydataset, (ValueAxis)dateaxis, (ValueAxis)numberaxis, (XYItemRenderer)this.renderer);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        chart.setBorderPaint(null);
        return chart;
    }

    private TableXYDataset createStackedDataset() {
        Random random = new Random(0L);
        TimeTableXYDataset ds = new TimeTableXYDataset();
        Day day = new Day();
        int i = 0;
        while (i < 24) {
            Hour hour = new Hour(i, day);
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"A"));
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"B"));
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"C"));
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"D"));
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"E"));
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"F"));
            ++i;
        }
        return ds;
    }

    public static void main(String[] args) {
        new StackedChartSwt();
    }

    class StackedRenderer
    extends StackedXYBarRenderer {
        int selectedRow = -1;
        int selectedCol = -1;

        public StackedRenderer() {
            this.setDrawBarOutline(true);
            this.setBarPainter((XYBarPainter)new StandardXYBarPainter());
            this.setShadowVisible(false);
            this.setMargin(0.2);
        }

        public void select(int row, int col) {
            this.selectedRow = row;
            this.selectedCol = col;
            this.notifyListeners(new RendererChangeEvent((Object)this));
        }

        public Paint getItemPaint(int row, int col) {
            if (row == this.selectedRow && col == this.selectedCol) {
                return Color.pink;
            }
            return StackedChartSwt.this.colors[row];
        }
    }

    class ThisMouseListener
    implements ChartMouseListener {
        ThisMouseListener() {
        }

        public void chartMouseMoved(ChartMouseEvent event) {
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            ChartEntity entity = event.getEntity();
            if (entity != null && entity instanceof XYItemEntity) {
                XYItemEntity item = (XYItemEntity)entity;
                StackedChartSwt.this.renderer.select(item.getSeriesIndex(), item.getItem());
                return;
            }
            StackedChartSwt.this.renderer.select(-1, -1);
        }
    }
}

