/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.dashboard.SliceInfo;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.jobs.SliceJob;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.model.data.LogModelEvent;
import com.moonlit.logfaces.client.model.data.LogModelListener;
import com.moonlit.logfaces.client.utils.ColorPicker;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.client.widgets.LabelContribution;
import com.moonlit.logfaces.client.widgets.NoteComposite;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.stats.StatCategory;
import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.util.SortOrder;

public class SlicesView
extends ViewPart
implements Persistent,
IPartListener,
LogModelListener,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String ID = "com.moonlit.logfaces.client.slicesView";
    private static final Logger log = LogManager.getLogger(SlicesView.class);
    private DefaultPieDataset dataset;
    private LogDataModel model;
    private Composite parent;
    private NoteComposite note;
    private Composite chartPanel;
    private ComboAction comboAction;
    private LabelContribution label;
    private IToolBarManager toolbar;
    private long lastUpdate;
    private boolean disposed;
    private boolean initialized;
    private SliceInfo slice;
    private String noteText = "This tool slices data of currently displayed table into categories.\nOnce the chart is produced, you can click on its slices to drill into actual log statements.\nUse selector on local tool bar to switch categories.";
    private IEclipsePreferences prefs = Application.getPrefs();

    public void createPartControl(Composite parent) {
        IEditorPart editor;
        this.parent = parent;
        this.load(null);
        this.toolbar = this.getViewSite().getActionBars().getToolBarManager();
        this.label = new LabelContribution();
        this.toolbar.add((IContributionItem)this.label);
        this.toolbar.add((IContributionItem)new Separator());
        this.comboAction = new ComboAction();
        ActionContributionItem contribution = new ActionContributionItem((IAction)this.comboAction);
        this.toolbar.add((IContributionItem)contribution);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        window.getPartService().addPartListener((IPartListener)this);
        this.prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        parent.setLayout((Layout)new GridLayout(2, false));
        this.displayNote(this.noteText);
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (editor = page.getActiveEditor()) != null && editor instanceof LogView) {
            this.setModel(((LogView)editor).getModel());
        }
        this.initialized = true;
    }

    public void setFocus() {
    }

    public void dispose() {
        this.save(null);
        this.disposed = true;
        if (this.model != null) {
            this.model.removeListener(this);
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        window.getPartService().removePartListener((IPartListener)this);
        this.prefs.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        super.dispose();
    }

    private void updateLabel() {
        if (this.disposed || !this.initialized) {
            return;
        }
        this.label.setText(String.format("%s   ", this.slice.getName()));
        this.toolbar.update(true);
    }

    private Composite createChartPanel(Composite parent) {
        this.createDataset();
        JFreeChart chart = this.createChart();
        ChartComposite chartComposite = new ChartComposite(parent, 0, chart, 680, 420, 300, 200, 2600, 2600, true, false, false, false, false, true);
        chartComposite.setBackground(EventStyles.BG_LFS);
        chartComposite.setRangeZoomable(false);
        chartComposite.setDomainZoomable(false);
        chartComposite.setMenu(null);
        chartComposite.addChartMouseListener((ChartMouseListener)new ThisMouseListener());
        GridData gd = new GridData(1808);
        chartComposite.setLayoutData((Object)gd);
        return chartComposite;
    }

    private void createDataset() {
        if (this.model == null) {
            return;
        }
        this.dataset = new DefaultPieDataset();
        Map<String, Integer> map = this.model.slice(this.slice);
        for (String key : map.keySet()) {
            this.dataset.setValue((Comparable)((Object)key), (Number)map.get(key));
        }
        this.dataset.sortByValues(SortOrder.DESCENDING);
    }

    private JFreeChart createChart() {
        JFreeChart chart = ChartFactory.createPieChart(null, (PieDataset)this.dataset, (boolean)false, (boolean)true, (boolean)true);
        chart.setBorderVisible(false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setNoDataMessage(String.format("No data for '%s' category", this.slice.getName()));
        plot.setIgnoreZeroValues(true);
        plot.setShadowPaint(null);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlineStroke(null);
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("{0} = {1} ({2})"));
        plot.setLabelLinksVisible(true);
        plot.setLabelBackgroundPaint((Paint)Utils.swt2awtColor(EventStyles.BG_LFS));
        this.applyRenderer(plot);
        return chart;
    }

    private void applyRenderer(PiePlot plot) {
        ColorPicker picker = ColorPicker.getInstance();
        if (this.slice.isOfTags()) {
            for (TagVO tag : TagsModel.getInstance().getTags()) {
                Color color = Utils.swt2awtColor(tag.getColor());
                plot.setSectionPaint((Comparable)((Object)tag.getName()), (Paint)color);
            }
            return;
        }
        if (this.slice.getAttribute() == EventAttribute.loggerLevel) {
            for (LfsLevel level : LfsLevel.toList()) {
                Color color = Utils.swt2awtColor(EventStyles.getInstance().getDarkerBackground(level.intLevel()));
                plot.setSectionPaint((Comparable)((Object)level.toString()), (Paint)color);
            }
            return;
        }
        for (Object key : plot.getDataset().getKeys()) {
            plot.setSectionPaint((Comparable)((Object)key.toString()), (Paint)picker.pickAwt(key.toString()));
        }
    }

    private void cleanup() {
        if (this.note != null && !this.note.isDisposed()) {
            this.note.dispose();
        }
        if (this.chartPanel != null && !this.chartPanel.isDisposed()) {
            this.chartPanel.dispose();
        }
        this.note = null;
        this.chartPanel = null;
    }

    private void displayNote(String text) {
        this.cleanup();
        this.note = new NoteComposite(this.parent, text);
        this.note.setLayoutData(new GridData(2, 2, true, true, 1, 1));
        this.parent.layout(true);
    }

    private void displayChart() {
        if (this.parent.isDisposed()) {
            return;
        }
        this.cleanup();
        this.chartPanel = this.createChartPanel(this.parent);
        this.chartPanel.setLayoutData((Object)new GridData(1808));
        this.parent.layout(true);
        this.updateLabel();
        this.lastUpdate = System.currentTimeMillis();
    }

    private void setModel(LogDataModel newmodel) {
        if (this.model == newmodel) {
            return;
        }
        if (newmodel == null) {
            this.comboAction.setEnabled(false);
            this.displayNote(this.noteText);
            if (this.model != null) {
                this.model.removeListener(this);
            }
            this.model = null;
            return;
        }
        this.comboAction.setEnabled(true);
        if (this.model != null) {
            this.model.removeListener(this);
        }
        this.model = newmodel;
        this.model.addListener(this);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    SlicesView.this.displayChart();
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                }
            }
        });
    }

    @Override
    public void modelUpdated(LogModelEvent event) {
        if (this.model == null) {
            return;
        }
        switch (event) {
            case FILTERED: 
            case FINALIZED: {
                this.displayChart();
                break;
            }
            case ADDED: {
                if (this.model.getSize() >= 50 && System.currentTimeMillis() - this.lastUpdate <= 10000L) break;
                this.displayChart();
                break;
            }
            case RETAG: {
                if (!this.slice.isOfTags()) break;
                this.displayChart();
                break;
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof LogView) {
            this.setModel(((LogView)part).getModel());
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor != null && editor instanceof LogView) {
            this.setModel(((LogView)editor).getModel());
        } else {
            this.setModel(null);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    @Override
    public void load(IMemento memento) {
        IDialogSettings settings = Application.getDialogSettings("SlicesView", true);
        try {
            this.slice = new SliceInfo(StatCategory.valueOf((String)settings.get("slice.type")), EventAttribute.valueOf((String)settings.get("slice.attr")), settings.get("slice.name"));
        }
        catch (Exception e) {
            this.slice = SliceInfo.getAll(false).get(0);
        }
    }

    @Override
    public void save(IMemento memento) {
        IDialogSettings settings = Application.getDialogSettings("SlicesView", true);
        settings.put("slice.type", this.slice.getType().name());
        settings.put("slice.name", this.slice.getName());
        settings.put("slice.attr", this.slice.getAttribute().name());
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("lfs_levels".equals(key) || "lfs_tags".equals(key)) {
            this.displayChart();
        }
    }

    class CategoryAction
    extends Action {
        ComboAction parent;
        SliceInfo si;

        public CategoryAction(SliceInfo si, ComboAction parent) {
            this.si = si;
            this.parent = parent;
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setText(si.getName());
            this.setToolTipText("slice by " + si.getName());
            this.setImageDescriptor(ImageHolder.getInstance().getImageDescriptor(si));
        }

        public void run() {
            this.parent.setLastAction(this);
            SlicesView.this.slice = this.si;
            SlicesView.this.displayChart();
            SlicesView.this.updateLabel();
        }
    }

    class ComboAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;
        private CategoryAction lastAction;

        public ComboAction() {
            this.setText("Slice by...");
            this.setToolTipText("Click to refresh or select different slice");
            this.setLastAction(new CategoryAction(SlicesView.this.slice, this));
            this.setMenuCreator(this);
            this.setEnabled(false);
        }

        public void setLastAction(CategoryAction action) {
            this.lastAction = action;
            this.setImageDescriptor(this.lastAction.getImageDescriptor());
            this.setText(this.lastAction.getText());
            SlicesView.this.updateLabel();
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            StatCategory type = StatCategory.attributes;
            for (SliceInfo si : SliceInfo.getAll(false)) {
                if (type != si.getType()) {
                    new Separator("additions").fill(this.fMenu, -1);
                    type = si.getType();
                }
                CategoryAction action = new CategoryAction(si, this);
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(this.fMenu, -1);
            }
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void runWithEvent(Event e) {
            Widget item = e.widget;
            ToolItem ti = (ToolItem)item;
            Menu m = this.getMenu((Control)ti.getParent());
            if (m != null) {
                Rectangle rect = ti.getBounds();
                Point point = ti.getParent().toDisplay(new Point(rect.x, rect.y));
                m.setLocation(point.x, point.y + ti.getParent().getBounds().height);
                m.setVisible(true);
                return;
            }
            this.run();
        }

        public void run() {
            if (this.lastAction != null) {
                this.lastAction.run();
                this.setLastAction(this.lastAction);
            }
        }

        protected void addActionToMenu(Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(this.fMenu, -1);
        }
    }

    class ThisMouseListener
    implements ChartMouseListener {
        ThisMouseListener() {
        }

        public void chartMouseMoved(ChartMouseEvent event) {
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            ChartEntity entity = event.getEntity();
            if (entity instanceof PieSectionEntity) {
                PieSectionEntity section = (PieSectionEntity)entity;
                SlicesView.this.slice.setSeries(section.getSectionKey().toString());
                String title = String.format("%s (%s)", SlicesView.this.slice.getName(), SlicesView.this.slice.getSeries());
                CriteriaFilter criteria = Utils.column2criteria(SlicesView.this.slice, null);
                if (!criteria.getRules().isEmpty()) {
                    criteria.prepare();
                    SliceJob job = new SliceJob(title, SlicesView.this.model, criteria);
                    job.setUser(true);
                    job.schedule();
                }
            }
        }
    }
}

