/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.actions.ReloadRepositoryAction;
import com.moonlit.logfaces.client.editors.LogEditor;
import com.moonlit.logfaces.client.jobs.DeleteRepositoryDataJob;
import com.moonlit.logfaces.client.model.ComponentModel;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.ContextListener;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.RepositoryDomainModel;
import com.moonlit.logfaces.client.model.RepositoryElement;
import com.moonlit.logfaces.client.model.RepositoryLoggerModel;
import com.moonlit.logfaces.client.model.RepositoryModel;
import com.moonlit.logfaces.client.model.RepositoryPackageModel;
import com.moonlit.logfaces.client.utils.ContextMenuBuilder;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.BackingStoreException;

public class RepositoryView
extends ViewPart
implements IPartListener,
ISelectionListener {
    private int instanceID = 1;
    public static final String ID = "com.moonlit.logfaces.client.navigationView";
    private TreeViewer viewer;
    private Text domainFilter;
    private Text packageFilter;
    private IEclipsePreferences prefs = Application.getPrefs();
    private IWorkbenchPartSite site;
    private Shell shell;

    public void saveState(IMemento memento) {
        memento.putInteger("lastInstance", this.instanceID);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null && memento.getInteger("lastInstance") != null) {
            this.instanceID = memento.getInteger("lastInstance");
        }
        super.init(site, memento);
        this.shell = site.getShell();
    }

    public void createPartControl(Composite parent) {
        this.site = this.getSite();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        parent.setLayout((Layout)gridLayout);
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        label.setText("Domain filter:");
        this.domainFilter = new Text(parent, 2048);
        this.domainFilter.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.domainFilter.setText(Application.getPrefs().get("REPO_DOMAIN_FILTER", ""));
        this.domainFilter.addKeyListener((KeyListener)new DomainListener());
        label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        label.setText("Package filter:");
        this.packageFilter = new Text(parent, 2048);
        this.packageFilter.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.packageFilter.setText(Application.getPrefs().get("REPO_PACKAGE_FILTER", ""));
        this.packageFilter.addKeyListener((KeyListener)new PackageListener());
        this.viewer = new TreeViewer(parent, 2818);
        this.site.setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setInput((Object)RepositoryModel.getInstance());
        this.viewer.getTree().setFocus();
        this.viewer.getControl().setBackground(EventStyles.BG_LFS);
        RepositoryModel.getInstance().addContextListener(new ContextListener(){

            @Override
            public void contextChanged() {
                RepositoryView.this.refresh();
            }
        });
        IToolBarManager tManager = this.getViewSite().getActionBars().getToolBarManager();
        if (!Application.isServerMode()) {
            tManager.add((IAction)new ReloadRepositoryAction(this.site.getShell()));
        }
        tManager.add((IContributionItem)new Separator("additions"));
        tManager.add((IAction)new ExpandAction(2, "Packages", MainPlugin.getImageDescriptor("/icons/package_obj.gif")));
        tManager.add((IAction)new ExpandAction(3, "Loggers", MainPlugin.getImageDescriptor("icons/class.gif")));
        this.hookContextMenu();
        this.site.getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("perspectivePopup");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)RepositoryView.this.viewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                ContextMenuBuilder.buildForSelection(manager, selection);
                if (RepositoryView.this.isPackageSelection(selection)) {
                    manager.add((IContributionItem)new Separator("additions"));
                    MenuManager subMenu = new MenuManager("Attach to component...");
                    for (String component : ComponentsModel.getInstance().getComponentNames()) {
                        subMenu.add((IAction)new AddToComponentAction(component, selection));
                    }
                    subMenu.add((IContributionItem)new Separator("additions"));
                    subMenu.add((IAction)new AddToComponentAction(null, selection));
                    manager.add((IContributionItem)subMenu);
                }
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IAction)new DeleteAction(false));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.site.registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private boolean isPackageSelection(IStructuredSelection selection) {
        Object[] objects;
        Object[] objectArray = objects = selection.toArray();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!(o instanceof RepositoryPackageModel)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void refresh() {
        if (this.shell.isDisposed()) {
            return;
        }
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!RepositoryView.this.viewer.getTree().isDisposed()) {
                    RepositoryView.this.viewer.refresh();
                }
            }
        });
    }

    public void dispose() {
        this.site.getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private RepositoryEntryVO[] makeRepositoryEntries(IStructuredSelection selection) {
        Object[] selected;
        HashSet<RepositoryEntryVO> list = new HashSet<RepositoryEntryVO>();
        Object[] objectArray = selected = selection.toArray();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryElement model;
            Object o = objectArray[n2];
            if (o instanceof RepositoryDomainModel) {
                model = (RepositoryDomainModel)o;
                list.add(new RepositoryEntryVO(((RepositoryDomainModel)model).getName(), "", ""));
            } else if (o instanceof RepositoryPackageModel) {
                model = (RepositoryPackageModel)o;
                list.add(new RepositoryEntryVO(((RepositoryPackageModel)model).getDomainName(), "", ((RepositoryPackageModel)model).getName()));
            }
            if (o instanceof RepositoryLoggerModel) {
                model = (RepositoryLoggerModel)o;
                list.add(new RepositoryEntryVO(((RepositoryLoggerModel)model).getDomainName(), "", ((RepositoryLoggerModel)model).getFullName()));
            }
            ++n2;
        }
        return list.toArray(new RepositoryEntryVO[list.size()]);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        TreeItem[] domains;
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection) || part.equals((Object)this)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!(obj instanceof LoggingEventVO)) {
            return;
        }
        LoggingEventVO event = (LoggingEventVO)obj;
        Tree tree = this.viewer.getTree();
        TreeItem[] treeItemArray = domains = tree.getItems();
        int n = domains.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem domain = treeItemArray[n2];
            if (domain.getText().equals(event.getDomainName())) {
                TreeItem[] packs;
                TreeItem[] treeItemArray2 = packs = domain.getItems();
                int n3 = packs.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem pack = treeItemArray2[n4];
                    if (pack.getText().equals(event.getLoggerNamePackage())) {
                        TreeItem[] loggers;
                        TreeItem[] treeItemArray3 = loggers = pack.getItems();
                        int n5 = loggers.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            TreeItem logger = treeItemArray3[n6];
                            if (logger.getText().equals(event.getLoggerNameShort())) {
                                domain.setExpanded(true);
                                pack.setExpanded(true);
                                this.viewer.getTree().setSelection(logger);
                                this.viewer.reveal((Object)logger);
                                return;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof LogEditor) {
            LogEditor myEditor = (LogEditor)part;
            myEditor.getTitle();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    class AddToComponentAction
    extends Action {
        String componentName;
        IStructuredSelection selection;

        public AddToComponentAction(String componentName, IStructuredSelection selection) {
            this.componentName = componentName;
            this.selection = selection;
            if (componentName == null) {
                this.setText("Create new component");
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/add.gif"));
            } else {
                this.setText(componentName);
                this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/component.gif"));
            }
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            HashSet<String> packages = new HashSet<String>();
            Iterator it = this.selection.iterator();
            while (it.hasNext()) {
                packages.add(((RepositoryPackageModel)it.next()).getName());
            }
            if (this.componentName == null) {
                InputDialog input = new InputDialog(RepositoryView.this.shell, "How would you like to call new component ?", "Component name:", "", null);
                input.open();
                if (input.getReturnCode() != 0) {
                    return;
                }
                this.componentName = input.getValue();
                if (this.componentName.length() == 0) {
                    return;
                }
                ComponentsModel.getInstance().addComponent(this.componentName, packages);
                return;
            }
            ComponentModel model = ComponentsModel.getInstance().getComponent(this.componentName);
            model.setPackages(packages, true);
        }
    }

    class DeleteAction
    extends Action {
        private boolean includeData;

        public DeleteAction(boolean includeData) {
            this.includeData = includeData;
            this.setText(includeData ? "Remove entries and data" : "Remove entries");
            this.setImageDescriptor(MainPlugin.getImageDescriptor(includeData ? "icons/eclipse3_clear.gif" : "icons/close.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            if (RepositoryView.this.shell.isDisposed()) {
                return;
            }
            RepositoryView.this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IStructuredSelection selection = (IStructuredSelection)((DeleteAction)DeleteAction.this).RepositoryView.this.viewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    if (DeleteAction.this.includeData && !MessageDialog.openQuestion((Shell)((DeleteAction)DeleteAction.this).RepositoryView.this.shell, (String)"Please confirm", (String)"This will remove selected items AND all related log data from repository. Depending on the amount of data, the operation may take some time to complete.\n\nProceed?")) {
                        return;
                    }
                    if (!DeleteAction.this.includeData && !MessageDialog.openQuestion((Shell)((DeleteAction)DeleteAction.this).RepositoryView.this.shell, (String)"Please confirm", (String)"This will remove selected items from repository. Related log data will NOT be removed.\n\nProceed?")) {
                        return;
                    }
                    if (!Application.isServerMode()) {
                        RepositoryEntryVO[] entries = RepositoryView.this.makeRepositoryEntries(selection);
                        DeleteRepositoryDataJob job = new DeleteRepositoryDataJob(entries, DeleteAction.this.includeData);
                        job.setUser(true);
                        job.schedule();
                    } else {
                        List list = selection.toList();
                        for (RepositoryElement element : list) {
                            element.deleteMe();
                        }
                        ((DeleteAction)DeleteAction.this).RepositoryView.this.viewer.refresh();
                        ((DeleteAction)DeleteAction.this).RepositoryView.this.viewer.expandToLevel(2);
                    }
                }
            });
        }
    }

    class DomainListener
    implements KeyListener {
        DomainListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            try {
                RepositoryView.this.prefs.put("REPO_DOMAIN_FILTER", RepositoryView.this.domainFilter.getText());
                RepositoryView.this.prefs.flush();
                RepositoryView.this.refresh();
            }
            catch (BackingStoreException e1) {
                e1.printStackTrace();
            }
        }
    }

    class ExpandAction
    extends Action {
        private int level;

        public ExpandAction(int level, String text, ImageDescriptor image) {
            this.level = level;
            this.setText(text);
            this.setToolTipText(text);
            this.setImageDescriptor(image);
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            if (RepositoryView.this.shell.isDisposed()) {
                return;
            }
            RepositoryView.this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!((ExpandAction)ExpandAction.this).RepositoryView.this.viewer.getTree().isDisposed()) {
                        ((ExpandAction)ExpandAction.this).RepositoryView.this.viewer.collapseAll();
                        ((ExpandAction)ExpandAction.this).RepositoryView.this.viewer.expandToLevel(ExpandAction.this.level);
                    }
                }
            });
        }
    }

    class PackageListener
    implements KeyListener {
        PackageListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            try {
                RepositoryView.this.prefs.put("REPO_PACKAGE_FILTER", RepositoryView.this.packageFilter.getText());
                RepositoryView.this.prefs.flush();
                RepositoryView.this.refresh();
            }
            catch (BackingStoreException e1) {
                e1.printStackTrace();
            }
        }
    }
}

