/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.QueryDialog;
import com.moonlit.logfaces.client.editors.QueryResultsEditor;
import com.moonlit.logfaces.client.jobs.FetchQueryRapidJob;
import com.moonlit.logfaces.client.jobs.QueryDataFetcher;
import com.moonlit.logfaces.client.jobs.UpdatePinJob;
import com.moonlit.logfaces.client.model.ContextListener;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.QueryModel;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.prefs.PersistentCounter;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;

public class QueriesView
extends ViewPart
implements IPartListener {
    private Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private TableViewer viewer;
    private QueryVO currentQuery;
    private IAction executeQueryAction;
    private IAction addQueryAction;
    private IAction removeQueryAction;
    private IAction editQueryAction;
    private IAction duplicateQueryAction;
    private QueryModel queryModel = QueryModel.getInstance();
    public static final String ID = "com.moonlit.logfaces.client.DBQ";

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 772);
        this.viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setInput((Object)this.queryModel);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)QueriesView.this.viewer.getSelection();
                QueriesView.this.currentQuery = selection.isEmpty() ? null : (QueryVO)selection.toArray()[0];
                QueriesView.this.executeQueryAction.setEnabled(!selection.isEmpty());
                QueriesView.this.removeQueryAction.setEnabled(!selection.isEmpty());
                QueriesView.this.editQueryAction.setEnabled(!selection.isEmpty());
                QueriesView.this.duplicateQueryAction.setEnabled(!selection.isEmpty());
            }
        });
        this.queryModel.addContextListener(new ContextListener(){

            @Override
            public void contextChanged() {
                QueriesView.this.refresh();
            }
        });
        this.contributeToActionBars();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        final QueriesView me = this;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                QueriesView.this.getSite().getWorkbenchWindow().getActivePage().addPartListener((IPartListener)me);
            }
        });
    }

    private void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!QueriesView.this.viewer.getControl().isDisposed()) {
                    QueriesView.this.viewer.refresh();
                }
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                QueriesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.viewer.getControl().setBackground(EventStyles.BG_LFS);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.executeQueryAction = new ExecuteQueryAction();
        this.addQueryAction = new AddQueryAction();
        this.removeQueryAction = new RemoveQueryAction();
        this.editQueryAction = new EditQueryAction();
        this.duplicateQueryAction = new DuplicateQueryAction();
        bars.getToolBarManager().add(this.executeQueryAction);
        bars.getToolBarManager().add(this.addQueryAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        manager.add(this.executeQueryAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add(this.addQueryAction);
        manager.add(this.duplicateQueryAction);
        manager.add(this.removeQueryAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add(this.editQueryAction);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                QueriesView.this.executeQueryAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void selectQuery(String name) {
        if (this.viewer.getTable().isDisposed()) {
            return;
        }
        int index = this.queryModel.getQueryIndex(name);
        this.viewer.getTable().deselectAll();
        this.viewer.refresh();
        this.viewer.getTable().select(index);
        this.duplicateQueryAction.setEnabled(this.currentQuery == null ? false : this.currentQuery.isPin());
    }

    public void partActivated(IWorkbenchPart part) {
        try {
            if (part == null) {
                return;
            }
            if (part instanceof QueryResultsEditor) {
                QueryResultsEditor myEditor = (QueryResultsEditor)part;
                this.selectQuery(myEditor.getTitle());
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    class AddQueryAction
    extends Action
    implements ActionFactory.IWorkbenchAction {
        AddQueryAction() {
            this.setText("Add query");
            this.setToolTipText("Add new query");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/add.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            int counter = PersistentCounter.getInstance().getCounter();
            QueryVO query = new QueryVO("Query-" + counter);
            query.setTimeRange(TimeRange.BEFORE_1_HOUR, 0L, 0L);
            query.setTimeZone(TimeZone.getDefault());
            JexlCriteria criteria = new JexlCriteria();
            criteria.addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.WARN.toString());
            query.setCriteria((CriteriaFilter)criteria);
            QueryDialog dialog = new QueryDialog(QueriesView.this.getSite().getShell(), query, true);
            switch (dialog.open()) {
                case 1: {
                    return;
                }
                case 0: {
                    QueriesView.this.currentQuery = query;
                    QueriesView.this.queryModel.addQuery(query);
                    new ExecuteQueryAction().run();
                    break;
                }
                default: {
                    QueriesView.this.queryModel.addQuery(query);
                    QueriesView.this.currentQuery = query;
                }
            }
            QueriesView.this.selectQuery(QueriesView.this.currentQuery.getName());
        }

        public void dispose() {
        }
    }

    class DuplicateQueryAction
    extends Action
    implements ActionFactory.IWorkbenchAction {
        DuplicateQueryAction() {
            this.setText("Duplicate query");
            this.setToolTipText("Duplicate selected query");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/copy.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setEnabled(false);
        }

        public void run() {
            if (QueriesView.this.currentQuery == null) {
                return;
            }
            QueryVO vo = QueriesView.this.currentQuery.clone();
            vo.setName(QueriesView.this.currentQuery.getName() + "(copy)");
            if (vo.isPin()) {
                vo.setPinID(UUID.randomUUID().toString());
            }
            QueryDialog dialog = new QueryDialog(QueriesView.this.getSite().getShell(), vo, true);
            switch (dialog.open()) {
                case 1: {
                    return;
                }
                case 0: {
                    QueriesView.this.currentQuery = vo;
                    QueriesView.this.queryModel.addQuery(vo);
                    new ExecuteQueryAction().run();
                    break;
                }
                default: {
                    QueriesView.this.currentQuery = vo;
                    QueriesView.this.queryModel.addQuery(vo);
                }
            }
            QueriesView.this.selectQuery(QueriesView.this.currentQuery.getName());
        }

        public void dispose() {
        }
    }

    class EditQueryAction
    extends Action
    implements ActionFactory.IWorkbenchAction {
        EditQueryAction() {
            this.setText("Modify query");
            this.setToolTipText("Modify query properties");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/preferences.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setEnabled(false);
        }

        public void run() {
            if (QueriesView.this.currentQuery == null) {
                return;
            }
            QueryDialog dialog = new QueryDialog(QueriesView.this.getSite().getShell(), QueriesView.this.currentQuery.clone(), true);
            int rc = dialog.open();
            if (rc == 1) {
                QueriesView.this.selectQuery(QueriesView.this.currentQuery.getName());
                return;
            }
            QueriesView.this.queryModel.removeQuery(QueriesView.this.currentQuery.getName());
            QueriesView.this.currentQuery = dialog.getResult();
            QueriesView.this.queryModel.addQuery(QueriesView.this.currentQuery);
            if (rc == 0) {
                new ExecuteQueryAction().run();
            }
            if (QueriesView.this.currentQuery != null) {
                QueriesView.this.selectQuery(QueriesView.this.currentQuery.getName());
            }
            if (QueriesView.this.currentQuery.isPin()) {
                UpdatePinJob.run(QueriesView.this.currentQuery);
            }
        }

        public void dispose() {
        }
    }

    class ExecuteQueryAction
    extends Action
    implements ActionFactory.IWorkbenchAction {
        ExecuteQueryAction() {
            this.setText("Fetch and display results");
            this.setToolTipText("Run query and display results");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/run_exc.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setEnabled(false);
        }

        public void run() {
            if (QueriesView.this.currentQuery == null) {
                return;
            }
            if (LfsConnector.getInstance().getConnection() == null) {
                MessageDialog.openError((Shell)QueriesView.this.getSite().getShell(), (String)"Not connected to server", (String)"Please try again when connection regained");
                return;
            }
            QueryDataFetcher fetcher = new QueryDataFetcher(QueriesView.this.currentQuery, true);
            FetchQueryRapidJob job = new FetchQueryRapidJob(fetcher);
            job.setUser(true);
            job.schedule();
        }

        public void dispose() {
        }
    }

    class RemoveQueryAction
    extends Action
    implements ActionFactory.IWorkbenchAction {
        RemoveQueryAction() {
            this.setText("Remove query");
            this.setToolTipText("Remove selected query");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/close.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setEnabled(false);
        }

        public void run() {
            if (QueriesView.this.currentQuery == null) {
                return;
            }
            if (!MessageDialog.openConfirm((Shell)QueriesView.this.getSite().getShell(), (String)"Confirm", (String)"Remove this query?")) {
                return;
            }
            QueriesView.this.queryModel.removeQuery(QueriesView.this.currentQuery.getName());
            QueriesView.this.viewer.getTable().deselectAll();
            if (QueriesView.this.currentQuery.isPin()) {
                UpdatePinJob.run(QueriesView.this.currentQuery);
            }
            QueriesView.this.currentQuery = null;
            QueriesView.this.viewer.refresh();
        }

        public void dispose() {
        }
    }
}

