/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Fontable;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.actions.ShowSourceAction;
import com.moonlit.logfaces.client.editors.LogEditor;
import com.moonlit.logfaces.client.editors.QueryResultsEditor;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.text.MessageBodyStyler;
import com.moonlit.logfaces.client.utils.ContextMenuBuilder;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.net.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class MessageView
extends ViewPart
implements ISelectionListener,
IPartListener,
IPropertyChangeListener,
Fontable {
    public static final String ID = "com.moonlit.logfaces.client.MessageView";
    private StyledText text;
    private LoggingEventVO currentEvent;
    private String FONTID = "lfs.font.messages";
    private MessageBodyStyler styler;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.text = new StyledText(parent, 2818);
        this.text.setWordWrap(true);
        this.styler = new MessageBodyStyler(this.text);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.text.setLayoutData((Object)spec);
        this.text.addLineStyleListener((LineStyleListener)this.styler);
        this.text.addMouseMoveListener((MouseMoveListener)this.styler);
        this.text.setEditable(false);
        this.text.setBackground(EventStyles.BG_LFS);
        this.text.setFont(Application.getFontRegistry().get(this.FONTID));
        this.text.addMouseListener((MouseListener)new ThisMouseAdapter());
        IToolBarManager tManager = this.getViewSite().getActionBars().getToolBarManager();
        tManager.add((IAction)new SourceAction());
        tManager.add((IAction)new CopyAction());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        window.getSelectionService().addPostSelectionListener((ISelectionListener)this);
        window.getPartService().addPartListener((IPartListener)this);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        window.getSelectionService().removePostSelectionListener((ISelectionListener)this);
        window.getPartService().removePartListener((IPartListener)this);
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void display(LoggingEventVO event) {
        this.currentEvent = event;
        if (this.currentEvent == null) {
            this.text.setText("");
            return;
        }
        this.text.setBackground(EventStyles.getInstance().getDefaultBackground(event.getLoggerLevel()));
        this.text.setForeground(EventStyles.getInstance().getDefaultForeground(event.getLoggerLevel()));
        this.text.setText(event.getMessage());
        String sdata = Utils.getSyslogDataJson((LogEvent)this.currentEvent);
        if (StringUtils.hasText(sdata)) {
            this.text.append(String.format("%n%nsyslog structured data:%n%s", sdata));
        }
    }

    public void setFocus() {
    }

    public String getSelection() {
        if (this.text.isDisposed()) {
            return null;
        }
        return this.text.getSelectionText();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection) || part.equals(this)) {
            return;
        }
        if (selection.isEmpty()) {
            this.display(null);
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!(obj instanceof LoggingEventVO)) {
            return;
        }
        this.display((LoggingEventVO)obj);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof QueryResultsEditor || part instanceof LogEditor) {
            this.display(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.FONTID.equals(event.getProperty())) {
            this.text.setFont(Application.getFontRegistry().get(this.FONTID));
        }
    }

    @Override
    public String getFontID() {
        return this.FONTID;
    }

    class CopyAction
    extends Action {
        public CopyAction() {
            this.setText("Copy to clipboard");
            this.setToolTipText("Copy to clipboard");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/copy.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            MessageView.this.text.selectAll();
            MessageView.this.text.copy();
            MessageView.this.text.setSelection(-1);
        }
    }

    class SourceAction
    extends Action {
        public SourceAction() {
            this.setText("Show source code");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/class.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            if (MessageView.this.currentEvent != null) {
                new ShowSourceAction(MessageView.this.currentEvent).run();
            }
        }
    }

    class ThisMouseAdapter
    extends MouseAdapter {
        ThisMouseAdapter() {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button > 1 && MessageView.this.currentEvent != null) {
                String selection = MessageView.this.text.getSelectionText();
                ContextMenuBuilder.buildForControl((Control)MessageView.this.text, MessageView.this.currentEvent, EventAttribute.message.name(), selection.isEmpty() ? MessageView.this.text.getText() : selection);
                return;
            }
            URI uri = MessageView.this.styler.getUriAt(new Point(e.x, e.y));
            if (uri == null) {
                return;
            }
            try {
                Utils.launch(uri);
            }
            catch (Exception ex) {
                Utils.complain(ex.getMessage(), ex);
            }
        }
    }
}

