/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.actions.ReloadRepositoryAction;
import com.moonlit.logfaces.client.editors.LogEditor;
import com.moonlit.logfaces.client.jobs.DeleteRepositoryDataJob;
import com.moonlit.logfaces.client.model.ContextListener;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.RepositoryElement;
import com.moonlit.logfaces.client.model.RepositoryHostModel;
import com.moonlit.logfaces.client.model.RepositoryModel;
import com.moonlit.logfaces.client.utils.ContextMenuBuilder;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.BackingStoreException;

public class HostsView
extends ViewPart
implements IPartListener,
ISelectionListener,
ContextListener {
    private int instanceID = 1;
    public static final String ID = "com.moonlit.logfaces.client.hostsView";
    private TableViewer viewer;
    private Text hostFilter;
    private IEclipsePreferences prefs = Application.getPrefs();
    private IWorkbenchPartSite site;
    private Shell shell;

    public void saveState(IMemento memento) {
        memento.putInteger("lastInstance", this.instanceID);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null && memento.getInteger("lastInstance") != null) {
            this.instanceID = memento.getInteger("lastInstance");
        }
        super.init(site, memento);
        this.shell = site.getShell();
    }

    public void createPartControl(Composite parent) {
        this.site = this.getSite();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        this.hostFilter = new Text(parent, 2048);
        this.hostFilter.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.hostFilter.setText(Application.getPrefs().get("HOST_FILTER", ""));
        this.hostFilter.addKeyListener((KeyListener)new FilterListener());
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.setInput((Object)RepositoryModel.getInstance().getHosts());
        this.viewer.getControl().setBackground(EventStyles.BG_LFS);
        RepositoryModel.getInstance().addContextListener(this);
        IToolBarManager tManager = this.getViewSite().getActionBars().getToolBarManager();
        if (!Application.isServerMode()) {
            tManager.add((IAction)new ReloadRepositoryAction(this.site.getShell()));
        }
        this.hookContextMenu();
        this.site.getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        RepositoryModel.getInstance().removeContextListener(this);
        this.site.getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    @Override
    public void contextChanged() {
        this.refresh();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("perspectivePopup");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)HostsView.this.viewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                ContextMenuBuilder.buildForSelection(manager, selection);
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IAction)new DeleteAction(false));
                if (!Application.isServerMode()) {
                    manager.add((IAction)new DeleteAction(true));
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.site.registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void refresh() {
        if (this.shell.isDisposed()) {
            return;
        }
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!HostsView.this.viewer.getTable().isDisposed()) {
                    HostsView.this.viewer.refresh();
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        TableItem[] items;
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection) || part.equals(this)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!(obj instanceof LoggingEventVO)) {
            return;
        }
        LoggingEventVO event = (LoggingEventVO)obj;
        String host = event.getHostName();
        TableItem[] tableItemArray = items = this.viewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText().equals(host)) {
                this.viewer.getTable().setSelection(item);
                return;
            }
            ++n2;
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof LogEditor) {
            LogEditor myEditor = (LogEditor)part;
            myEditor.getTitle();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    class DeleteAction
    extends Action {
        private boolean includeData;

        public DeleteAction(boolean includeData) {
            this.includeData = includeData;
            this.setText(includeData ? "Remove host data" : "Remove host entries");
            this.setImageDescriptor(MainPlugin.getImageDescriptor(includeData ? "icons/eclipse3_clear.gif" : "icons/close.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            if (HostsView.this.shell.isDisposed()) {
                return;
            }
            HostsView.this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IStructuredSelection selection = (IStructuredSelection)((DeleteAction)DeleteAction.this).HostsView.this.viewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    if (DeleteAction.this.includeData && !MessageDialog.openQuestion((Shell)((DeleteAction)DeleteAction.this).HostsView.this.shell, (String)"Please confirm", (String)"This will remove selected hosts from repository AND all related log data. Depending on the amount of data, the operation may take long time to complete. Not recommended for large databases.\n\nProceed?")) {
                        return;
                    }
                    if (!DeleteAction.this.includeData && !MessageDialog.openQuestion((Shell)((DeleteAction)DeleteAction.this).HostsView.this.shell, (String)"Please confirm", (String)"This will remove selected hosts from repository. Related log data will NOT be removed.\n\nProceed?")) {
                        return;
                    }
                    if (!Application.isServerMode()) {
                        RepositoryEntryVO[] entries = DeleteAction.this.makeRepositoryEntries(selection);
                        DeleteRepositoryDataJob job = new DeleteRepositoryDataJob(entries, DeleteAction.this.includeData);
                        job.setUser(true);
                        job.schedule();
                    } else {
                        List list = selection.toList();
                        for (RepositoryElement element : list) {
                            element.deleteMe();
                        }
                        ((DeleteAction)DeleteAction.this).HostsView.this.viewer.refresh();
                    }
                }
            });
        }

        private RepositoryEntryVO[] makeRepositoryEntries(IStructuredSelection selection) {
            Object[] selected;
            HashSet<RepositoryEntryVO> set = new HashSet<RepositoryEntryVO>();
            Object[] objectArray = selected = selection.toArray();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                String host = ((RepositoryHostModel)o).getName();
                set.add(new RepositoryEntryVO("", host, ""));
                ++n2;
            }
            return set.toArray(new RepositoryEntryVO[set.size()]);
        }
    }

    class FilterListener
    implements KeyListener {
        FilterListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            try {
                HostsView.this.prefs.put("HOST_FILTER", HostsView.this.hostFilter.getText());
                HostsView.this.prefs.flush();
                HostsView.this.refresh();
            }
            catch (BackingStoreException e1) {
                e1.printStackTrace();
            }
        }
    }
}

