/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.gis.GIS;
import com.moonlit.logfaces.client.gis.GisLocation;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.model.data.LogModelEvent;
import com.moonlit.logfaces.client.model.data.LogModelListener;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.widgets.GisComposite;
import com.moonlit.logfaces.client.widgets.LabelContribution;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class GisView
extends ViewPart
implements LogModelListener,
IPartListener,
ISelectionListener {
    public static final String ID = "com.moonlit.logfaces.client.gisView";
    private static final Logger log = LogManager.getLogger(GisView.class);
    private GIS gis = GIS.getInstance();
    private GisComposite gisComposite;
    private boolean disposed;
    private IToolBarManager toolbar;
    private LabelContribution label;
    private LogDataModel model;
    private Set<GisLocation> locations;
    private long lastUpdate;
    private IEclipsePreferences prefs = Application.getPrefs();

    public GisView() {
        LfsEventBus.getInstance().register((Object)this);
    }

    public void createPartControl(Composite parent) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        window.getPartService().addPartListener((IPartListener)this);
        window.getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.toolbar = this.getViewSite().getActionBars().getToolBarManager();
        this.label = new LabelContribution();
        this.toolbar.add((IContributionItem)this.label);
        this.toolbar.add((IContributionItem)new Separator());
        this.toolbar.add((IAction)new SelectionSyncAction());
        this.toolbar.add((IAction)new RefreshAction());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        parent.setLayoutData((Object)new GridData(2, 2, true, true, 1, 1));
        this.gisComposite = new GisComposite(parent);
        parent.layout(true);
        this.gisComposite.setPosition(this.gis.getLastZoom(), this.gis.getLastLat(), this.gis.getLastLon());
        this.pickModel();
        if (this.model != null) {
            this.display(this.model.getSelectedEvent());
        }
    }

    public void dispose() {
        this.disposed = true;
        LfsEventBus.getInstance().unregister((Object)this);
        IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        workbench.getSelectionService().removePostSelectionListener((ISelectionListener)this);
        workbench.getPartService().removePartListener((IPartListener)this);
        if (this.model != null) {
            this.model.removeListener(this);
        }
        this.gisComposite.dispose();
        super.dispose();
    }

    public void setFocus() {
    }

    @Override
    public void modelUpdated(LogModelEvent event) {
        if (this.model == null) {
            return;
        }
        switch (event) {
            case FILTERED: 
            case FINALIZED: {
                this.display(false);
                break;
            }
            case ADDED: {
                if (this.model.getSize() >= 100 && System.currentTimeMillis() - this.lastUpdate <= 5000L) break;
                this.display(false);
                break;
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this) {
            this.pickModel();
            return;
        }
        if (part instanceof LogView) {
            this.setModel(((LogView)part).getModel());
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part == this && this.gisComposite != null && !this.gisComposite.isDisposed()) {
            this.gisComposite.save();
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof LogView && this.model == ((LogView)part).getModel()) {
            this.clear();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        switch (event.getType()) {
            case CONNECTED: 
            case DISCONNECTED: 
            case ALERTS: {
                break;
            }
            case GIS_CONTEXT: {
                this.gisComposite.displayContextMenu((GisLocation)((Object)event.getContext()));
                break;
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.prefs.getBoolean("gis_sync_sel", false)) {
            return;
        }
        if (!(selection instanceof IStructuredSelection) || part.equals(this)) {
            return;
        }
        if (selection.isEmpty()) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof LogEvent) {
            this.display((LogEvent)obj);
        }
    }

    private void clear() {
        this.model = null;
        this.locations.clear();
        this.gisComposite.clear();
    }

    private void pickModel() {
        IEditorPart editor;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (editor = page.getActiveEditor()) != null && editor instanceof LogView) {
            this.setModel(((LogView)editor).getModel());
        }
    }

    private void setModel(LogDataModel newmodel) {
        if (this.model == newmodel) {
            return;
        }
        if (newmodel == null) {
            if (this.model != null) {
                this.model.removeListener(this);
            }
            this.model = null;
            return;
        }
        if (this.model != null) {
            this.model.removeListener(this);
        }
        this.model = newmodel;
        this.model.addListener(this);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    GisView.this.display(false);
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                }
            }
        });
    }

    private void display(boolean refresh) {
        this.updateLabel(String.format("%s", refresh ? "realoading" : "updating"));
        this.locations = this.gis.resolve(this.model.getViewData(), refresh);
        this.gisComposite.display(this.locations, refresh);
        this.updateLabel(String.format("locations: %d   ", this.locations.size()));
        this.lastUpdate = System.currentTimeMillis();
    }

    private void display(LogEvent event) {
        if (event == null) {
            return;
        }
        Set<GisLocation> locations = this.gis.resolve(Lists.newArrayList((Object[])new LogEvent[]{event}), false);
        if (!locations.isEmpty()) {
            this.gisComposite.centerAt(locations);
        }
    }

    private void updateLabel(String text) {
        try {
            if (this.disposed) {
                return;
            }
            this.label.setText(text);
            this.toolbar.update(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class RefreshAction
    extends Action {
        public RefreshAction() {
            this.setToolTipText("Refresh the map");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/eclipse3_update.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GisView.this.display(true);
                }
            });
        }
    }

    class SelectionSyncAction
    extends Action {
        public SelectionSyncAction() {
            super("sync", 2);
            this.setToolTipText("Link with data active data model");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/link.png"));
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setChecked(GisView.this.prefs.getBoolean("gis_sync_sel", false));
        }

        public void run() {
            boolean sync = GisView.this.prefs.getBoolean("gis_sync_sel", false);
            this.setChecked(!sync);
            sync = this.isChecked();
            GisView.this.prefs.putBoolean("gis_sync_sel", this.isChecked());
            log.info("selection {} syncronized", (Object)(GisView.this.prefs.getBoolean("gis_sync_sel", false) ? "is" : "not"));
        }
    }
}

