/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Fontable;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.actions.ShowSourceAction;
import com.moonlit.logfaces.client.editors.LogEditor;
import com.moonlit.logfaces.client.editors.QueryResultsEditor;
import com.moonlit.logfaces.client.jobs.FetchStackTracesJob;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.text.ExceptionStyler;
import com.moonlit.logfaces.client.utils.ContextMenuBuilder;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ExceptionView
extends ViewPart
implements ISelectionListener,
IPartListener,
IPropertyChangeListener,
Fontable {
    private static Logger log = LogManager.getLogger(ExceptionView.class);
    public static final String ID = "com.moonlit.logfaces.client.ExceptionView";
    private StyledText text;
    private String FONTID = "lfs.font.exceptions";
    private LoggingEventVO currentEvent;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.text = new StyledText(parent, 2818);
        ExceptionStyler styler = new ExceptionStyler(this.text);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.text.setLayoutData((Object)spec);
        this.text.addLineStyleListener((LineStyleListener)styler);
        this.text.setEditable(false);
        this.text.addMouseMoveListener((MouseMoveListener)styler);
        this.text.addMouseListener((MouseListener)new TextMouseListener());
        this.text.setFont(Application.getFontRegistry().get(this.FONTID));
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button > 1) {
                    String selection = ExceptionView.this.text.getSelectionText();
                    ContextMenuBuilder.buildForControl((Control)ExceptionView.this.text, ExceptionView.this.currentEvent, EventAttribute.throwableInfo.name(), selection);
                }
            }
        });
        IToolBarManager tManager = this.getViewSite().getActionBars().getToolBarManager();
        tManager.add((IAction)new SourceAction());
        tManager.add((IAction)new CopyAction());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        window.getSelectionService().addPostSelectionListener((ISelectionListener)this);
        window.getPartService().addPartListener((IPartListener)this);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        window.getSelectionService().removePostSelectionListener((ISelectionListener)this);
        window.getPartService().removePartListener((IPartListener)this);
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void display(LoggingEventVO event) {
        this.text.setBackground(Display.getDefault().getSystemColor(1));
        this.currentEvent = event;
        this.text.setText("");
        if (this.currentEvent == null) {
            return;
        }
        if (!event.isThrown()) {
            return;
        }
        this.text.setBackground(EventStyles.getInstance().getDefaultBackground(event.getLoggerLevel()));
        if (!StringUtils.hasText(event.getThrowableInfo())) {
            this.text.setText("fetching stack traces, one moment please..");
            FetchStackTracesJob job = new FetchStackTracesJob(event);
            job.setUser(true);
            job.schedule();
            return;
        }
        this.text.setText(event.getThrowableInfo());
    }

    public void displayNote(String note) {
        this.text.setText(note);
    }

    public void setFocus() {
    }

    protected void showJavaSource(String line) {
        try {
            int offset = this.text.getCaretOffset();
            int ln = this.text.getLineAtOffset(this.text.getCaretOffset());
            int lineOffset = this.text.getOffsetAtLine(ln);
            int from = line.indexOf("(") + 1;
            int to = line.indexOf(")");
            if (from < 0 || to < 0 || offset < from + lineOffset || offset > to + lineOffset) {
                return;
            }
            this.text.setSelection(from + lineOffset, to + lineOffset);
            String temp = line.substring(from, to);
            String[] split = temp.split(":");
            if (split.length != 2) {
                return;
            }
            temp = null;
            from = line.indexOf("at ") + 3;
            to = line.indexOf("(");
            if (from > 0 && to > 0) {
                temp = line.substring(from, to);
                to = temp.lastIndexOf(".");
                temp = temp.substring(0, to);
                to = temp.lastIndexOf(".");
                temp = temp.substring(0, to);
            }
            ShowSourceAction action = new ShowSourceAction(temp, split[0], Integer.parseInt(split[1]));
            action.run();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void showDnetSource(String line) {
        try {
            int offset = this.text.getCaretOffset();
            int ln = this.text.getLineAtOffset(this.text.getCaretOffset());
            int lineOffset = this.text.getOffsetAtLine(ln);
            int from = line.indexOf(") in ") + 5;
            int to = line.length();
            if (offset < from + lineOffset || offset > to + lineOffset) {
                return;
            }
            String location = line.substring(from, to);
            String[] split = location.split(":line ");
            if (split.length != 2) {
                return;
            }
            this.text.setSelection(from + lineOffset, to + lineOffset);
            ShowSourceAction action = new ShowSourceAction(null, split[0], Integer.parseInt(split[1]));
            action.run();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection) || part.equals(this)) {
            return;
        }
        if (selection.isEmpty()) {
            this.display(null);
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!(obj instanceof LoggingEventVO)) {
            return;
        }
        this.display((LoggingEventVO)obj);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof QueryResultsEditor || part instanceof LogEditor) {
            this.display(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.FONTID.equals(event.getProperty())) {
            this.text.setFont(Application.getFontRegistry().get(this.FONTID));
        }
    }

    @Override
    public String getFontID() {
        return this.FONTID;
    }

    class CopyAction
    extends Action {
        public CopyAction() {
            this.setText("Copy to clipboard");
            this.setToolTipText("Copy to clipboard");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/copy.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            ExceptionView.this.text.selectAll();
            ExceptionView.this.text.copy();
            ExceptionView.this.text.setSelection(-1);
        }
    }

    class SourceAction
    extends Action {
        public SourceAction() {
            this.setText("Show source code");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/class.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            if (ExceptionView.this.currentEvent != null) {
                new ShowSourceAction(ExceptionView.this.currentEvent).run();
            }
        }
    }

    class TextMouseListener
    extends MouseAdapter {
        TextMouseListener() {
        }

        public void mouseUp(MouseEvent e) {
            int ln = ExceptionView.this.text.getLineAtOffset(ExceptionView.this.text.getCaretOffset());
            String line = ExceptionView.this.text.getLine(ln);
            if (line.matches(".*at .*(.*:[1-9].*)")) {
                ExceptionView.this.showJavaSource(line);
            } else if (line.matches(".*at .* in .*:line [1-9].*")) {
                ExceptionView.this.showDnetSource(line);
            }
        }
    }
}

