/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.dashboard.SliceInfo;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.jobs.SliceJob;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.model.data.LogDataProjection;
import com.moonlit.logfaces.client.model.data.LogModelEvent;
import com.moonlit.logfaces.client.model.data.LogModelListener;
import com.moonlit.logfaces.client.model.data.NumericPatternProjection;
import com.moonlit.logfaces.client.model.data.RegexPatternProjection;
import com.moonlit.logfaces.client.model.data.SimpleProjection;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.ColorPicker;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.client.views.DistributionDataListener;
import com.moonlit.logfaces.client.widgets.LabelContribution;
import com.moonlit.logfaces.client.widgets.NoteComposite;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.stats.StatCategory;
import com.moonlit.logfaces.server.vo.StatVO;
import java.awt.Color;
import java.awt.Paint;
import java.text.SimpleDateFormat;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.RangeType;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class DistributionView
extends ViewPart
implements Persistent,
DistributionDataListener,
IPartListener,
LogModelListener,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String ID = "com.moonlit.logfaces.client.statsView";
    private IWorkbenchWindow window;
    private Composite parent;
    private LevelRenderer renderer;
    private Composite chartPanel;
    private TimeTableXYDataset dataset;
    private NoteComposite note;
    private LabelContribution label;
    private SimpleDateFormat tipdf = new SimpleDateFormat("HH:mm");
    private SimpleDateFormat daydf = new SimpleDateFormat("dd MMMM");
    private Action[] actions;
    private LogDataModel logModel;
    private TimeRange rate;
    private SliceInfo slice;
    private IToolBarManager toolbar;
    private ColorPicker colorPicker = ColorPicker.getInstance();
    private boolean disposed;
    private boolean initialized;
    private long lastUpdate;
    private IEclipsePreferences prefs = Application.getPrefs();

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(2, false));
        this.load(null);
        this.toolbar = this.getViewSite().getActionBars().getToolBarManager();
        this.actions = new Action[]{new RateComboAction(), new CategoryComboAction(), new RefreshAction()};
        this.label = new LabelContribution();
        this.toolbar.add((IContributionItem)this.label);
        this.toolbar.add((IContributionItem)new Separator());
        this.toolbar.add((IAction)this.actions[0]);
        this.toolbar.add((IAction)this.actions[1]);
        this.toolbar.add((IAction)this.actions[2]);
        this.toolbar.update(true);
        this.createPanels();
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.window.getPartService().addPartListener((IPartListener)this);
        this.prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.linkEditor();
        this.initialized = true;
    }

    private void createPanels() {
        this.showNote("This tool displays distribution of log statements for currently displayed logs in data tables.\nOnce the chart is produced, you can click on its bars to drill into actual log statements.\nYou can also select which of the attributes to use for distribution");
        this.updateLabel();
    }

    private void showNote(String text) {
        if (this.note != null && !this.note.isDisposed()) {
            this.note.dispose();
        }
        if (this.chartPanel != null && !this.chartPanel.isDisposed()) {
            this.chartPanel.dispose();
        }
        this.note = new NoteComposite(this.parent, text);
        this.note.setLayoutData(new GridData(2, 2, true, true, 1, 1));
        this.parent.layout(true);
    }

    private void updateLabel() {
        try {
            if (this.disposed || !this.initialized) {
                return;
            }
            this.label.setText(String.format("%s   ", this.slice.getName()));
            this.toolbar.update(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        this.save(null);
        this.disposed = true;
        if (this.logModel != null) {
            this.logModel.removeListener(this);
        }
        this.window.getPartService().removePartListener((IPartListener)this);
        this.prefs.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        super.dispose();
    }

    public void setFocus() {
    }

    @Override
    public void handleDistributionData(final List<StatVO> stats) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DistributionView.this.note != null && !DistributionView.this.note.isDisposed()) {
                    DistributionView.this.note.dispose();
                }
                if (DistributionView.this.chartPanel != null && !DistributionView.this.chartPanel.isDisposed()) {
                    DistributionView.this.chartPanel.dispose();
                }
                if (stats == null || stats.size() == 0) {
                    DistributionView.this.showNote(String.format("No data for '%s' category", DistributionView.this.slice.getName()));
                    DistributionView.this.lastUpdate = 0L;
                    return;
                }
                DistributionView.this.chartPanel = DistributionView.this.createChartPanel(DistributionView.this.parent, stats);
                GridData gd = new GridData(1808);
                DistributionView.this.chartPanel.setLayoutData((Object)gd);
                DistributionView.this.parent.layout(true);
            }
        });
    }

    private Composite createChartPanel(Composite parent, List<StatVO> stats) {
        this.createDataset(stats);
        JFreeChart chart = this.createChart();
        ChartComposite chartComposite = new ChartComposite(parent, 0, chart, 680, 420, 300, 200, 2600, 2600, true, false, false, false, false, true);
        chartComposite.setRangeZoomable(false);
        chartComposite.setDomainZoomable(false);
        chartComposite.setMenu(null);
        chartComposite.addChartMouseListener((ChartMouseListener)new ThisMouseListener());
        return chartComposite;
    }

    private JFreeChart createChart() {
        DateAxis dateaxis = new DateAxis();
        dateaxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        NumberAxis numberaxis = new NumberAxis("Log events count");
        numberaxis.setRangeType(RangeType.POSITIVE);
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.renderer = new LevelRenderer();
        XYPlot plot = new XYPlot((XYDataset)this.dataset, (ValueAxis)dateaxis, (ValueAxis)numberaxis, (XYItemRenderer)this.renderer);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        chart.setBorderPaint(null);
        return chart;
    }

    private void createDataset(List<StatVO> stats) {
        this.dataset = new TimeTableXYDataset();
        for (StatVO vo : stats) {
            SimpleTimePeriod period = new SimpleTimePeriod(vo.getT1(), vo.getT2());
            this.dataset.add((TimePeriod)period, (double)vo.getCount(), (Comparable)((Object)vo.getProjection()));
        }
    }

    private void drill(TimePeriod period, String series) {
        SliceJob job = null;
        this.slice.setSeries(series);
        CriteriaFilter criteria = Utils.column2criteria(this.slice, period);
        if (criteria.getRules().isEmpty()) {
            return;
        }
        criteria.prepare();
        String title = String.format("%s (%s)", this.slice.getName(), this.slice.getSeries());
        job = new SliceJob(title, this.logModel, criteria);
        if (job != null) {
            job.setUser(true);
            job.schedule();
        }
    }

    private boolean setLogModel(LogDataModel model) {
        if (this.logModel != model) {
            if (this.logModel != null) {
                this.logModel.removeListener(this);
            }
            this.logModel = model;
            if (this.logModel != null) {
                this.logModel.addListener(this);
            }
            return true;
        }
        return false;
    }

    private void displayModelDistribution() {
        if (this.logModel == null) {
            this.createPanels();
            return;
        }
        LogDataProjection projection = this.createProjection();
        this.handleDistributionData(projection.getProjection());
        projection = null;
        this.lastUpdate = System.currentTimeMillis();
    }

    private LogDataProjection createProjection() {
        switch (this.slice.getType()) {
            case regex: {
                return new RegexPatternProjection(this.logModel, this.slice, this.rate);
            }
            case integral: {
                return new NumericPatternProjection(this.logModel, this.slice, this.rate);
            }
        }
        return new SimpleProjection(this.logModel, this.slice, this.rate);
    }

    private void linkEditor() {
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        IEditorPart editor = page.getActiveEditor();
        if (this.setLogModel(editor != null && editor instanceof LogView ? ((LogView)editor).getModel() : null)) {
            this.displayModelDistribution();
        }
    }

    @Override
    public void modelUpdated(LogModelEvent event) {
        if (this.disposed || this.logModel == null) {
            return;
        }
        switch (event) {
            case FILTERED: {
                this.displayModelDistribution();
                break;
            }
            case ADDED: {
                if (this.logModel.getSize() >= 50 && System.currentTimeMillis() - this.lastUpdate <= 10000L) break;
                this.displayModelDistribution();
                break;
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof LogView && this.setLogModel(((LogView)part).getModel())) {
            this.displayModelDistribution();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        this.linkEditor();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("lfs_levels".equals(key) || "lfs_tags".equals(key)) {
            this.colorPicker.init();
            this.displayModelDistribution();
        }
    }

    @Override
    public void load(IMemento memento) {
        IDialogSettings settings = Application.getDialogSettings("DistributionView", true);
        try {
            this.slice = new SliceInfo(StatCategory.valueOf((String)settings.get("slice.type")), EventAttribute.valueOf((String)settings.get("slice.attr")), settings.get("slice.name"));
            this.rate = TimeRange.valueOf(settings.get("rate"));
        }
        catch (Exception e) {
            this.slice = SliceInfo.getAll(false).get(0);
            this.rate = TimeRange.RANGE_1_MIN;
        }
    }

    @Override
    public void save(IMemento memento) {
        IDialogSettings settings = Application.getDialogSettings("DistributionView", true);
        settings.put("slice.type", this.slice.getType().name());
        settings.put("slice.name", this.slice.getName());
        settings.put("slice.attr", this.slice.getAttribute().name());
        settings.put("slice.attr", this.slice.getAttribute().name());
        settings.put("rate", this.rate.name());
    }

    class CategoryAction
    extends Action {
        SliceInfo si;
        CategoryComboAction parent;

        public CategoryAction(SliceInfo si, CategoryComboAction parent) {
            this.si = si;
            this.parent = parent;
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setText(si.getName());
            this.setImageDescriptor(ImageHolder.getInstance().getImageDescriptor(si));
        }

        public void run() {
            DistributionView.this.slice = this.si;
            this.parent.setLastAction(this);
            DistributionView.this.actions[2].run();
            DistributionView.this.updateLabel();
        }
    }

    class CategoryComboAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;
        private Action lastAction;

        public CategoryComboAction() {
            this.setId("cats");
            this.setToolTipText("Select slice category");
            this.setLastAction(new CategoryAction(DistributionView.this.slice, this));
            this.setMenuCreator(this);
            this.setEnabled(true);
        }

        public void setLastAction(Action action) {
            this.lastAction = action;
            this.setImageDescriptor(this.lastAction.getImageDescriptor());
            this.setText(this.lastAction.getText());
            this.setToolTipText(String.format("Category - %s", this.lastAction.getText()));
            DistributionView.this.toolbar.update(true);
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            StatCategory type = StatCategory.attributes;
            for (SliceInfo si : SliceInfo.getAll(false)) {
                if (type != si.getType()) {
                    new Separator("additions").fill(this.fMenu, -1);
                    type = si.getType();
                }
                CategoryAction action = new CategoryAction(si, this);
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(this.fMenu, -1);
            }
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void runWithEvent(Event e) {
            Widget item = e.widget;
            ToolItem ti = (ToolItem)item;
            Menu m = this.getMenu((Control)ti.getParent());
            if (m != null) {
                Rectangle rect = ti.getBounds();
                Point point = ti.getParent().toDisplay(new Point(rect.x, rect.y));
                m.setLocation(point.x, point.y + ti.getParent().getBounds().height);
                m.setVisible(true);
                return;
            }
        }
    }

    class LevelRenderer
    extends StackedXYBarRenderer {
        int selectedRow = -1;
        int selectedCol = -1;

        public LevelRenderer() {
            this.setBaseToolTipGenerator((XYToolTipGenerator)new ThisTooltipsGenerator());
            this.setBaseSeriesVisibleInLegend(false);
            this.setDrawBarOutline(true);
            StandardXYBarPainter painter = new StandardXYBarPainter();
            this.setBarPainter((XYBarPainter)painter);
            this.setShadowVisible(false);
            this.setMargin(0.0);
        }

        public void select(int row, int col) {
            this.selectedRow = row;
            this.selectedCol = col;
            this.notifyListeners(new RendererChangeEvent((Object)this));
        }

        public Paint getItemPaint(int row, int col) {
            String series = DistributionView.this.dataset.getSeriesKey(row).toString();
            Color color = DistributionView.this.colorPicker.pickAwt(series);
            if (row == this.selectedRow && col == this.selectedCol) {
                return color.darker();
            }
            return color;
        }

        public Paint getItemOutlinePaint(int row, int col) {
            if (row == this.selectedRow && col == this.selectedCol) {
                return Color.gray;
            }
            return Color.darkGray;
        }

        public Paint getSeriesOutlinePaint(int row) {
            if (row == this.selectedRow) {
                return Color.gray;
            }
            return Color.gray;
        }
    }

    class RateAction
    extends Action {
        private TimeRange range;
        private RateComboAction parent;

        public RateAction(TimeRange range, RateComboAction parent) {
            this.range = range;
            this.parent = parent;
            this.setId(((Object)((Object)this)).getClass().getName());
            this.setText(range.toString());
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/alignmiddle.gif"));
        }

        public void run() {
            DistributionView.this.rate = this.range;
            this.parent.setLastAction(this);
            DistributionView.this.actions[2].run();
        }
    }

    class RateComboAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;
        private Action lastAction;

        public RateComboAction() {
            this.setId("rates");
            this.setLastAction(new RateAction(DistributionView.this.rate, this));
            this.setMenuCreator(this);
        }

        public void setLastAction(Action action) {
            this.lastAction = action;
            this.setImageDescriptor(this.lastAction.getImageDescriptor());
            this.setText(this.lastAction.getText());
            this.setToolTipText(String.format("Sampling rate - %s", this.lastAction.getText()));
            DistributionView.this.toolbar.update(true);
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            this.addActionToMenu(new RateAction(TimeRange.RANGE_1_HOUR, this));
            this.addActionToMenu(new RateAction(TimeRange.RANGE_30_MIN, this));
            this.addActionToMenu(new RateAction(TimeRange.RANGE_15_MIN, this));
            this.addActionToMenu(new RateAction(TimeRange.RANGE_5_MIN, this));
            this.addActionToMenu(new RateAction(TimeRange.RANGE_1_MIN, this));
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void runWithEvent(Event e) {
            Widget item = e.widget;
            ToolItem ti = (ToolItem)item;
            Menu m = this.getMenu((Control)ti.getParent());
            if (m != null) {
                Rectangle rect = ti.getBounds();
                Point point = ti.getParent().toDisplay(new Point(rect.x, rect.y));
                m.setLocation(point.x, point.y + ti.getParent().getBounds().height);
                m.setVisible(true);
                return;
            }
        }

        protected void addActionToMenu(Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(this.fMenu, -1);
        }
    }

    class RefreshAction
    extends Action {
        public RefreshAction() {
            this.setToolTipText("Refresh time line");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/eclipse3_update.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            DistributionView.this.displayModelDistribution();
        }
    }

    class ThisMouseListener
    implements ChartMouseListener {
        ThisMouseListener() {
        }

        private XYItemEntity trackSelection(ChartMouseEvent event) {
            ChartEntity entity = event.getEntity();
            if (entity != null && entity instanceof XYItemEntity) {
                XYItemEntity item = (XYItemEntity)entity;
                DistributionView.this.renderer.select(item.getSeriesIndex(), item.getItem());
                return item;
            }
            DistributionView.this.renderer.select(-1, -1);
            return null;
        }

        public void chartMouseMoved(ChartMouseEvent event) {
            this.trackSelection(event);
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            try {
                DistributionView.this.window.getActivePage().showView(DistributionView.ID);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
            XYItemEntity item = this.trackSelection(event);
            if (item != null) {
                boolean fullRange = 1 != event.getTrigger().getButton();
                TimeTableXYDataset ds = (TimeTableXYDataset)item.getDataset();
                TimePeriod period = fullRange ? DistributionView.this.logModel.getTimeRange() : ds.getTimePeriod(item.getItem());
                String series = ds.getSeriesKey(item.getSeriesIndex()).toString();
                DistributionView.this.drill(period, series);
            }
        }
    }

    class ThisTooltipsGenerator
    extends CustomXYToolTipGenerator {
        ThisTooltipsGenerator() {
        }

        public String getToolTipText(int series, int item) {
            try {
                TimePeriod period = DistributionView.this.dataset.getTimePeriod(item);
                return String.format("%s %s - %s%n%s (%d)", DistributionView.this.daydf.format(period.getStart()), DistributionView.this.tipdf.format(period.getStart()), DistributionView.this.tipdf.format(period.getEnd()), DistributionView.this.dataset.getSeriesKey(series), DistributionView.this.dataset.getY(series, item).longValue());
            }
            catch (Exception e) {
                return "";
            }
        }
    }
}

