/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Fontable;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.actions.ShowSourceAction;
import com.moonlit.logfaces.client.editors.LogEditor;
import com.moonlit.logfaces.client.editors.QueryResultsEditor;
import com.moonlit.logfaces.client.model.EventStyle;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.client.widgets.TooltipHandler;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.part.ViewPart;

public class DetailsView
extends ViewPart
implements ISelectionListener,
IPartListener,
IEclipsePreferences.IPreferenceChangeListener,
IPropertyChangeListener,
Fontable {
    public static final String ID = "com.moonlit.logfaces.client.DetailsView";
    private String FONTID = "lfs.font.tables";
    private SimpleDateFormat dtf = new SimpleDateFormat("dd-MMM-yy HH:mm:ss.SSS");
    private LogEvent currentEvent;
    private Table table;
    private TooltipHandler tooltip;

    public void createPartControl(Composite parent) {
        IToolBarManager tManager = this.getViewSite().getActionBars().getToolBarManager();
        tManager.add((IAction)new SourceAction());
        tManager.add((IAction)new CopyAction());
        tManager.add((IAction)new CopySelectionAction());
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
        Application.getPrefs().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        int style = 101124;
        this.table = new Table(parent, style);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setBackground(EventStyles.BG_LFS);
        this.table.setFont(Application.getFontRegistry().get(this.FONTID));
        this.tooltip = new TooltipHandler(this.table.getShell());
        Utils.optimizeRowHeight(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button > 1) {
                    if (DetailsView.this.table.getSelectionCount() == 0) {
                        return;
                    }
                    MenuManager manager = new MenuManager();
                    manager.add((IAction)new CopySelectionAction());
                    manager.add((IAction)new CopyAction());
                    DetailsView.this.table.setMenu(manager.createContextMenu((Control)DetailsView.this.table));
                }
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                DetailsView.this.handleMouseMovement(event);
            }
        });
        this.table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                DetailsView.this.tooltip.hideTooltip();
            }
        });
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DetailsView.this.tooltip.hideTooltip();
            }
        });
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setWidth(200);
        column.setResizable(true);
        column = new TableColumn(this.table, 16384, 1);
        column.setResizable(true);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        Application.getPrefs().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    private void displayEventDetails(LoggingEventVO event) {
        EventStyle style = EventStyles.getInstance().getStyle((LogEvent)event);
        TableItem item = new TableItem(this.table, 0);
        item.setText(0, "Time");
        item.setText(1, this.dtf.format(new Date(event.getLoggerTimeStamp())));
        item.setBackground(style.getBackground());
        item.setForeground(style.getForeground());
        item = new TableItem(this.table, 0);
        item.setText(0, "Sequence #");
        item.setText(1, "" + event.getSequenceNumber());
        item.setBackground(style.getBackground());
        item.setForeground(style.getForeground());
        item = new TableItem(this.table, 0);
        item.setText(0, "Severity");
        item.setText(1, LfsLevel.toLevel((int)event.getLoggerLevel()).name());
        item.setBackground(style.getBackground());
        item.setForeground(style.getForeground());
        if (StringUtils.hasText(event.getDomainName())) {
            item = new TableItem(this.table, 0);
            item.setText(0, "Domain");
            item.setText(1, event.getDomainName());
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
        }
        if (StringUtils.hasText(event.getHostName())) {
            item = new TableItem(this.table, 0);
            item.setText(0, "Host");
            item.setText(1, event.getHostName());
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
        }
        if (StringUtils.hasText(event.getLoggerName())) {
            item = new TableItem(this.table, 0);
            item.setText(0, "Logger");
            item.setText(1, event.getLoggerName());
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
        }
        if (StringUtils.hasText(event.getThreadName())) {
            item = new TableItem(this.table, 0);
            item.setText(0, "Thread");
            item.setText(1, event.getThreadName());
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
        }
        if (StringUtils.hasText(event.getLocClassName())) {
            item = new TableItem(this.table, 0);
            item.setText(0, "Class");
            item.setText(1, event.getLocClassName());
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
        }
        if (StringUtils.hasText(event.getLocMethodName())) {
            item = new TableItem(this.table, 0);
            item.setText(0, "Method");
            item.setText(1, event.getLocMethodName());
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
        }
        if (StringUtils.hasText(event.getLocFileName())) {
            item = new TableItem(this.table, 0);
            item.setText(0, "File");
            item.setText(1, event.getLocFileName());
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
        }
        if (StringUtils.hasText(event.getLocLineNumber())) {
            item = new TableItem(this.table, 0);
            item.setText(0, "Line #");
            item.setText(1, event.getLocLineNumber());
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
        }
        Map props = event.getProperties();
        for (String key : props.keySet()) {
            if ("application".equals(key) || "hostname".equals(key)) continue;
            item = new TableItem(this.table, 0);
            String value = (String)props.get(key);
            item.setText(0, key);
            item.setText(1, value != null ? value : "");
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
            if (!item.getText(0).equals("syslog.data")) continue;
            item.setImage(ImageHolder.getInstance().getImage("icons/flag.png"));
        }
        String ndc = event.getNdc();
        if (ndc != null && ndc.length() > 0) {
            item = new TableItem(this.table, 0);
            item.setText(0, "NDC");
            item.setText(1, event.getNdc() != null ? event.getNdc() : "");
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
        }
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.table.redraw();
    }

    private void handleMouseMovement(MouseEvent event) {
        TableItem item = this.table.getItem(new Point(event.x, event.y));
        if (item == null) {
            return;
        }
        if (!item.getText(0).equals("syslog.data")) {
            this.tooltip.hideTooltip();
            return;
        }
        String text = Utils.getSyslogDataJson(this.currentEvent);
        if (StringUtils.hasText(text)) {
            Point p = Display.getCurrent().getCursorLocation();
            this.tooltip.showTooltip(true, p.x + 3, p.y + 3, text);
        }
    }

    public void display(LogEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.removeAll();
        this.currentEvent = event;
        if (this.currentEvent == null) {
            return;
        }
        if (this.currentEvent instanceof LoggingEventVO) {
            this.displayEventDetails((LoggingEventVO)this.currentEvent);
        }
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection) || part.equals(this)) {
            return;
        }
        if (selection.isEmpty()) {
            this.display(null);
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!(obj instanceof LoggingEventVO)) {
            return;
        }
        this.display((LogEvent)((LoggingEventVO)obj));
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof QueryResultsEditor || part instanceof LogEditor) {
            this.display(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event == null) {
            return;
        }
        if (event.getNewValue() == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DetailsView.this.display(DetailsView.this.currentEvent);
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.FONTID.equals(event.getProperty())) {
            this.table.setFont(Application.getFontRegistry().get(this.FONTID));
            Utils.optimizeRowHeight(this.table);
        }
    }

    @Override
    public String getFontID() {
        return this.FONTID;
    }

    class CallerSelector
    implements IHyperlinkListener {
        CallerSelector() {
        }

        public void linkEntered(HyperlinkEvent e) {
        }

        public void linkExited(HyperlinkEvent e) {
        }

        public void linkActivated(HyperlinkEvent e) {
            if (DetailsView.this.currentEvent != null && DetailsView.this.currentEvent instanceof LoggingEventVO) {
                ShowSourceAction action = new ShowSourceAction((LoggingEventVO)DetailsView.this.currentEvent);
                action.run();
            }
        }
    }

    class CopyAction
    extends Action {
        public CopyAction() {
            this.setText("Copy everything to clipboard");
            this.setToolTipText("Copy everything to clipboard");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/copy2.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            Clipboard cb = new Clipboard(Display.getDefault());
            TextTransfer textTransfer = TextTransfer.getInstance();
            cb.setContents(new Object[]{Utils.event2valuePairs(DetailsView.this.currentEvent)}, new Transfer[]{textTransfer});
        }
    }

    class CopySelectionAction
    extends Action {
        public CopySelectionAction() {
            this.setText("Copy this to clipboard");
            this.setToolTipText("Copy selection to clipboard");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/copy.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            TableItem[] selected = DetailsView.this.table.getSelection();
            if (selected == null || selected.length == 0) {
                return;
            }
            Clipboard cb = new Clipboard(Display.getDefault());
            TextTransfer textTransfer = TextTransfer.getInstance();
            cb.setContents(new Object[]{selected[0].getText(1)}, new Transfer[]{textTransfer});
        }
    }

    class SourceAction
    extends Action {
        public SourceAction() {
            this.setText("Open source code");
            this.setToolTipText("Open source code");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/class.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            if (DetailsView.this.currentEvent instanceof LoggingEventVO) {
                ShowSourceAction action = new ShowSourceAction((LoggingEventVO)DetailsView.this.currentEvent);
                action.run();
            }
        }
    }
}

