/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.CountersSetupDialog;
import com.moonlit.logfaces.client.jobs.CounterDataFetcher;
import com.moonlit.logfaces.client.jobs.FetchQueryJob;
import com.moonlit.logfaces.client.model.CounterModel;
import com.moonlit.logfaces.client.model.CounterModelListener;
import com.moonlit.logfaces.client.model.CountersModel;
import com.moonlit.logfaces.client.net.DashboardClient;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class CountersView
extends ViewPart
implements CounterModelListener {
    private static Logger log = LogManager.getLogger(CountersView.class);
    public static final String ID = "com.moonlit.logfaces.client.countersView";
    private static final String SERIES = "lfs dashboard";
    private ThisRenderer renderer;
    private CountersModel model = CountersModel.getInstance();
    private DefaultCategoryDataset dataset;
    private ChartComposite chartComposite;
    private Action[] actions;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        JFreeChart chart = this.createChart(this.createDataset());
        this.chartComposite = new ChartComposite(parent, 0, chart, 680, 420, 300, 200, 2600, 2600, true, false, false, false, false, true);
        this.chartComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.chartComposite.setRangeZoomable(false);
        this.chartComposite.setMenu(null);
        this.chartComposite.addChartMouseListener((ChartMouseListener)new ThisMouseListener());
        this.actions = new Action[]{new SetupAction(), new ResetAction()};
        IToolBarManager tManager = this.getViewSite().getActionBars().getToolBarManager();
        tManager.add((IAction)this.actions[0]);
        tManager.add((IAction)this.actions[1]);
        try {
            DashboardClient.getInstance().activate();
            CountersModel.getInstance().addListener(this);
            LfsEventBus.getInstance().register((Object)this);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void dispose() {
        CountersModel.getInstance().removeListener(this);
        LfsEventBus.getInstance().unregister((Object)this);
        super.dispose();
    }

    public void setFocus() {
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart((String)"", (String)"", (String)"", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        this.renderer = new ThisRenderer();
        chart.setBorderVisible(false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setRenderer((CategoryItemRenderer)this.renderer);
        return chart;
    }

    private void fetchCounterData(int counterNum) {
        try {
            CounterDataFetcher fetcher = new CounterDataFetcher(counterNum);
            FetchQueryJob job = new FetchQueryJob(fetcher);
            job.setUser(true);
            job.schedule();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private CategoryDataset createDataset() {
        this.dataset = new DefaultCategoryDataset();
        List<CounterModel> counters = CountersModel.getInstance().getCounters();
        for (CounterModel counter : counters) {
            this.dataset.addValue((double)counter.getValue(), (Comparable)((Object)SERIES), (Comparable)((Object)counter.getName()));
        }
        return this.dataset;
    }

    private void resetDataset() {
        this.dataset.clear();
        List<CounterModel> counters = CountersModel.getInstance().getCounters();
        for (CounterModel counter : counters) {
            this.dataset.addValue((double)counter.getValue(), (Comparable)((Object)SERIES), (Comparable)((Object)counter.getName()));
        }
    }

    @Override
    public void dashboardUpdated() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CountersView.this.chartComposite.isDisposed()) {
                    return;
                }
                List<CounterModel> counters = CountersModel.getInstance().getCounters();
                for (CounterModel counter : counters) {
                    CountersView.this.dataset.setValue((double)counter.getValue(), (Comparable)((Object)CountersView.SERIES), (Comparable)((Object)counter.getName()));
                }
            }
        });
    }

    @Override
    public void contextChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CountersView.this.chartComposite.isDisposed()) {
                    return;
                }
                JFreeChart chart = CountersView.this.createChart(CountersView.this.createDataset());
                CountersView.this.chartComposite.setChart(chart);
                CountersView.this.chartComposite.update();
            }
        });
    }

    @Subscribe
    public void handleLfcEvent(final LfcEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CountersView.this.chartComposite.isDisposed()) {
                    return;
                }
                if (event.is(LfcEvent.TYPE.CONNECTED)) {
                    CountersView.this.resetDataset();
                    CountersView.this.chartComposite.update();
                    DashboardClient.getInstance().setup();
                }
                if (event.is(LfcEvent.TYPE.DISCONNECTED)) {
                    CountersView.this.resetDataset();
                    CountersView.this.chartComposite.update();
                }
            }
        });
    }

    class ResetAction
    extends Action {
        public ResetAction() {
            this.setToolTipText("Reset all counters");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_clear.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            try {
                DashboardClient.getInstance().resetAll();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class SetupAction
    extends Action {
        public SetupAction() {
            this.setToolTipText("Setup counters");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/preferences.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            CountersSetupDialog dialog = new CountersSetupDialog((IWorkbenchPartSite)CountersView.this.getViewSite());
            if (dialog.open() != 0) {
                return;
            }
            CountersView.this.resetDataset();
            CountersView.this.chartComposite.update();
            DashboardClient.getInstance().setup();
        }
    }

    class ThisMouseListener
    implements ChartMouseListener {
        ThisMouseListener() {
        }

        private CategoryItemEntity trackSelection(ChartMouseEvent event) {
            ChartEntity entity = event.getEntity();
            if (entity != null && entity instanceof CategoryItemEntity) {
                CategoryItemEntity item = (CategoryItemEntity)entity;
                CountersView.this.renderer.setSelected(item.getSeries(), item.getCategoryIndex());
                return item;
            }
            CountersView.this.renderer.setSelected(-1, -1);
            return null;
        }

        public void chartMouseMoved(ChartMouseEvent event) {
            this.trackSelection(event);
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            CounterModel counter;
            CategoryItemEntity item = this.trackSelection(event);
            if (1 == event.getTrigger().getButton() && item != null && (counter = CountersView.this.model.getCounterByIndex(item.getCategoryIndex())) != null) {
                CountersView.this.fetchCounterData(counter.getID());
            }
        }
    }

    class ThisRenderer
    extends BarRenderer {
        GradientPaint normal = new GradientPaint(0.0f, 0.0f, new Color(21, 89, 180), 0.0f, 0.0f, new Color(0, 0, 64));
        GradientPaint selected = new GradientPaint(0.0f, 0.0f, new Color(23, 53, 93), 0.0f, 0.0f, new Color(0, 0, 64));
        int selectedRow = -1;
        int selectedCol = -1;

        public ThisRenderer() {
            this.setBaseToolTipGenerator((CategoryToolTipGenerator)new ThisTooltipsGenerator());
            this.setDrawBarOutline(false);
            this.setBarPainter((BarPainter)new StandardBarPainter());
            this.setShadowVisible(false);
        }

        public void setSelected(int row, int col) {
            this.selectedRow = row;
            this.selectedCol = col;
            this.notifyListeners(new RendererChangeEvent((Object)this));
        }

        public Paint getItemPaint(int row, int column) {
            if (row == this.selectedRow && column == this.selectedCol) {
                return this.selected;
            }
            return this.normal;
        }
    }

    class ThisTooltipsGenerator
    extends StandardCategoryToolTipGenerator {
        ThisTooltipsGenerator() {
        }

        public String generateToolTip(CategoryDataset dataset, int row, int column) {
            CounterModel counter = CountersView.this.model.getCounterByIndex(column);
            if (counter == null) {
                return "";
            }
            return String.format("%s: %d", counter.getName(), dataset.getValue(row, column).longValue());
        }
    }
}

