/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.dialogs.ListSelectionDialog;
import com.moonlit.logfaces.client.model.ChoiceModel;
import com.moonlit.logfaces.client.model.ComponentModel;
import com.moonlit.logfaces.client.model.ComponentPackageModel;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.ContextListener;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.RepositoryModel;
import com.moonlit.logfaces.client.utils.ContextMenuBuilder;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;

public class ComponentView
extends ViewPart {
    private TreeViewer viewer;
    private IWorkbenchPartSite site;
    private ComponentsModel model;
    public static final String ID = "com.moonlit.logfaces.client.componentsView";

    public void createPartControl(Composite parent) {
        this.site = this.getSite();
        this.model = ComponentsModel.getInstance();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        this.viewer = new TreeViewer(parent, 2818);
        this.viewer.setColumnProperties(new String[]{"col1"});
        this.site.setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setInput((Object)ComponentsModel.getInstance());
        this.viewer.getControl().setBackground(EventStyles.BG_LFS);
        this.viewer.getTree().setFocus();
        TextCellEditor textEditor = new TextCellEditor((Composite)this.viewer.getTree());
        this.viewer.setCellEditors(new CellEditor[]{textEditor});
        this.viewer.setCellModifier((ICellModifier)new NameModifier());
        ComponentsModel.getInstance().addContextListener(new ContextListener(){

            @Override
            public void contextChanged() {
                ComponentView.this.refresh();
            }
        });
        TreeViewerEditor.create((TreeViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 4;
            }
        }, (int)1);
        IToolBarManager tManager = this.getViewSite().getActionBars().getToolBarManager();
        tManager.add((IAction)new AddAction());
        tManager.add((IAction)new DeleteAllAction());
        this.hookContextMenu();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void refresh() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ComponentView.this.viewer.getTree().isDisposed()) {
                    ComponentView.this.viewer.refresh();
                }
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("perspectivePopup");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)ComponentView.this.viewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (selection.size() == 1 && selection.getFirstElement() instanceof ComponentModel) {
                    manager.add((IAction)new RenameAction((ComponentModel)selection.getFirstElement()));
                    manager.add((IAction)new RepackageAction((ComponentModel)selection.getFirstElement()));
                    manager.add((IContributionItem)new Separator("additions"));
                    ContextMenuBuilder.buildForSelection(manager, selection);
                    manager.add((IContributionItem)new Separator("additions"));
                    manager.add((IContributionItem)new Separator("additions"));
                    manager.add((IAction)new DeleteComponentAction((ComponentModel)selection.getFirstElement()));
                    return;
                }
                if (selection.size() == 1 && selection.getFirstElement() instanceof ComponentPackageModel) {
                    ContextMenuBuilder.buildForSelection(manager, selection);
                    manager.add((IContributionItem)new Separator("additions"));
                    manager.add((IAction)new DeletePackageAction());
                    return;
                }
                if (selection.size() > 1 && ComponentView.this.isComponentSelection(selection)) {
                    ContextMenuBuilder.buildForSelection(manager, selection);
                    manager.add((IContributionItem)new Separator("additions"));
                    manager.add((IAction)new DeleteComponentAction((ComponentModel)selection.getFirstElement()));
                    return;
                }
                if (selection.size() > 1 && ComponentView.this.isPackageSelection(selection)) {
                    ContextMenuBuilder.buildForSelection(manager, selection);
                    manager.add((IContributionItem)new Separator("additions"));
                    manager.add((IAction)new DeletePackageAction());
                    return;
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private boolean isPackageSelection(IStructuredSelection selection) {
        Object[] objects;
        Object[] objectArray = objects = selection.toArray();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!(o instanceof ComponentPackageModel)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isComponentSelection(IStructuredSelection selection) {
        Object[] objects;
        Object[] objectArray = objects = selection.toArray();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!(o instanceof ComponentModel)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    class AddAction
    extends Action {
        public AddAction() {
            this.setText("Add new component");
            this.setToolTipText("Add new component");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/add.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            ChoiceModel choice = new ChoiceModel(RepositoryModel.getInstance().getPackageNames());
            ListSelectionDialog dialog = new ListSelectionDialog("Select packages for new component", "/icons/package_obj.gif", choice);
            if (dialog.open() != 0) {
                return;
            }
            InputDialog input = new InputDialog(ComponentView.this.site.getShell(), "How would you like to call this component ?", "Component name:", "", null);
            input.open();
            if (input.getReturnCode() != 0) {
                return;
            }
            String name = input.getValue();
            if (name.length() == 0) {
                return;
            }
            ComponentView.this.model.addComponent(name, choice.getSelectionAsString());
        }
    }

    class DeleteAllAction
    extends Action {
        public DeleteAllAction() {
            this.setText("Delete all components");
            this.setToolTipText("Remove all components");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_clear.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            if (ComponentView.this.model.getComponentNames().size() > 0 && !MessageDialog.openQuestion((Shell)ComponentView.this.site.getShell(), (String)"Please confirm", (String)"Delete ALL compnents?")) {
                return;
            }
            ComponentView.this.model.clear();
        }
    }

    class DeleteComponentAction
    extends Action {
        public DeleteComponentAction(ComponentModel componentModel) {
            this.setText("Delete");
            this.setToolTipText("Delete selected components");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/close.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            if (!MessageDialog.openQuestion((Shell)ComponentView.this.site.getShell(), (String)"Please confirm", (String)"Delete selected components?")) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)ComponentView.this.viewer.getSelection();
            List list = selection.toList();
            for (ComponentModel cm : list) {
                ComponentView.this.model.removeComponent(cm.getName());
            }
        }
    }

    class DeletePackageAction
    extends Action {
        public DeletePackageAction() {
            this.setText("Delete");
            this.setToolTipText("Delete selected");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/close.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)ComponentView.this.viewer.getSelection();
            List list = selection.toList();
            for (ComponentPackageModel pm : list) {
                ComponentModel cm = (ComponentModel)pm.getParent();
                cm.removePackage(pm);
                ComponentView.this.model.rehash(cm);
            }
        }
    }

    class NameModifier
    implements ICellModifier {
        NameModifier() {
        }

        public boolean canModify(Object element, String property) {
            return element instanceof ComponentModel;
        }

        public Object getValue(Object element, String property) {
            if (!(element instanceof ComponentModel)) {
                return null;
            }
            return ((ComponentModel)element).getName();
        }

        public void modify(Object element, String property, Object value) {
            ComponentModel component = (ComponentModel)((TreeItem)element).getData();
            ComponentView.this.model.renameComponent(component.getName(), (String)value);
        }
    }

    class RenameAction
    extends Action {
        ComponentModel componentModel;

        public RenameAction(ComponentModel componentModel) {
            this.componentModel = componentModel;
            this.setText("Rename this component");
            this.setToolTipText("Rename component");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_edit.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            ComponentView.this.viewer.editElement((Object)this.componentModel, 0);
        }
    }

    class RepackageAction
    extends Action {
        ComponentModel componentModel;

        public RepackageAction(ComponentModel componentModel) {
            this.setText("Repackage this component");
            this.setToolTipText("Repackage this component");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/package_obj.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
            this.componentModel = componentModel;
        }

        public void run() {
            ChoiceModel choice = new ChoiceModel(RepositoryModel.getInstance().getPackageNames());
            choice.selectItems(this.componentModel.getPackageNames());
            ListSelectionDialog dialog = new ListSelectionDialog("Select packages for this component", "/icons/package_obj.gif", choice);
            if (dialog.open() != 0) {
                return;
            }
            this.componentModel.setPackages(choice.getSelectionAsString());
            ComponentView.this.model.rehash(this.componentModel);
        }
    }
}

