/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.moonlit.logfaces.client.model.EventStyles;
import java.awt.Color;
import java.awt.Paint;
import java.util.Random;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class Charter {
    private StackedRenderer renderer;
    private static final Random random = new Random(0L);

    public Charter() {
        Display display = new Display();
        Shell shell = new Shell(display);
        RowLayout layout = new RowLayout();
        layout.type = 256;
        layout.fill = true;
        shell.setLayout((Layout)layout);
        int i = 0;
        while (i <= 4) {
            JFreeChart chart = this.createPieChart();
            ChartComposite chartComposite = new ChartComposite((Composite)shell, 0, chart, 680, 420, 680, 420, 2600, 2600, true, false, false, false, false, true);
            chartComposite.setLayoutData((Object)new RowData(300, 200));
            chartComposite.setRangeZoomable(false);
            chartComposite.setMenu(null);
            chartComposite.setBackground(EventStyles.BG_LFS);
            ++i;
        }
        shell.setSize(800, 600);
        shell.open();
        shell.layout(true);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    protected JFreeChart createChart(TimeSeriesCollection data) {
        JFreeChart chart = ChartFactory.createXYBarChart((String)"Title", null, (boolean)true, (String)"Event counts", (IntervalXYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBorderVisible(false);
        chart.setBorderPaint(null);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setRenderer((XYItemRenderer)new BarsRenderer());
        return chart;
    }

    private JFreeChart createStackedChart(TableXYDataset tablexydataset) {
        DateAxis dateaxis = new DateAxis();
        dateaxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        NumberAxis numberaxis = new NumberAxis("Event counts");
        this.renderer = new StackedRenderer();
        XYPlot plot = new XYPlot((XYDataset)tablexydataset, (ValueAxis)dateaxis, (ValueAxis)numberaxis, (XYItemRenderer)this.renderer);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        JFreeChart chart = new JFreeChart(null, (Plot)plot);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        chart.setBorderPaint(null);
        return chart;
    }

    protected JFreeChart createPieChart() {
        DefaultPieDataset piedataset = new DefaultPieDataset();
        piedataset.setValue((Comparable)((Object)"a"), 30.0);
        piedataset.setValue((Comparable)((Object)"s"), 40.0);
        piedataset.setValue((Comparable)((Object)"d"), 50.0);
        piedataset.setValue((Comparable)((Object)"v"), 60.0);
        piedataset.setValue((Comparable)((Object)"h"), 333.0);
        JFreeChart chart = ChartFactory.createPieChart((String)"Exceptions", (PieDataset)piedataset, (boolean)false, (boolean)true, (boolean)true);
        chart.setBorderVisible(false);
        PiePlot plot = (PiePlot)chart.getPlot();
        float foreground = 0.8f;
        plot.setNoDataMessage("No data");
        plot.setIgnoreZeroValues(true);
        plot.setOutlineVisible(false);
        plot.setForegroundAlpha(0.8f);
        plot.setBackgroundPaint(null);
        plot.setOutlineStroke(null);
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("{0} = {1} ({2})"));
        plot.setLabelLinksVisible(false);
        plot.setLabelGenerator(null);
        plot.setSimpleLabels(true);
        return chart;
    }

    private CategoryDataset createPieDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(30.0, (Comparable)((Object)"Exceptions"), (Comparable)((Object)"e1"));
        dataset.addValue(30.0, (Comparable)((Object)"Exceptions"), (Comparable)((Object)"e2"));
        dataset.addValue(30.0, (Comparable)((Object)"Exceptions"), (Comparable)((Object)"e3"));
        dataset.addValue(30.0, (Comparable)((Object)"Exceptions"), (Comparable)((Object)"e4"));
        dataset.addValue(30.0, (Comparable)((Object)"Hosts"), (Comparable)((Object)"h1"));
        dataset.addValue(30.0, (Comparable)((Object)"Hosts"), (Comparable)((Object)"h2"));
        dataset.addValue(30.0, (Comparable)((Object)"Hosts"), (Comparable)((Object)"h3"));
        dataset.addValue(30.0, (Comparable)((Object)"Hosts"), (Comparable)((Object)"h4"));
        dataset.addValue(30.0, (Comparable)((Object)"Domains"), (Comparable)((Object)"a1"));
        dataset.addValue(30.0, (Comparable)((Object)"Domains"), (Comparable)((Object)"a2"));
        dataset.addValue(30.0, (Comparable)((Object)"Domains"), (Comparable)((Object)"a3"));
        dataset.addValue(30.0, (Comparable)((Object)"Domains"), (Comparable)((Object)"a4"));
        return dataset;
    }

    public TimeSeriesCollection createDataset() {
        TimeSeries hitsByHourData = new TimeSeries((Comparable)((Object)"Hits"), Hour.class);
        Day day = new Day(1, 1, 2004);
        int i = 0;
        while (i < 24) {
            hitsByHourData.add((RegularTimePeriod)new Hour(i, day), (double)random.nextInt(20));
            ++i;
        }
        TimeSeriesCollection hitsByHourDataset = new TimeSeriesCollection(hitsByHourData);
        return hitsByHourDataset;
    }

    private TableXYDataset createStackedDataset() {
        TimeTableXYDataset ds = new TimeTableXYDataset();
        Day day = new Day();
        int i = 0;
        while (i < 24) {
            Hour hour = new Hour(i, day);
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"A"));
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"B"));
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"C"));
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"D"));
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"E"));
            ds.add((TimePeriod)hour, (double)random.nextInt(20), (Comparable)((Object)"F"));
            ++i;
        }
        return ds;
    }

    public static void main(String[] args) {
        new Charter();
    }

    class BarsRenderer
    extends XYBarRenderer {
        public BarsRenderer() {
            this.setDrawBarOutline(false);
            this.setBarPainter((XYBarPainter)new StandardXYBarPainter());
            this.setShadowVisible(false);
            this.setSeriesPaint(0, Color.blue);
            this.setMargin(0.2);
        }

        public Paint getItemPaint(int row, int column) {
            return Color.blue;
        }
    }

    class StackedRenderer
    extends StackedXYBarRenderer {
        int selectedRow = -1;
        int selectedCol = -1;
        private Color[] colors = new Color[]{new Color(230, 240, 255), new Color(240, 255, 240), new Color(255, 255, 255), new Color(255, 255, 240), new Color(255, 240, 240), new Color(240, 240, 240)};

        public StackedRenderer() {
            this.setDrawBarOutline(true);
            this.setBarPainter((XYBarPainter)new StandardXYBarPainter());
            this.setShadowVisible(false);
            this.setSeriesPaint(0, Color.blue);
            this.setMargin(0.2);
        }

        public void select(int row, int col) {
            this.selectedRow = row;
            this.selectedCol = col;
            this.notifyListeners(new RendererChangeEvent((Object)this));
        }

        public Paint getItemPaint(int row, int col) {
            if (row == this.selectedRow && col == this.selectedCol) {
                return Color.pink;
            }
            return this.colors[row];
        }
    }

    class ThisMouseListener
    implements ChartMouseListener {
        ThisMouseListener() {
        }

        public void chartMouseMoved(ChartMouseEvent event) {
        }

        public void chartMouseClicked(ChartMouseEvent event) {
            ChartEntity entity = event.getEntity();
            if (entity != null && entity instanceof XYItemEntity) {
                XYItemEntity item = (XYItemEntity)entity;
                Charter.this.renderer.select(item.getSeriesIndex(), item.getItem());
                return;
            }
            Charter.this.renderer.select(-1, -1);
        }
    }
}

