/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.views;

import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Fontable;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.jobs.AckAlertsJob;
import com.moonlit.logfaces.client.jobs.FetchQueryRapidJob;
import com.moonlit.logfaces.client.jobs.QueryDataFetcher;
import com.moonlit.logfaces.client.model.EventStyle;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.client.widgets.TooltipHandler;
import com.moonlit.logfaces.server.util.LfsEventBus;
import com.moonlit.logfaces.server.vo.AlertVO;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class AlertsView
extends ViewPart
implements IEclipsePreferences.IPreferenceChangeListener,
IPropertyChangeListener,
Fontable {
    public static final String ID = "com.moonlit.logfaces.client.alertsView";
    private String FONTID = "lfs.font.tables";
    private SimpleDateFormat dtf = new SimpleDateFormat("dd-MMM-yy HH:mm:ss");
    private AlertVO selected;
    private TableViewer viewer;
    private Table table;
    private TooltipHandler tooltip;

    public AlertsView() {
        LfsEventBus.getInstance().register((Object)this);
    }

    public void createPartControl(Composite parent) {
        IToolBarManager tManager = this.getViewSite().getActionBars().getToolBarManager();
        tManager.add((IAction)new AckAllAlertsAction());
        Application.getPrefs().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        this.viewer = new TableViewer(parent, 68356);
        this.table = this.viewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setBackground(EventStyles.BG_LFS);
        this.table.setFont(Application.getFontRegistry().get(this.FONTID));
        TableColumn col = new TableColumn(this.table, 16384);
        col.setText("");
        col.setResizable(true);
        col = new TableColumn(this.table, 16384);
        col.setText("Time");
        col.setResizable(true);
        col = new TableColumn(this.table, 16384);
        col.setText("Name");
        col.setResizable(true);
        col = new TableColumn(this.table, 16384);
        col.setText("Details");
        col.setResizable(true);
        this.tooltip = new TooltipHandler(this.table.getShell());
        Utils.optimizeRowHeight(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                new QueryAlertAction().run();
            }

            public void mouseDown(MouseEvent e) {
                if (e.button > 1) {
                    if (AlertsView.this.table.getSelectionCount() == 0) {
                        return;
                    }
                    AlertsView.this.selected = AlertsView.this.getSelectedAlert();
                    MenuManager manager = new MenuManager();
                    manager.add((IAction)new QueryAlertAction());
                    manager.add((IAction)new AckAlertAction());
                    AlertsView.this.table.setMenu(manager.createContextMenu((Control)AlertsView.this.table));
                }
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                AlertsView.this.handleMouseMovement(event);
            }
        });
        this.table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                AlertsView.this.tooltip.hideTooltip();
            }
        });
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AlertsView.this.tooltip.hideTooltip();
            }
        });
        this.updateTable();
    }

    public void dispose() {
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this);
        LfsEventBus.getInstance().unregister((Object)this);
        super.dispose();
    }

    private void handleMouseMovement(MouseEvent event) {
        TableItem item = this.table.getItem(new Point(event.x, event.y));
        if (item == null) {
            return;
        }
        AlertVO alert = (AlertVO)item.getData();
        if (alert == null) {
            return;
        }
        String text = String.format("%s%n%s%n%s", this.dtf.format(new Date(alert.getTime())), alert.getName(), alert.getDescription());
        if (StringUtils.hasText(text)) {
            Point p = Display.getCurrent().getCursorLocation();
            this.tooltip.showTooltip(true, p.x + 3, p.y + 20, text);
        }
    }

    public void updateTable() {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.removeAll();
        for (AlertVO alert : LfsConnector.getInstance().getAlerts()) {
            EventStyle style = EventStyles.getInstance().getStyle(alert.getLevel());
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)alert);
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
            item.setImage(style.getImage());
            item.setText(0, "");
            item.setText(1, this.dtf.format(new Date(alert.getTime())));
            item.setText(2, alert.getName());
            item.setText(3, alert.getDescription());
        }
        int size = this.table.getColumnCount();
        int i = 0;
        while (i < size) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.table.redraw();
    }

    private AlertVO getSelectedAlert() {
        TableItem[] selected = this.table.getSelection();
        return selected != null && selected.length > 0 ? (AlertVO)selected[0].getData() : null;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("show_alerts".equals(key)) {
            if (Application.getPrefs().getBoolean("show_alerts", true)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AlertsView.this.updateTable();
                    }
                });
            } else {
                this.dispose();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.FONTID.equals(event.getProperty())) {
            this.table.setFont(Application.getFontRegistry().get(this.FONTID));
            Utils.optimizeRowHeight(this.table);
        }
    }

    @Override
    public String getFontID() {
        return this.FONTID;
    }

    public void setFocus() {
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        if (event.is(LfcEvent.TYPE.CONNECTED) || event.is(LfcEvent.TYPE.DISCONNECTED) || event.is(LfcEvent.TYPE.ALERTS)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AlertsView.this.updateTable();
                }
            });
        }
    }

    class AckAlertAction
    extends Action {
        public AckAlertAction() {
            this.setText("Acknowledge selected");
            this.setToolTipText("Acknowledge selected alerts");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_remove.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            if (AlertsView.this.selected != null) {
                new AckAlertsJob(AlertsView.this.selected, () -> AlertsView.this.updateTable()).schedule();
            }
        }
    }

    class AckAllAlertsAction
    extends Action {
        public AckAllAlertsAction() {
            this.setText("Acknowledge all alerts");
            this.setToolTipText("Acknowledge all outstanding alerts");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/removeall.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            AlertsView.this.table.removeAll();
            AlertsView.this.table.redraw();
            new AckAlertsJob(() -> AlertsView.this.updateTable()).schedule();
        }
    }

    class QueryAlertAction
    extends Action {
        public QueryAlertAction() {
            this.setText("Query related events");
            this.setToolTipText("Query alert related events");
            this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/query.gif"));
            this.setId(((Object)((Object)this)).getClass().getName());
        }

        public void run() {
            AlertVO alert = AlertsView.this.getSelectedAlert();
            if (alert != null) {
                FetchQueryRapidJob job = new FetchQueryRapidJob(new QueryDataFetcher(alert));
                job.setUser(true);
                job.schedule();
            }
        }
    }
}

