/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.dashboard.SliceInfo;
import com.moonlit.logfaces.client.dialogs.ComboInputDialog;
import com.moonlit.logfaces.client.dialogs.OptionalMessageDialog;
import com.moonlit.logfaces.client.editors.LogEditor;
import com.moonlit.logfaces.client.editors.LogEditorInput;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.editors.QueryResultsEditor;
import com.moonlit.logfaces.client.editors.QueryResultsInput;
import com.moonlit.logfaces.client.jobs.Fetcher;
import com.moonlit.logfaces.client.model.ComponentModel;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.LogHeaderInfoVO;
import com.moonlit.logfaces.client.model.LogPerspectivesModel;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.model.RegexModel;
import com.moonlit.logfaces.client.model.RegexVO;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.net.ConnectionProfile;
import com.moonlit.logfaces.client.types.FileFormat;
import com.moonlit.logfaces.client.utils.LogViewWriter;
import com.moonlit.logfaces.client.utils.Sound;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.core.ReceiverType;
import com.moonlit.logfaces.server.criteria.Condition;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.criteria.Rule;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.util.LogFile;
import com.moonlit.logfaces.server.util.Patterns;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.awt.Color;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.osgi.framework.Version;

public class Utils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static long lastNudge;
    private static final Map<String, Object> contextVars;
    public static Gson gson;
    private static Logger log;

    static {
        contextVars = Maps.newHashMap();
        gson = new GsonBuilder().setPrettyPrinting().create();
        log = LogManager.getLogger(Utils.class);
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (inString == null) {
            return null;
        }
        if (oldPattern == null || newPattern == null) {
            return inString;
        }
        StringBuffer sbuf = new StringBuffer();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sbuf.append(inString.substring(pos, index));
            sbuf.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sbuf.append(inString.substring(pos));
        return sbuf.toString();
    }

    public static PatternLayout makePatternLayout(TimeZone timeZone) {
        IPreferencesService service = Platform.getPreferencesService();
        String pattern = service.getString("com.moonlit.logfaces.client.plugin", "lfs_pattern_layout", "[%-5p] %d{dd MMM yyyy HH:mm:ss} %-20C{1} - %m%n", null);
        int index = pattern.indexOf("%d{");
        if (index != -1) {
            timeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
            if ((index = pattern.indexOf("}", index)) != -1) {
                if (pattern.charAt(index + 1) == '{') {
                    int index2 = pattern.indexOf("}", index + 1);
                    String temp = pattern.substring(index + 1, index2 + 1);
                    pattern = Utils.replace(pattern, temp, "{" + timeZone.getID() + "}");
                } else {
                    int from = pattern.indexOf("%d{") + 2;
                    int to = pattern.indexOf("}", from) + 1;
                    String date = pattern.substring(from, to);
                    String datezone = date + "{" + timeZone.getID() + "}";
                    pattern = Utils.replace(pattern, date, datezone);
                }
            }
        }
        return PatternLayout.newBuilder().withPattern(pattern).build();
    }

    public static String formatEvents(TableItem[] selection, TimeZone tz) {
        StringBuffer buff = new StringBuffer();
        PatternLayout layout = Utils.makePatternLayout(tz);
        TableItem[] tableItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            try {
                org.apache.logging.log4j.core.LogEvent event = ((LoggingEventVO)item.getData()).toLoggingEvent();
                String line = layout.toSerializable(event);
                buff.append(line);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return buff.toString();
    }

    public static void launchExternalEditor(String fileName, int line) {
        String editor = Application.getPrefs().get("lfs_text_editor", Util.isMac() ? "/usr/bin/open" : "");
        String params = Application.getPrefs().get("lfs_editor_params", "${file}");
        while (!new File(editor).exists()) {
            if (MessageDialog.openConfirm((Shell)Application.getShell(), (String)"No external editor", (String)("In order to open results in text editor, we need to know its location. This should be done only once in Preferences." + LINE_SEPARATOR + LINE_SEPARATOR + "Would you like to specify your favorite text editor now?"))) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"com.moonlit.logfaces.client.prefs.files", (String[])new String[]{"com.moonlit.logfaces.client.prefs.files"}, null);
                if (dialog.open() == 1) {
                    return;
                }
                editor = Application.getPrefs().get("lfs_text_editor", Util.isMac() ? "/usr/bin/open" : "");
                continue;
            }
            return;
        }
        try {
            params = StringUtils.replace(params, "${file}", fileName);
            params = StringUtils.replace(params, "${line}", "" + line);
            String[] split = StringUtils.split(params, " ");
            String[] command = new String[]{editor, params};
            if (split != null) {
                command = new String[split.length + 1];
                command[0] = editor;
                int i = 1;
                while (i <= split.length) {
                    command[i] = split[i - 1];
                    ++i;
                }
            }
            Runtime.getRuntime().exec(command);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Application.getShell(), (String)"Failed to launch text editor", (String)e.getMessage());
        }
    }

    public static void launch(URI uri) throws Exception {
        if (Util.isWindows() && Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(uri);
        } else if (Util.isMac()) {
            Runtime.getRuntime().exec("open " + uri.toString());
        } else if (Util.isLinux()) {
            Runtime.getRuntime().exec("xdg-open " + uri.toString());
        }
    }

    public static void complain(String message, Throwable exception) {
        log.error(message, exception);
        Status status = new Status(4, "com.moonlit.logfaces.client.plugin", message, exception);
        StatusManager.getManager().handle((IStatus)status, 3);
    }

    public static Point getCenterPoint(Point size) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Rectangle shellBounds = window.getShell().getBounds();
        return new Point(shellBounds.x + (shellBounds.width - size.x) / 2, shellBounds.y + (shellBounds.height - size.y) / 2);
    }

    public static void displayPopup(final String title, final String message, final boolean error) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!error) {
                    MessageDialog.openInformation((Shell)Application.getShell(), (String)title, (String)message);
                } else {
                    MessageDialog.openError((Shell)Application.getShell(), (String)title, (String)message);
                }
            }
        });
    }

    public static void displayOptionalMessage(final String title, final String message, final String key) {
        if (Application.getPrefs().getBoolean(key, false)) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                OptionalMessageDialog.open(title, message, key);
            }
        });
    }

    public static void displayOneTimeTip(String key, String message) {
        if (!Application.getPrefs().getBoolean(key, false)) {
            Application.getPrefs().putBoolean(key, true);
            Utils.displayPopup("One time tip", message, false);
        }
    }

    public static void displayOneTimeTipModal(String key, String message) {
        if (!Application.getPrefs().getBoolean(key, false)) {
            Application.getPrefs().putBoolean(key, true);
            MessageDialog.openInformation((Shell)Application.getShell(), (String)"One time tip", (String)message);
        }
    }

    public static void displayWarning(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)Application.getShell(), (String)title, (String)message);
            }
        });
    }

    public static void displayException(final String title, final String msg, final Throwable t) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                String trace = sw.toString();
                ArrayList childStatuses = Lists.newArrayList();
                String[] stringArray = trace.split(System.getProperty("line.separator"));
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    childStatuses.add(new Status(4, "com.moonlit.logfaces.client.plugin", line));
                    ++n2;
                }
                MultiStatus ms = new MultiStatus("com.moonlit.logfaces.client.plugin", 4, (IStatus[])childStatuses.toArray(new Status[0]), t.getLocalizedMessage(), t);
                ErrorDialog.openError((Shell)Application.getShell(), (String)title, (String)msg, (IStatus)ms);
            }
        });
    }

    public static void displayError(final String title, final String msg) {
        if (msg == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (msg.contains(LINE_SEPARATOR)) {
                    String[] lines;
                    ArrayList childStatuses = Lists.newArrayList();
                    String[] stringArray = lines = StringUtils.split(msg, LINE_SEPARATOR);
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        childStatuses.add(new Status(4, "com.moonlit.logfaces.client.plugin", line));
                        ++n2;
                    }
                    MultiStatus ms = new MultiStatus("com.moonlit.logfaces.client.plugin", 4, (IStatus[])childStatuses.toArray(new Status[0]), title, null);
                    ErrorDialog.openError((Shell)Application.getShell(), (String)title, null, (IStatus)ms);
                    return;
                }
                ErrorDialog.openError((Shell)Application.getShell(), (String)title, null, (IStatus)new Status(4, "com.moonlit.logfaces.client.plugin", msg));
            }
        });
    }

    public static void chime(LoggingEventVO event, int what) {
        int threshold = Application.getPrefs().getInt("sound_level", LfsLevel.WARN.intLevel());
        if (event.isThrown() && threshold < Integer.MAX_VALUE) {
            Utils.chime(what);
        } else if (event.getLoggerLevel() >= threshold) {
            Utils.chime(what);
        }
    }

    public static void chime(int what) {
        long limit = Application.getPrefs().getInt("sound_limit", 5) * 1000;
        if (limit == 0L || System.currentTimeMillis() - lastNudge < limit) {
            return;
        }
        Utils.playSound(what);
        lastNudge = System.currentTimeMillis();
    }

    public static void playSound(final int what) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Clip clip = AudioSystem.getClip();
                    Sound sound = Sound.values()[what];
                    InputStream is = Application.class.getResourceAsStream(sound.toResource());
                    AudioInputStream inputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(is));
                    clip.open(inputStream);
                    clip.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public static boolean gotHeap() {
        long total;
        long free = Runtime.getRuntime().freeMemory();
        return (double)free > (double)(total = Runtime.getRuntime().totalMemory()) * 0.05;
    }

    public static LogFile makeLogFile(ReceiverType type, String fileName) {
        IPreferencesService service = Platform.getPreferencesService();
        String pattern = service.getString("com.moonlit.logfaces.client.plugin", "lfs_pattern_layout", "[%-5p] %d{dd MMM yyyy HH:mm:ss} %-20C{1} - %m%n", null);
        LogFile logFile = new LogFile();
        logFile.getOptions().setProperty("type", (Object)type);
        logFile.getOptions().setProperty("file", (Object)fileName);
        logFile.getOptions().setProperty("format", (Object)pattern);
        return logFile;
    }

    public static void saveToLogFile(LogView view, String fileName, FileFormat format, boolean launchEditor) {
        ArrayList events = view.getModel().getViewData();
        if (events.isEmpty()) {
            MessageDialog.openWarning((Shell)Application.getShell(), (String)"Nothing to do", (String)"Collection is empty, there is nothing to do...");
            return;
        }
        if (!view.getTimeZone().equals(TimeZone.getDefault())) {
            events = Lists.newArrayList();
            int offset = view.getTimeZone().getOffset(System.currentTimeMillis());
            for (LogEvent e : view.getModel().getViewData()) {
                LogEvent clone = e.clone();
                clone.setLoggerTimeStamp(clone.getLoggerTimeStamp() - (long)offset);
                events.add(clone);
            }
        }
        switch (format) {
            case pattern: 
            case xml: {
                LogFile logFile = new LogFile();
                try {
                    try {
                        IPreferencesService service = Platform.getPreferencesService();
                        logFile.getOptions().setProperty("file", (Object)fileName);
                        if (FileFormat.pattern.equals((Object)format)) {
                            String pattern = service.getString("com.moonlit.logfaces.client.plugin", "lfs_pattern_layout", "[%-5p] %d{dd MMM yyyy HH:mm:ss} %-20C{1} - %m%n", null);
                            logFile.getOptions().setProperty("format", (Object)pattern);
                        }
                        logFile.initialize();
                        logFile.write((Collection)events);
                        break;
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                        Utils.displayException("File export", "Some errors detected writing to file", e);
                        logFile.terminate();
                        return;
                    }
                }
                finally {
                    logFile.terminate();
                }
            }
            case csv: {
                try {
                    new LogViewWriter(view, fileName).write();
                    break;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Utils.displayException("File export", "Some errors detected writing to file", e);
                    return;
                }
            }
            default: {
                MessageDialog.openInformation((Shell)Application.getShell(), (String)"Not supported", (String)String.format("Format %s not supported", new Object[]{format}));
                return;
            }
        }
        if (launchEditor) {
            Utils.launchExternalEditor(fileName, 0);
        } else {
            String msg = String.format("%d events exported to:%n%s", events.size(), fileName);
            MessageDialog.openInformation((Shell)Application.getShell(), (String)"Done", (String)msg);
        }
    }

    public static int[] toArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            arr[i] = list.get(i);
            ++i;
        }
        return arr;
    }

    public static List<Integer> toList(int[] arr) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        while (i < arr.length) {
            list.add(arr[i]);
            ++i;
        }
        return list;
    }

    public static String[] getTimeZonesName() {
        TreeMap ret = new TreeMap();
        Set set = ret.keySet();
        ArrayList list = new ArrayList(set);
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public static Map<String, Integer> getTimeZones() {
        TreeMap<String, Integer> ret = new TreeMap<String, Integer>();
        int i = -14;
        while (i <= 12) {
            if (i == 0) {
                ret.put("GMT", 0);
            } else {
                ret.put("GMT" + (i > 0 ? "+" : "") + i, (int)((long)i * 3600000L));
            }
            ++i;
        }
        return ret;
    }

    public static TimeZone getTimeZone(String name) {
        Map<String, Integer> map = Utils.getTimeZones();
        if (!map.containsKey(name)) {
            return TimeZone.getDefault();
        }
        int offset = map.get(name);
        String[] ids = TimeZone.getAvailableIDs(offset);
        if (ids.length == 0) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(ids[0]);
    }

    public static TimeZone getTimeZone(int offset) {
        Map<String, Integer> map = Utils.getTimeZones();
        for (String name : map.keySet()) {
            if (map.get(name) != offset) continue;
            String[] ids = TimeZone.getAvailableIDs(offset);
            if (ids.length == 0) {
                return TimeZone.getDefault();
            }
            return TimeZone.getTimeZone(ids[0]);
        }
        return TimeZone.getDefault();
    }

    public static boolean authenticate(final String user, final String password) {
        try {
            IPreferencesService service = Platform.getPreferencesService();
            String host = service.getString("com.moonlit.logfaces.client.plugin", "lfs_host_name", "localhost", null);
            int port = service.getInt("com.moonlit.logfaces.client.plugin", "lfs_port_num", -1, null);
            URL url = new URL("http://" + host + ":" + port + "/admin");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (connection.getResponseCode() == 401) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(user, password.toCharArray());
                    }
                });
                url = new URL("http://" + host + ":" + port + "/admin");
                connection = (HttpURLConnection)url.openConnection();
                connection.getInputStream();
                if (connection.getResponseCode() == 401) {
                    throw new Exception("" + connection.getResponseCode());
                }
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static BitSet mask(long value) {
        BitSet bits = new BitSet(64);
        int index = 0;
        while (value != 0L) {
            if (value % 2L != 0L) {
                bits.set(index);
            }
            ++index;
            value >>>= 1;
        }
        return bits;
    }

    public static long unmask(BitSet bits) {
        long ret = 0L;
        int i = 0;
        while (i < bits.size()) {
            if (bits.get(i)) {
                ret |= (long)(1 << i);
            }
            ++i;
        }
        return ret;
    }

    public static String getExceptionClass(LoggingEventVO event) {
        if (!event.isThrown()) {
            return "";
        }
        String info = event.getThrowableInfo();
        if (info == null) {
            return "";
        }
        int eolIndex = info.indexOf(10);
        if (eolIndex > 0 && eolIndex < info.indexOf(58)) {
            return info.substring(0, eolIndex);
        }
        String[] ret = StringUtils.tokenizeToStringArray(info, ":");
        return ret.length > 0 ? ret[0] : "";
    }

    public static Map<String, String> commandLine2map(String csv) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (csv == null) {
            return map;
        }
        String[] args = StringUtils.tokenizeToStringArray(csv.trim(), ";");
        if (args == null) {
            return map;
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String[] namevalue = StringUtils.tokenizeToStringArray(arg, "=");
            if (namevalue != null && namevalue.length == 2) {
                map.put(namevalue[0].trim(), namevalue[1].trim());
            }
            ++n2;
        }
        return map;
    }

    public static String event2valuePairs(LogEvent e) {
        if (e == null) {
            return "";
        }
        SimpleDateFormat dtf = new SimpleDateFormat("dd-MMM-yy HH:mm:ss.SSS");
        String format = "%1$-10s: %2$s\n";
        StringBuffer buff = new StringBuffer();
        if (e instanceof LoggingEventVO) {
            LoggingEventVO event = (LoggingEventVO)e;
            buff.append(String.format(format, "Severity", LfsLevel.toLevel((int)event.getLoggerLevel()).toString()));
            buff.append(String.format(format, "Time", dtf.format(new Date(event.getLoggerTimeStamp()))));
            buff.append(String.format(format, "Domain", event.getDomainName()));
            buff.append(String.format(format, "Host", event.getHostName()));
            buff.append(String.format(format, "Logger", event.getLoggerName()));
            buff.append(String.format(format, "Thread", event.getThreadName()));
            buff.append(String.format(format, "Caller", Utils.getLocationInfo((LogEvent)event)));
            Iterator iterator = MdcMap.getKeys().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                String value = event.getProperty(MdcMap.getName((int)key));
                if (value == null) continue;
                buff.append(String.format(format, MdcMap.getName((int)key), value));
            }
            buff.append(String.format(format, "Message", event.getMessage()));
            if (event.isThrown()) {
                buff.append(String.format(format, "Exception", event.getThrowableInfo()));
            }
        }
        return buff.toString();
    }

    public static LogHeaderInfoVO[] unserializeHeaders(IMemento memento) {
        LogHeaderInfoVO[] headers = Columns.makeDefaultHeaders();
        IMemento[] mheaders = memento.getChildren("header");
        int nofVisible = 0;
        if (mheaders != null) {
            IMemento[] iMementoArray = mheaders;
            int n = mheaders.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento m = iMementoArray[n2];
                int i = Columns.name2column(m.getString("name"));
                if (i >= 0) {
                    headers[i].setName(m.getString("name"));
                    headers[i].setWidth(m.getInteger("width"));
                    headers[i].setVisible(m.getInteger("visible") > 0);
                    nofVisible += headers[i].isVisible() ? 1 : 0;
                }
                ++n2;
            }
        }
        return nofVisible > 0 ? headers : Columns.makeDefaultHeaders();
    }

    public static void serializeHeaders(LogHeaderInfoVO[] headers, IMemento memento) {
        int i = 0;
        while (i < headers.length) {
            IMemento hm = memento.createChild("header");
            hm.putString("name", headers[i].getName());
            hm.putInteger("width", headers[i].getWidth());
            hm.putInteger("visible", headers[i].isVisible() ? 1 : 0);
            ++i;
        }
    }

    public static CriteriaFilter unserializeCriteria(IMemento memento) {
        JexlCriteria criteria = new JexlCriteria();
        IMemento cmemento = memento.getChild("criteria");
        if (cmemento != null) {
            IMemento[] rms = cmemento.getChildren("rule");
            if (rms == null) {
                return criteria;
            }
            IMemento[] iMementoArray = rms;
            int n = rms.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento rm = iMementoArray[n2];
                IMemento[] cms = rm.getChildren("condition");
                if (cms != null && cms.length != 0) {
                    Rule rule = criteria.addRule();
                    IMemento[] iMementoArray2 = cms;
                    int n3 = cms.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento cm = iMementoArray2[n4];
                        try {
                            Condition condition = rule.newCondition();
                            condition.setAttribute(cm.getString("attr"));
                            condition.setOperation(Operation.fromString((String)cm.getString("oper")));
                            condition.setValue((Object)cm.getString("value"));
                        }
                        catch (Exception e) {
                            Utils.complain("Failed to unserialize criteria", e);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return criteria;
    }

    public static void serializeCriteria(IMemento memento, CriteriaFilter criteria) {
        try {
            IMemento crm = memento.createChild("criteria");
            for (Rule rule : criteria.getRules()) {
                IMemento rm = crm.createChild("rule");
                for (Condition condition : rule.getConditions()) {
                    if (condition.getAttribute() == null || condition.getOperation() == null || condition.getValue() == null) continue;
                    IMemento cm = rm.createChild("condition");
                    cm.putString("attr", condition.getAttribute().toString());
                    cm.putString("oper", condition.getOperation().toString());
                    cm.putString("value", condition.getValue().toString());
                }
            }
        }
        catch (Exception e) {
            Utils.complain("Failed to serialize criteria", e);
        }
    }

    public static boolean isParametrized(CriteriaFilter criteria) {
        if (criteria == null) {
            return false;
        }
        for (Rule rule : criteria.getRules()) {
            for (Condition condition : rule.getConditions()) {
                String value;
                if (condition.getValue() == null || !(value = condition.getValue().toString()).contains("${") || !value.contains("}")) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, String> parameterizeCriteria(CriteriaFilter criteria) {
        return Utils.parameterizeCriteria(criteria, Maps.newHashMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> parameterizeCriteria(CriteriaFilter criteria, Map<String, String> defaults) {
        if (criteria == null) {
            return null;
        }
        HashMap inputs = Maps.newHashMap();
        try {
            for (Rule rule : criteria.getRules()) {
                for (Condition condition : rule.getConditions()) {
                    String value = condition.getValue().toString();
                    String param = null;
                    while ((param = Utils.getParamName(value)) != null) {
                        String input = (String)inputs.get(param);
                        if (defaults != null && defaults.containsKey(param)) {
                            input = defaults.get(param);
                        } else if (input == null) {
                            IDialogSettings settings = Application.getDialogSettings("ComboInputDialog.criteria", true);
                            ComboInputDialog dlg = new ComboInputDialog(Application.getShell(), "Parameter is required", param, settings);
                            if (dlg.open() != 0) {
                                return null;
                            }
                            input = dlg.getValue();
                        }
                        inputs.put(param, input);
                        value = StringUtils.replace(value, "${" + param + "}", input);
                        condition.setValue((Object)value);
                    }
                }
            }
            return inputs;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static org.eclipse.swt.graphics.Color pickForeground(org.eclipse.swt.graphics.Color bg) {
        if ((double)(bg.getRed() + bg.getGreen() + bg.getBlue()) <= 450.0) {
            return Display.getCurrent().getSystemColor(1);
        }
        return Display.getCurrent().getSystemColor(2);
    }

    public static org.eclipse.swt.graphics.Color lighter(org.eclipse.swt.graphics.Color color, double fraction) {
        int red = (int)Math.round((double)color.getRed() * (1.0 + fraction));
        int green = (int)Math.round((double)color.getGreen() * (1.0 + fraction));
        int blue = (int)Math.round((double)color.getBlue() * (1.0 + fraction));
        if (red < 0) {
            red = 0;
        } else if (red > 255) {
            red = 255;
        }
        if (green < 0) {
            green = 0;
        } else if (green > 255) {
            green = 255;
        }
        if (blue < 0) {
            blue = 0;
        } else if (blue > 255) {
            blue = 255;
        }
        return new org.eclipse.swt.graphics.Color(null, red, green, blue);
    }

    public static Color swt2awtColor(org.eclipse.swt.graphics.Color swtColor) {
        return new Color(swtColor.getRed(), swtColor.getGreen(), swtColor.getBlue());
    }

    public static IEditorPart findEditor(String name, Class<?> cls) {
        if (!StringUtils.hasText(name) || cls == null) {
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor.getClass().equals(cls) && name.equals(editor.getEditorInput().getName())) {
                return editor;
            }
            ++n2;
        }
        return null;
    }

    public static List<IEditorPart> findEditors(Class<?> cls) {
        ArrayList list = Lists.newArrayList();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor.getClass().equals(cls)) {
                list.add(editor);
            }
            ++n2;
        }
        return list;
    }

    public static void closeAllEditors() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            page.closeEditor(editor, true);
            ++n2;
        }
    }

    public static void saveLogEditorStates() {
        for (PerspectiveVO vo : LogPerspectivesModel.getInstance().listEntries()) {
            vo.setOpened(false);
        }
        for (IEditorPart e : Utils.findEditors(LogEditor.class)) {
            LogEditorInput input = (LogEditorInput)((LogEditor)e).getEditorInput();
            input.setReopen(true);
        }
    }

    public static void activateEditorOtherThan(Class<?> cls) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart activeEditor = page.getActiveEditor();
        if (activeEditor == null || !activeEditor.getClass().equals(cls)) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (!editor.getClass().equals(cls)) {
                page.showEditor(ref);
                break;
            }
            ++n2;
        }
    }

    public static void displayQueryResults(final Fetcher fetcher) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                IEditorPart editor = Utils.findEditor(fetcher.getName(), QueryResultsEditor.class);
                if (editor != null) {
                    QueryResultsInput input = new QueryResultsInput(fetcher);
                    input.setQueryTime(fetcher.getQueryTime());
                    ((QueryResultsEditor)editor).reload(input);
                    page.activate((IWorkbenchPart)editor);
                    return;
                }
                try {
                    QueryResultsInput input = new QueryResultsInput(fetcher);
                    input.setQueryTime(fetcher.getQueryTime());
                    QueryResultsEditor queryEditor = (QueryResultsEditor)page.openEditor((IEditorInput)input, "com.moonlit.logfaces.client.QueryResultsEditor");
                    if (queryEditor == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public static CriteriaFilter column2criteria(SliceInfo slice, TimePeriod period) {
        JexlCriteria criteria = new JexlCriteria();
        if (period == null) {
            period = new SimpleTimePeriod(0L, Long.MAX_VALUE);
        }
        if (slice.isOfComponents()) {
            ComponentModel cmodel = ComponentsModel.getInstance().getComponent(slice.getSeries());
            if (cmodel != null && cmodel.getPackageNames().length > 0) {
                String[] stringArray = cmodel.getPackageNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String pack = stringArray[n2];
                    criteria.addRule().addCondition((Object)EventAttribute.loggerName, (Object)Operation.contains, (Object)pack).addCondition((Object)EventAttribute.loggerTimeStamp, (Object)Operation.emore, (Object)period.getStart().getTime()).addCondition((Object)EventAttribute.loggerTimeStamp, (Object)Operation.eless, (Object)period.getEnd().getTime());
                    ++n2;
                }
            }
            return criteria;
        }
        if (slice.isOfTags()) {
            TagVO tag = TagsModel.getInstance().get(slice.getSeries());
            if (tag == null || tag.getCriteria() == null) {
                return criteria;
            }
            criteria = tag.getCriteria().clone();
            for (Rule r : criteria.getRules()) {
                r.addCondition((Object)EventAttribute.loggerTimeStamp, (Object)Operation.emore, (Object)period.getStart().getTime());
                r.addCondition((Object)EventAttribute.loggerTimeStamp, (Object)Operation.eless, (Object)period.getEnd().getTime());
            }
            return criteria;
        }
        Rule rule = criteria.addRule();
        rule.addCondition((Object)EventAttribute.loggerTimeStamp, (Object)Operation.emore, (Object)period.getStart().getTime());
        rule.addCondition((Object)EventAttribute.loggerTimeStamp, (Object)Operation.eless, (Object)period.getEnd().getTime());
        if (slice.isOfRegex()) {
            RegexVO regex = RegexModel.getInstance().get(slice.getName());
            String exp = Patterns.getInstance().buildExpression(regex.getExpression());
            rule.addCondition((Object)EventAttribute.message, (Object)Operation.regex, (Object)exp);
            if (StringUtils.hasText(slice.getSeries())) {
                rule.addCondition((Object)EventAttribute.message, (Object)Operation.contains, (Object)slice.getSeries());
            }
            return criteria;
        }
        if (slice.isOfMdc()) {
            rule.addCondition((Object)slice.getName(), (Object)Operation.is, (Object)slice.getSeries());
            return criteria;
        }
        switch (slice.getAttribute()) {
            case domainName: 
            case hostName: 
            case loggerName: 
            case threadName: {
                rule.addCondition((Object)slice.getAttribute(), (Object)Operation.is, (Object)slice.getSeries());
                break;
            }
            case throwableInfo: {
                rule.addCondition((Object)EventAttribute.throwableInfo, (Object)Operation.contains, (Object)slice.getSeries());
                break;
            }
            case loggerLevel: {
                rule.addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.is, (Object)LfsLevel.toLevel((String)slice.getSeries()).intLevel());
                break;
            }
        }
        return criteria;
    }

    public static CriteriaFilter makeDrillcriteria(SliceInfo slice, CriteriaFilter criteria) {
        if (slice == null || slice.getSeries() == null) {
            return criteria;
        }
        if (slice.isOfRegex()) {
            RegexVO regex = slice.getRegex();
            String exp = regex.getExpressionFor(slice.getSeries());
            for (Rule rule : criteria.getRules()) {
                rule.addCondition((Object)EventAttribute.message, (Object)Operation.regex, (Object)exp);
            }
            return criteria;
        }
        if (slice.isOfIntegral()) {
            RegexVO regex = slice.getRegex();
            String exp = Patterns.getInstance().buildExpression(regex.getExpression());
            for (Rule rule : criteria.getRules()) {
                rule.addCondition((Object)EventAttribute.message, (Object)Operation.regex, (Object)exp);
            }
            return criteria;
        }
        if (slice.isOfComponents()) {
            Collection<String> packs = ComponentsModel.getInstance().getPackageNames(slice.getSeries());
            if (ConnectionProfile.getInstance().isDbRegexSupported()) {
                String regex = StringUtils.collectionToDelimitedString(packs, "|");
                regex = StringUtils.replace(regex, ".", "\\.");
                for (Rule rule : criteria.getRules()) {
                    rule.addCondition((Object)EventAttribute.loggerName, (Object)Operation.regex, (Object)regex);
                }
                return criteria;
            }
            JexlCriteria cr = new JexlCriteria();
            for (String pack : packs) {
                for (Rule r : criteria.getRules()) {
                    Rule rule = cr.addRule().addCondition((Object)EventAttribute.loggerName, (Object)Operation.contains, (Object)pack);
                    for (Condition c : r.getConditions()) {
                        rule.addCondition((Object)c.getAttribute(), (Object)c.getOperation(), c.getValue());
                    }
                }
            }
            return cr;
        }
        if (slice.isOfTags()) {
            TagVO tag = TagsModel.getInstance().get(slice.getSeries());
            if (tag == null || tag.getCriteria() == null) {
                return criteria;
            }
            CriteriaFilter tagCriteria = tag.getCriteria().clone();
            List rules = criteria.getRules();
            if (rules.isEmpty() || rules.size() > 1) {
                return tagCriteria;
            }
            List additions = ((Rule)rules.get(0)).getConditions();
            for (Rule rule : tagCriteria.getRules()) {
                for (Condition c : additions) {
                    rule.addCondition((Object)c.getAttribute(), (Object)c.getOperation(), c.getValue());
                }
            }
            return tagCriteria;
        }
        switch (slice.getAttribute()) {
            case domainName: 
            case hostName: 
            case loggerName: 
            case loggerLevel: 
            case threadName: 
            case thrown: {
                for (Rule rule : criteria.getRules()) {
                    rule.addCondition((Object)slice.getAttribute(), (Object)Operation.is, (Object)slice.getSeries());
                }
                break;
            }
            case throwableInfo: {
                for (Rule rule : criteria.getRules()) {
                    rule.addCondition((Object)EventAttribute.throwableInfo, (Object)Operation.contains, (Object)slice.getSeries());
                }
                break;
            }
            case mdc: {
                for (Rule rule : criteria.getRules()) {
                    rule.addCondition((Object)slice.getName(), (Object)Operation.is, (Object)slice.getSeries());
                }
                break;
            }
        }
        return criteria;
    }

    public static void addArrayCondition(Rule rule, EventAttribute attribute, String[] values) {
        if (values.length == 0) {
            return;
        }
        if (values.length == 1) {
            rule.addCondition((Object)attribute, (Object)Operation.is, (Object)values[0]);
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            value = StringUtils.replace(value, ".", "\\.");
            list.add(String.format("\\b%s\\b", value));
            ++n2;
        }
        String regex = StringUtils.collectionToDelimitedString(list, "|");
        rule.addCondition((Object)attribute, (Object)Operation.regex, (Object)regex);
    }

    public static TimeZone detectTimeZone() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return TimeZone.getDefault();
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return TimeZone.getDefault();
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor != null && editor instanceof LogView) {
            return ((LogView)editor).getTimeZone();
        }
        return TimeZone.getDefault();
    }

    public static String getLocationInfo(LogEvent event) {
        if (!(event instanceof LoggingEventVO)) {
            return "";
        }
        LoggingEventVO vo = (LoggingEventVO)event;
        String ret = String.format("%s.%s(%s:%s)", vo.getLocClassName(), vo.getLocMethodName(), vo.getLocFileName(), vo.getLocLineNumber());
        return ret.equals(".(:)") ? "" : ret;
    }

    public static String getParamName(String input) {
        int start = input.indexOf("${");
        if (start == -1) {
            return null;
        }
        int end = input.indexOf(125, start += 2);
        if (end == -1) {
            return null;
        }
        return input.substring(start, end);
    }

    public static void setContextVariable(String name, Object variable) {
        contextVars.put(name, variable);
    }

    public static Object getContextVariable(String name) {
        return contextVars.get(name);
    }

    public static void optimizeRowHeight(Table table) {
        if (!Util.isWindows()) {
            return;
        }
        try {
            if (table.isDisposed()) {
                return;
            }
            GC gc = new GC((Drawable)table);
            FontMetrics fontMetrics = gc.getFontMetrics();
            int height = fontMetrics.getHeight();
            gc.dispose();
            if ((height += 6) <= 16) {
                return;
            }
            Method setItemHeightMethod = table.getClass().getDeclaredMethod("setItemHeight", Integer.TYPE);
            setItemHeightMethod.setAccessible(true);
            setItemHeightMethod.invoke((Object)table, height);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void overrideTableSelectionPaint(Event event, Table table) {
        TableItem item = (TableItem)event.item;
        if (item == null || item.isDisposed()) {
            return;
        }
        if ((event.detail & 2) > 0) {
            int clientWidth = table.getClientArea().width;
            GC gc = event.gc;
            org.eclipse.swt.graphics.Color oldForeground = gc.getForeground();
            org.eclipse.swt.graphics.Color oldBackground = gc.getBackground();
            gc.setBackground(EventStyles.BG_SELECTION);
            gc.setForeground(EventStyles.FG_BOOKMARK);
            gc.fillRectangle(0, event.y, clientWidth, event.height);
            Rectangle rect = item.getTextBounds(event.index);
            gc.drawString(item.getText(event.index), rect.x - 1, rect.y);
            gc.setBackground(oldBackground);
            gc.setBackground(oldForeground);
            event.detail &= 0xFFFFFFFD;
            event.doit = false;
        }
    }

    public static void packColumns(final LogView view) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        view.packColumns();
                    }
                });
            }
        }, 200L);
    }

    public static void updateActiveState(final LogView view) {
        if (Util.isWindows()) {
            view.updateActiveState();
            return;
        }
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        view.updateActiveState();
                    }
                });
            }
        }, 50L);
    }

    public static int mouse2columnType(Table table) {
        Point pt = Display.getCurrent().getCursorLocation();
        TableItem item = table.getItem(pt = table.toControl(pt));
        if (item != null) {
            int[] nArray = table.getColumnOrder();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                Rectangle rect = item.getBounds(i);
                if (rect.contains(pt)) {
                    return (Integer)table.getColumn(i).getData();
                }
                ++n2;
            }
        }
        return -1;
    }

    public static int mouse2columnIndex(Table table) {
        Point pt = Display.getCurrent().getCursorLocation();
        TableItem item = table.getItem(pt = table.toControl(pt));
        if (item != null) {
            int i = 0;
            while (i < table.getColumnCount()) {
                Rectangle rect = item.getBounds(i);
                if (rect.contains(pt)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static TableItem mouse2tableItem(Table table) {
        Point pt = Display.getCurrent().getCursorLocation();
        pt = table.toControl(pt);
        return table.getItem(pt);
    }

    public static String safeJson(String input) {
        return Utils.safeJson(input, false);
    }

    public static String safeJson(String input, boolean noeol) {
        if (input == null || input.length() == 0) {
            return "";
        }
        try {
            input = input.replace(LINE_SEPARATOR, "\\n");
            input = input.replace("\n", "\\n");
            input = input.replace("\t", "   ");
            input = input.replace("\r", " ");
            input = input.replace("\"", "'");
            input = input.replaceAll("\\\\(?!n)", "/");
            input = input.replaceAll("[\\p{Cntrl}&&[^\r\n\t]]|[\\ufffe-\\uffff]", "");
            if (noeol) {
                input = input.replace("\\n", " ");
            }
            return input;
        }
        catch (Exception e) {
            return input;
        }
    }

    /*
     * Exception decompiling
     */
    public static String abbreaviate(File file, int nofLines) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void longSafeSleep(int time) throws Exception {
        int sleep = 300;
        long error = System.currentTimeMillis() + (long)time + (long)(sleep * 5);
        while (time > 0) {
            Thread.sleep(sleep);
            if (System.currentTimeMillis() > error) {
                throw new Exception("jvm was suspended during thread sleep");
            }
            time -= sleep;
        }
    }

    public static String getSyslogDataJson(LogEvent event) {
        String sdata = (String)event.getProperties().get("syslog.data");
        if (!StringUtils.hasText(sdata)) {
            return "";
        }
        try {
            return gson.toJson(gson.fromJson(sdata, Map.class));
        }
        catch (Exception exception) {
            return sdata;
        }
    }

    public static Image resizeImage(Image image, int width, int height) {
        Image scaled = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        gc.dispose();
        image.dispose();
        return scaled;
    }

    public static String getProductVersion() {
        try {
            IProduct product = Platform.getProduct();
            Version version = product.getDefiningBundle().getVersion();
            return version.toString();
        }
        catch (Exception e) {
            return "?";
        }
    }
}

