/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class TimeZones {
    private static final String TIMEZONE_ID_PREFIXES = "^(Africa|America|Asia|Atlantic|Australia|Europe|Indian|Pacific)/.*";
    private List<TimeZone> timeZones = null;

    public List<TimeZone> getTimeZones() {
        if (this.timeZones == null) {
            this.initTimeZones();
        }
        return this.timeZones;
    }

    private void initTimeZones() {
        String[] timeZoneIds;
        this.timeZones = new ArrayList<TimeZone>();
        String[] stringArray = timeZoneIds = TimeZone.getAvailableIDs();
        int n = timeZoneIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.matches(TIMEZONE_ID_PREFIXES)) {
                this.timeZones.add(TimeZone.getTimeZone(id));
            }
            ++n2;
        }
        Collections.sort(this.timeZones, new Comparator<TimeZone>(){

            @Override
            public int compare(TimeZone a, TimeZone b) {
                return a.getID().compareTo(b.getID());
            }
        });
    }

    public static void main(String[] agr) {
        Date today = new Date();
        TimeZones tz = new TimeZones();
        tz.initTimeZones();
        List<TimeZone> list = tz.getTimeZones();
        for (TimeZone z : list) {
            int rawOffset = z.getRawOffset();
            int hour = rawOffset / 3600000;
            int min = Math.abs(rawOffset / 60000) % 60;
            String shortName = z.getDisplayName(z.inDaylightTime(today), 0);
            String longName = z.getDisplayName(z.inDaylightTime(today), 1);
            System.out.println(String.format("%s\t%s\t%s:%s\t%s\t%s", z.getID(), z.useDaylightTime(), hour, min, shortName, longName));
        }
    }
}

