/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.utils;

import java.net.URI;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class P2Utils {
    private static Logger log = LogManager.getLogger(P2Utils.class);

    public static IStatus checkForUpdates(IProvisioningAgent agent, IProgressMonitor monitor) {
        log.info("checking for software updates");
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Checking for application updates", (int)200);
        IStatus result = operation.resolveModal((IProgressMonitor)sub.newChild(100));
        log.info("{}software updates detected, response code = '{}'", (Object)(result.getCode() == 10000 ? "no " : ""), (Object)result.getCode());
        return result;
    }

    public static IStatus installUpdates(IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        log.info("installing software updates");
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Installing updates", (int)200);
        operation.resolveModal((IProgressMonitor)sub.newChild(100));
        ProvisioningJob job = operation.getProvisioningJob(monitor);
        if (job == null) {
            log.info("updates installation canceled");
            return Status.CANCEL_STATUS;
        }
        IStatus result = job.runModal((IProgressMonitor)sub.newChild(100));
        log.log(result.isOK() ? Level.INFO : Level.ERROR, "{}, response code = '{}'", (Object)(result.isOK() ? "updates installed ok" : "updates installation failed"), (Object)result.getCode());
        return result;
    }

    public static boolean addRepository(IProvisioningAgent agent, String repo) {
        log.info(String.format("adding repository at %s", repo));
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (metadataManager == null || artifactManager == null) {
            log.warn("P2Utils.addRepository - missing metadata or artifact manager");
            return false;
        }
        try {
            URI uri = new URI(repo);
            metadataManager.addRepository(uri);
            artifactManager.addRepository(uri);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static void clearCache(IProvisioningAgent agent, IProgressMonitor monitor) {
        try {
            IMetadataRepositoryManager mm = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            URI[] uRIArray = mm.getKnownRepositories(0);
            int n = uRIArray.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                try {
                    mm.refreshRepository(uri, monitor);
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
                ++n2;
            }
            IArtifactRepositoryManager am = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            URI[] uRIArray2 = am.getKnownRepositories(0);
            int n3 = uRIArray2.length;
            n = 0;
            while (n < n3) {
                URI uri = uRIArray2[n];
                try {
                    am.refreshRepository(uri, monitor);
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
                ++n;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

