/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.utils;

import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LogViewWriter {
    private LogView view;
    private List<Integer> order;
    private Writer writer;
    private ComponentsModel components = ComponentsModel.getInstance();
    private String emoji = "[^\\p{L}\\p{M}\\p{N}\\p{P}\\p{Z}\\p{Cf}\\p{Cs}\\s]";
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy");

    public LogViewWriter(LogView view, String fileName) throws Exception {
        Table table = view.getTableViewer().getTable();
        this.view = view;
        this.timeFormat.setTimeZone(view.getTimeZone());
        this.dateFormat.setTimeZone(view.getTimeZone());
        this.order = Utils.toList(table.getColumnOrder());
        this.writer = new FileWriter(new File(fileName));
    }

    public LogViewWriter(LogView view, Writer writer) {
        Table table = view.getTableViewer().getTable();
        this.view = view;
        this.timeFormat.setTimeZone(view.getTimeZone());
        this.dateFormat.setTimeZone(view.getTimeZone());
        this.order = Utils.toList(table.getColumnOrder());
        this.writer = writer;
    }

    public void write() throws Exception {
        this.writer.write(65279);
        this.header();
        for (LogEvent event : this.view.getModel().getViewData()) {
            this.write(event);
        }
        this.writer.close();
    }

    public void write(TableItem[] selection) throws Exception {
        this.writer.write(65279);
        this.header();
        TableItem[] tableItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            this.write((LogEvent)((LoggingEventVO)item.getData()));
            ++n2;
        }
        this.writer.close();
    }

    private void header() throws Exception {
        int i = 0;
        while (i < this.order.size()) {
            if (i > 0) {
                this.writer.write(",");
            }
            int col = this.view.getColumnType(this.order.get(i));
            this.writer.write(Columns.column2string(col));
            ++i;
        }
        this.writer.write(Utils.LINE_SEPARATOR);
    }

    private void write(LogEvent e) throws Exception {
        if (e == null) {
            return;
        }
        LoggingEventVO event = (LoggingEventVO)e;
        int i = 0;
        while (i < this.order.size()) {
            if (i > 0) {
                this.writer.write(",");
            }
            String value = "";
            int columnType = this.view.getColumnType(this.order.get(i));
            switch (columnType) {
                case 0: {
                    value = LfsLevel.toLevel((int)event.getLoggerLevel()).toString();
                    break;
                }
                case 1: {
                    value = (String)event.getProperties().get("tags");
                    break;
                }
                case 2: {
                    value = this.dateFormat.format(new Date(event.getLoggerTimeStamp()));
                    break;
                }
                case 3: {
                    value = this.timeFormat.format(new Date(event.getLoggerTimeStamp()));
                    break;
                }
                case 4: {
                    value = event.getHostName();
                    break;
                }
                case 5: {
                    value = event.getDomainName();
                    break;
                }
                case 6: {
                    value = this.components.getComponent(event);
                    break;
                }
                case 7: {
                    value = event.getLoggerName();
                    break;
                }
                case 8: {
                    value = event.getThreadName();
                    break;
                }
                case 9: {
                    value = event.getLocationInformation();
                    break;
                }
                case 10: {
                    if (!event.isThrown()) break;
                    value = event.getExceptionClass();
                    break;
                }
                case 11: {
                    value = event.getNdc();
                    break;
                }
                case 12: {
                    value = event.getMessage();
                    break;
                }
                default: {
                    if (!Columns.isMdcColumn(columnType)) break;
                    String property = Columns.column2mdc(columnType);
                    value = event.getProperty(property);
                }
            }
            value = value != null ? value : "";
            value = StringUtils.replace(value, "\r", "");
            value = StringUtils.replace(value, "\n", " ");
            value = value.replaceAll(this.emoji, "");
            this.writer.write(String.format("%s", StringEscapeUtils.escapeCsv((String)value)));
            ++i;
        }
        this.writer.write(Utils.LINE_SEPARATOR);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }
}

