/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.utils;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Fontable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class FontChanger {
    private static Logger log = LogManager.getLogger(FontChanger.class);

    public static void change(int howmuch) {
        FontRegistry freg = Application.getFontRegistry();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return;
        }
        if (!(part instanceof Fontable)) {
            return;
        }
        String fid = ((Fontable)part).getFontID();
        if (fid == null) {
            return;
        }
        Font font = freg.get(fid);
        if (font == null) {
            return;
        }
        try {
            FontData[] fd;
            FontData[] fontDataArray = fd = font.getFontData();
            int n = fd.length;
            int n2 = 0;
            while (n2 < n) {
                FontData d = fontDataArray[n2];
                d.height += (float)howmuch;
                ++n2;
            }
            freg.put(fid, fd);
            IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
            ITheme currentTheme = themeManager.getCurrentTheme();
            String key = ThemeElementHelper.createPreferenceKey((ITheme)currentTheme, (String)fid);
            IPreferenceStore store = PrefUtil.getInternalPreferenceStore();
            String fdString = PreferenceConverter.getStoredRepresentation((FontData[])fd);
            String storeString = store.getString(key);
            if (!fdString.equals(storeString)) {
                store.setValue(key, fdString);
                PrefUtil.savePrefs();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

