/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.utils;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.actions.BookmarkAction;
import com.moonlit.logfaces.client.actions.BookmarksAction;
import com.moonlit.logfaces.client.actions.BrowseDetailsAction;
import com.moonlit.logfaces.client.actions.CopyTableToClipboardAction;
import com.moonlit.logfaces.client.actions.CopyTextToClipboardAction;
import com.moonlit.logfaces.client.actions.FilterAction;
import com.moonlit.logfaces.client.actions.FollowEventAction;
import com.moonlit.logfaces.client.actions.IgnoreAction;
import com.moonlit.logfaces.client.actions.JiraAction;
import com.moonlit.logfaces.client.actions.OpenPreferencesAction;
import com.moonlit.logfaces.client.actions.PinAction;
import com.moonlit.logfaces.client.actions.QueryDrillDownAction;
import com.moonlit.logfaces.client.actions.QuickViewAction;
import com.moonlit.logfaces.client.actions.RunPluginAction;
import com.moonlit.logfaces.client.actions.SelectionQueryAction;
import com.moonlit.logfaces.client.actions.ShowSourceAction;
import com.moonlit.logfaces.client.actions.ShowTimeSpanAction;
import com.moonlit.logfaces.client.actions.TagAction;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.model.ComponentModel;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.model.PluginVO;
import com.moonlit.logfaces.client.model.PluginsDelegate;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.net.ConnectionProfile;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ContextMenuBuilder {
    private LogView view;
    PerspectiveVO perspectiveVO;

    public ContextMenuBuilder(LogView logView) {
        this.view = logView;
    }

    public ContextMenuBuilder(LogView logView, PerspectiveVO perspectiveVO) {
        this.view = logView;
        this.perspectiveVO = perspectiveVO;
    }

    public static void buildForSelection(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        if (LfsConnector.getInstance().getConnection() == null) {
            return;
        }
        for (LfsLevel level : LfsLevel.toList()) {
            if (level.equals(LfsLevel.OFF) || level.equals(LfsLevel.ALL)) continue;
            manager.add((IAction)new QuickViewAction(selection, level));
        }
        manager.add((IContributionItem)new Separator("additions"));
        if (!Application.isServerMode() && ConnectionProfile.getInstance().isDatabaseEnabled() && selection.size() == 1) {
            MenuManager subMenu = new MenuManager("Problems lookup..");
            subMenu.add((IAction)new SelectionQueryAction(selection, "1 minute from now", TimeRange.BEFORE_1_MIN, 30000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "5 minutes from now", TimeRange.BEFORE_5_MIN, 30000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "30 minutes from now", TimeRange.BEFORE_30_MIN, 30000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "1 hour from now", TimeRange.BEFORE_1_HOUR, 30000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "2 hours from now", TimeRange.BEFORE_2_HOURS, 30000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "4 hours from now", TimeRange.BEFORE_4_HOURS, 30000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "8 hours from now", TimeRange.BEFORE_8_HOURS, 30000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "1 day from now", TimeRange.BEFORE_1_DAY, 30000));
            subMenu.add((IContributionItem)new Separator("additions"));
            subMenu.add((IAction)new SelectionQueryAction(selection, "Particular day", TimeRange.PARTICULAR_DAY, 30000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "Range of days", TimeRange.CUSTOM_RANGE, 30000));
            subMenu.add((IContributionItem)new Separator("additions"));
            subMenu.add((IAction)new SelectionQueryAction(selection, "All times", TimeRange.ALL, 30000));
            manager.add((IContributionItem)subMenu);
            subMenu = new MenuManager("Info lookup..");
            subMenu.add((IAction)new SelectionQueryAction(selection, "1 minute from now", TimeRange.BEFORE_1_MIN, 20000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "5 minutes from now", TimeRange.BEFORE_5_MIN, 20000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "30 minutes from now", TimeRange.BEFORE_30_MIN, 20000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "1 hour from now", TimeRange.BEFORE_1_HOUR, 20000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "2 hours from now", TimeRange.BEFORE_2_HOURS, 20000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "4 hours from now", TimeRange.BEFORE_4_HOURS, 20000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "8 hours from now", TimeRange.BEFORE_8_HOURS, 20000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "1 day from now", TimeRange.BEFORE_1_DAY, 20000));
            subMenu.add((IContributionItem)new Separator("additions"));
            subMenu.add((IAction)new SelectionQueryAction(selection, "Particular day", TimeRange.PARTICULAR_DAY, 20000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "Range of days", TimeRange.CUSTOM_RANGE, 20000));
            subMenu.add((IContributionItem)new Separator("additions"));
            subMenu.add((IAction)new SelectionQueryAction(selection, "All times", TimeRange.ALL, 20000));
            manager.add((IContributionItem)subMenu);
            subMenu = new MenuManager("Trace lookup..");
            subMenu.add((IAction)new SelectionQueryAction(selection, "1 minute from now", TimeRange.BEFORE_1_MIN, 5000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "5 minutes from now", TimeRange.BEFORE_5_MIN, 5000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "30 minutes from now", TimeRange.BEFORE_30_MIN, 5000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "1 hour from now", TimeRange.BEFORE_1_HOUR, 5000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "2 hours from now", TimeRange.BEFORE_2_HOURS, 5000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "4 hours from now", TimeRange.BEFORE_4_HOURS, 5000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "8 hours from now", TimeRange.BEFORE_8_HOURS, 5000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "1 day from now", TimeRange.BEFORE_1_DAY, 5000));
            subMenu.add((IContributionItem)new Separator("additions"));
            subMenu.add((IAction)new SelectionQueryAction(selection, "Particular day", TimeRange.PARTICULAR_DAY, 5000));
            subMenu.add((IAction)new SelectionQueryAction(selection, "Range of days", TimeRange.CUSTOM_RANGE, 5000));
            subMenu.add((IContributionItem)new Separator("additions"));
            subMenu.add((IAction)new SelectionQueryAction(selection, "All times", TimeRange.ALL, 5000));
            manager.add((IContributionItem)subMenu);
        }
    }

    public static void buildForControl(Control control, LoggingEventVO event, String attribute, String text) {
        if (event == null) {
            return;
        }
        MenuManager manager = new MenuManager();
        TimeZone tz = Utils.detectTimeZone();
        manager.add((IAction)new ShowSourceAction(event));
        manager.add((IAction)new CopyTextToClipboardAction(event, attribute, text));
        manager.add((IContributionItem)new Separator("additions"));
        Action action = new FollowEventAction(event, attribute, text);
        action.setText("Follow this in real time");
        action.setImageDescriptor(MainPlugin.getImageDescriptor("icons/filter.gif"));
        manager.add((IAction)action);
        if (!Application.isServerMode() && ConnectionProfile.getInstance().isDatabaseEnabled()) {
            MenuManager subMenu = new MenuManager("Find this..");
            action = new QueryDrillDownAction(event, attribute, TimeRange.RANGE_1_HOUR, tz, true, text);
            action.setText("in a range of " + TimeRange.RANGE_1_HOUR.toString());
            action.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/clock.gif"));
            subMenu.add((IAction)action);
            action = new QueryDrillDownAction(event, attribute, TimeRange.RANGE_4_HOURS, tz, true, text);
            action.setText("in a range of " + TimeRange.RANGE_4_HOURS.toString());
            action.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/clock.gif"));
            subMenu.add((IAction)action);
            action = new QueryDrillDownAction(event, attribute, TimeRange.RANGE_1_DAY, tz, true, text);
            action.setText("in a range of " + TimeRange.RANGE_1_DAY.toString());
            action.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/clock.gif"));
            subMenu.add((IAction)action);
            subMenu.add((IContributionItem)new Separator("additions"));
            action = new QueryDrillDownAction(event, attribute, TimeRange.ALL, tz, true, text);
            action.setText("scan entire database");
            action.setImageDescriptor(MainPlugin.getImageDescriptor("icons/query-red.gif"));
            subMenu.add((IAction)action);
            action = new QueryDrillDownAction(event, attribute, null, tz, true, text);
            action.setText("let me choose..");
            action.setImageDescriptor(MainPlugin.getImageDescriptor("icons/feed.gif"));
            subMenu.add((IAction)action);
            manager.add((IContributionItem)subMenu);
        }
        control.setMenu(manager.createContextMenu(control));
    }

    public static void buildForTags(Control control, LogView view, TagVO tag) {
        MenuManager manager = new MenuManager();
        manager.add((IAction)new TagAction(tag, false));
        manager.add((IAction)new TagAction(tag, true));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)new OpenPreferencesAction("com.moonlit.logfaces.client.prefs.tags"));
        control.setMenu(manager.createContextMenu(control));
    }

    public void build(IMenuManager manager) {
        LoggingEventVO drillEvent;
        if (LfsConnector.getInstance().getConnection() == null) {
            return;
        }
        Table table = this.view.getTableViewer().getTable();
        if (table.getItemCount() == 0) {
            return;
        }
        TableItem[] selected = table.getSelection();
        if (selected == null) {
            return;
        }
        if (selected.length == 0) {
            return;
        }
        if (selected.length == 2) {
            manager.add((IAction)new ShowTimeSpanAction((LoggingEventVO)selected[0].getData(), (LoggingEventVO)selected[1].getData()));
        }
        if ((drillEvent = (LoggingEventVO)selected[0].getData()) == null) {
            return;
        }
        if (selected.length == 1) {
            manager.add((IAction)new BrowseDetailsAction(drillEvent));
            manager.add((IAction)new ShowSourceAction(drillEvent));
            this.fillPluginsContextMenu(manager, selected);
            if (Application.getPrefs().getBoolean("jira_enabled", false)) {
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IAction)new JiraAction(selected));
            }
            this.fillClipboardContextMenu(manager, selected);
            manager.add((IContributionItem)new Separator("additions"));
            TagVO tag = TagsModel.getInstance().findOne((LogEvent)drillEvent);
            if (Utils.mouse2columnType(table) == 1) {
                if (tag != null) {
                    manager.add((IAction)new TagAction(tag, false));
                    manager.add((IAction)new TagAction(tag, true));
                } else {
                    manager.add((IAction)new TagAction(this.view));
                }
            }
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IAction)new PinAction(this.view));
            manager.add((IAction)new BookmarkAction(table, (LogEvent)drillEvent));
            if (TagsModel.getInstance().hasBookmarks()) {
                manager.add((IAction)new BookmarkAction(table));
            }
        } else {
            this.fillPluginsContextMenu(manager, selected);
            if (Application.getPrefs().getBoolean("jira_enabled", false)) {
                manager.add((IAction)new JiraAction(selected));
                manager.add((IContributionItem)new Separator("additions"));
            }
            this.fillClipboardContextMenu(manager, selected);
            this.fillIgnoreContextMenu(manager);
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IAction)new PinAction(this.view));
            manager.add((IAction)new BookmarksAction(table, selected, true));
            if (TagsModel.getInstance().hasBookmarks()) {
                manager.add((IAction)new BookmarksAction(table, selected, false));
            }
            manager.add((IContributionItem)new Separator("additions"));
            return;
        }
        manager.add((IContributionItem)new Separator("additions"));
        this.fillFocusContextMenu(true, manager, drillEvent);
        this.fillFocusContextMenu(false, manager, drillEvent);
        this.fillIgnoreContextMenu(manager);
        manager.add((IContributionItem)new Separator("additions"));
        if (!Application.isServerMode() && ConnectionProfile.getInstance().isDatabaseEnabled()) {
            this.fillDrillContextMenu(manager, drillEvent);
        }
        this.fillFollowContextMenu(manager, drillEvent);
    }

    public void fillPluginsContextMenu(IMenuManager manager, TableItem[] selection) {
        List<PluginVO> list = PluginsDelegate.getInstance().getWorkspacePlugins();
        if (list.isEmpty()) {
            return;
        }
        MenuManager subMenu = new MenuManager("Plugins...");
        for (PluginVO pvo : list) {
            if (pvo.getPlugin() == null || !pvo.isUserActionable()) continue;
            subMenu.add((IAction)new RunPluginAction(pvo, this.view, selection));
        }
        manager.add((IContributionItem)subMenu);
    }

    public void fillClipboardContextMenu(IMenuManager manager, TableItem[] selection) {
        Table table = this.view.getTableViewer().getTable();
        if (selection.length == 1) {
            int col = Utils.mouse2columnIndex(table);
            TableItem item = Utils.mouse2tableItem(table);
            if (item != null && col != -1 && StringUtils.hasText(item.getText(col))) {
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IAction)new CopyTableToClipboardAction(this.view, item, col));
            }
        }
        MenuManager subMenu = new MenuManager("Copy selection as...");
        subMenu.add((IAction)new CopyTableToClipboardAction(this.view, selection, CopyTableToClipboardAction.Type.FORMATTED, this.view.getTimeZone()));
        subMenu.add((IAction)new CopyTableToClipboardAction(this.view, selection, CopyTableToClipboardAction.Type.UNFORMATTED, this.view.getTimeZone()));
        subMenu.add((IAction)new CopyTableToClipboardAction(this.view, selection, CopyTableToClipboardAction.Type.CSV, this.view.getTimeZone()));
        manager.add((IContributionItem)subMenu);
    }

    public void fillFocusContextMenu(boolean focus, IMenuManager manager, LoggingEventVO drillEvent) {
        MenuManager subMenu = new MenuManager(focus ? "Focus on events..." : "Hide events...");
        subMenu.add((IAction)new FilterAction(focus ? FilterAction.TYPE.FOCUS_DOMAIN : FilterAction.TYPE.IGNORE_DOMAIN, this.view));
        subMenu.add((IAction)new FilterAction(focus ? FilterAction.TYPE.FOCUS_HOST : FilterAction.TYPE.IGNORE_HOST, this.view));
        if (StringUtils.hasText(ComponentsModel.getInstance().getComponent(drillEvent))) {
            subMenu.add((IAction)new FilterAction(focus ? FilterAction.TYPE.FOCUS_COMPONENT : FilterAction.TYPE.IGNORE_COMPONENT, this.view));
        }
        subMenu.add((IAction)new FilterAction(focus ? FilterAction.TYPE.FOCUS_LOGGER : FilterAction.TYPE.IGNORE_LOGGER, this.view));
        if (StringUtils.hasText(drillEvent.getThreadName())) {
            subMenu.add((IAction)new FilterAction(focus ? FilterAction.TYPE.FOCUS_THREAD : FilterAction.TYPE.IGNORE_THREAD, this.view));
        }
        subMenu.add((IAction)new FilterAction(focus ? FilterAction.TYPE.FOCUS_MESSAGE : FilterAction.TYPE.IGNORE_MESSAGE, this.view));
        TagVO tag = TagsModel.getInstance().findOne((LogEvent)drillEvent);
        if (tag != null) {
            subMenu.add((IAction)new FilterAction(focus ? FilterAction.TYPE.FOCUS_TAG : FilterAction.TYPE.IGNORE_TAG, this.view, tag));
        }
        subMenu.add((IContributionItem)new Separator("additions"));
        Iterator iterator = MdcMap.getKeys().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            String mdcValue = drillEvent.getProperty(MdcMap.getName((int)key));
            if (mdcValue == null || mdcValue.length() <= 0) continue;
            subMenu.add((IAction)new FilterAction(focus ? FilterAction.TYPE.FOCUS_MDC : FilterAction.TYPE.IGNORE_MDC, this.view, key, mdcValue));
        }
        manager.add((IContributionItem)subMenu);
    }

    private void fillIgnoreContextMenu(IMenuManager manager) {
        if (this.perspectiveVO == null) {
            return;
        }
        MenuManager subMenu = new MenuManager("Permanently ignore...");
        IgnoreAction.Type[] typeArray = IgnoreAction.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IgnoreAction.Type type = typeArray[n2];
            subMenu.add((IAction)new IgnoreAction(this.view, this.perspectiveVO, type));
            ++n2;
        }
        manager.add((IContributionItem)subMenu);
    }

    public void fillFollowContextMenu(IMenuManager manager, LoggingEventVO drillEvent) {
        TagVO tag;
        manager.add((IContributionItem)new Separator("additions"));
        MenuManager subMenu = new MenuManager("Follow in real time...");
        subMenu.add((IAction)new FollowEventAction(drillEvent, EventAttribute.domainName.name(), null));
        subMenu.add((IAction)new FollowEventAction(drillEvent, EventAttribute.hostName.name(), null));
        subMenu.add((IAction)new FollowEventAction(drillEvent, EventAttribute.loggerName.name(), null));
        subMenu.add((IAction)new FollowEventAction(drillEvent, EventAttribute.threadName.name(), null));
        ComponentModel component = ComponentsModel.getInstance().getComponentModel(drillEvent);
        if (component != null) {
            subMenu.add((IAction)new FollowEventAction(drillEvent, component));
        }
        if ((tag = TagsModel.getInstance().findOne((LogEvent)drillEvent)) != null) {
            subMenu.add((IAction)new FollowEventAction(drillEvent, tag));
        }
        if (!MdcMap.getNames().isEmpty()) {
            subMenu.add((IContributionItem)new Separator("additions"));
        }
        for (String name : MdcMap.getNames()) {
            String value = drillEvent.getProperty(name);
            if (!StringUtils.hasText(value)) continue;
            subMenu.add((IAction)new FollowEventAction(drillEvent, name, null));
        }
        manager.add((IContributionItem)subMenu);
    }

    protected void fillDrillContextMenu(IMenuManager manager, LoggingEventVO drillEvent) {
        TagVO tag = TagsModel.getInstance().findOne((LogEvent)drillEvent);
        ComponentModel component = ComponentsModel.getInstance().getComponentModel(drillEvent);
        TimeZone tz = this.view.getTimeZone();
        MenuManager subMenu = new MenuManager("Fetch identical events in range of...");
        subMenu.add((IAction)new QueryDrillDownAction(drillEvent, TimeRange.RANGE_15_SEC, tz));
        subMenu.add((IAction)new QueryDrillDownAction(drillEvent, TimeRange.RANGE_1_MIN, tz));
        subMenu.add((IAction)new QueryDrillDownAction(drillEvent, TimeRange.RANGE_5_MIN, tz));
        subMenu.add((IAction)new QueryDrillDownAction(drillEvent, TimeRange.RANGE_30_MIN, tz));
        subMenu.add((IAction)new QueryDrillDownAction(drillEvent, TimeRange.RANGE_1_HOUR, tz));
        subMenu.add((IAction)new QueryDrillDownAction(drillEvent, TimeRange.RANGE_2_HOURS, tz));
        subMenu.add((IAction)new QueryDrillDownAction(drillEvent, TimeRange.RANGE_4_HOURS, tz));
        subMenu.add((IAction)new QueryDrillDownAction(drillEvent, TimeRange.RANGE_8_HOURS, tz));
        subMenu.add((IAction)new QueryDrillDownAction(drillEvent, TimeRange.RANGE_1_DAY, tz));
        manager.add((IContributionItem)subMenu);
        if (tag != null) {
            subMenu = new MenuManager(String.format("Fetch tag '%s' in range of...", tag.getName()));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, null, tag, TimeRange.RANGE_15_SEC, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, null, tag, TimeRange.RANGE_1_MIN, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, null, tag, TimeRange.RANGE_5_MIN, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, null, tag, TimeRange.RANGE_30_MIN, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, null, tag, TimeRange.RANGE_1_HOUR, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, null, tag, TimeRange.RANGE_2_HOURS, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, null, tag, TimeRange.RANGE_4_HOURS, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, null, tag, TimeRange.RANGE_8_HOURS, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, null, tag, TimeRange.RANGE_1_DAY, tz));
            manager.add((IContributionItem)subMenu);
        }
        if (component != null) {
            subMenu = new MenuManager(String.format("Fetch component '%s' in range of...", component.getName()));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, component, null, TimeRange.RANGE_15_SEC, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, component, null, TimeRange.RANGE_1_MIN, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, component, null, TimeRange.RANGE_5_MIN, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, component, null, TimeRange.RANGE_30_MIN, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, component, null, TimeRange.RANGE_1_HOUR, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, component, null, TimeRange.RANGE_2_HOURS, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, component, null, TimeRange.RANGE_4_HOURS, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, component, null, TimeRange.RANGE_8_HOURS, tz));
            subMenu.add((IAction)new QueryDrillDownAction(drillEvent, component, null, TimeRange.RANGE_1_DAY, tz));
            manager.add((IContributionItem)subMenu);
        }
        manager.add((IContributionItem)new Separator("additions"));
        subMenu = new MenuManager("What happened before..");
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.BEFORE_15_SEC);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.BEFORE_1_MIN);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.BEFORE_5_MIN);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.BEFORE_30_MIN);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.BEFORE_1_HOUR);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.BEFORE_2_HOURS);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.BEFORE_4_HOURS);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.BEFORE_8_HOURS);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.BEFORE_1_DAY);
        manager.add((IContributionItem)subMenu);
        subMenu = new MenuManager("What happened after..");
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.AFTER_15_SEC);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.AFTER_1_MIN);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.AFTER_5_MIN);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.AFTER_30_MIN);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.AFTER_1_HOUR);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.AFTER_2_HOURS);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.AFTER_4_HOURS);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.AFTER_8_HOURS);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.AFTER_1_DAY);
        manager.add((IContributionItem)subMenu);
        subMenu = new MenuManager("What happened in range of..");
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.RANGE_15_SEC);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.RANGE_1_MIN);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.RANGE_5_MIN);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.RANGE_30_MIN);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.RANGE_1_HOUR);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.RANGE_2_HOURS);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.RANGE_4_HOURS);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.RANGE_8_HOURS);
        this.makeDrillMenu((IMenuManager)subMenu, drillEvent, TimeRange.RANGE_1_DAY);
        manager.add((IContributionItem)subMenu);
    }

    private void makeDrillMenu(IMenuManager parent, LoggingEventVO drillEvent, TimeRange range) {
        MenuManager menu = new MenuManager(range.toString());
        TimeZone tz = this.view.getTimeZone();
        menu.add((IAction)new QueryDrillDownAction(drillEvent, EventAttribute.domainName.name(), range, tz, null));
        menu.add((IAction)new QueryDrillDownAction(drillEvent, EventAttribute.hostName.name(), range, tz, null));
        menu.add((IAction)new QueryDrillDownAction(drillEvent, EventAttribute.loggerName.name(), range, tz, null));
        menu.add((IAction)new QueryDrillDownAction(drillEvent, EventAttribute.threadName.name(), range, tz, null));
        menu.add((IAction)new QueryDrillDownAction(drillEvent, EventAttribute.message.name(), range, tz, null));
        menu.add((IContributionItem)new Separator("additions"));
        for (String mdc : MdcMap.getNames()) {
            String value = drillEvent.getProperty(mdc);
            if (!StringUtils.hasText(value)) continue;
            menu.add((IAction)new QueryDrillDownAction(drillEvent, mdc, range, tz, null));
        }
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IAction)new QueryDrillDownAction(drillEvent, null, range, tz, null));
        parent.add((IContributionItem)menu);
    }
}

