/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.utils;

import com.moonlit.logfaces.client.net.ConnectionProfile;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.util.Revision;

public class Compatibility {
    public static boolean canUseTurboQuery() {
        Revision srev;
        Revision min;
        block3: {
            try {
                min = Revision.parse((String)"3.2.0.2318");
                srev = ConnectionProfile.getInstance().getRevision();
                if (!srev.toString().equals("0.0.0.0")) break block3;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return srev.compareTo(min) >= 0;
    }

    public static boolean canUseTurboRepo() {
        Revision srev;
        Revision min;
        block3: {
            try {
                min = Revision.parse((String)"4.0.0.2582");
                srev = ConnectionProfile.getInstance().getRevision();
                if (!srev.toString().equals("0.0.0.0")) break block3;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return srev.compareTo(min) >= 0;
    }

    public static boolean canUseDashboards() {
        Revision srev;
        Revision min;
        block3: {
            try {
                min = Revision.parse((String)"4.2.0");
                srev = ConnectionProfile.getInstance().getRevision();
                if (!srev.toString().equals("0.0.0.0")) break block3;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return srev.compareTo(min) >= 0;
    }

    public static boolean canUsePlugins() {
        Revision srev;
        Revision min;
        block3: {
            try {
                min = Revision.parse((String)"5.0.0");
                srev = ConnectionProfile.getInstance().getRevision();
                if (!srev.toString().equals("0.0.0.0")) break block3;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return srev.compareTo(min) >= 0;
    }

    public static boolean canUseAlerts() {
        Revision srev;
        Revision min;
        block3: {
            try {
                min = Revision.parse((String)"5.2.0");
                srev = ConnectionProfile.getInstance().getRevision();
                if (!srev.toString().equals("0.0.0.0")) break block3;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return srev.compareTo(min) >= 0;
    }

    public static boolean canUsePins() {
        Revision srev;
        Revision min;
        block3: {
            try {
                min = Revision.parse((String)"5.3.1");
                srev = ConnectionProfile.getInstance().getRevision();
                if (!srev.toString().equals("0.0.0.0")) break block3;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return srev.compareTo(min) >= 0;
    }

    public static void isServerCompatible(LfsRemote remote) throws Exception {
        Revision min = Revision.parse((String)"4.0.0.0");
        Revision srev = Revision.parse((String)remote.getRevision());
        if (srev.toString().equals("0.0.0.0")) {
            return;
        }
        if (srev.compareTo(min) < 0) {
            throw new Exception(String.format("Server version %s is not compatible with this client. Please upgrade your server to at least v4.0.0", srev));
        }
    }
}

