/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.utils;

import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.stats.StatCategory;
import java.awt.Color;
import java.util.Map;
import java.util.Random;
import org.eclipse.swt.graphics.RGB;

public class ColorPicker {
    private Random random = new Random();
    private static ColorPicker instance;
    private Map<String, org.eclipse.swt.graphics.Color> colors;

    public static synchronized ColorPicker getInstance() {
        if (instance == null) {
            instance = new ColorPicker();
        }
        return instance;
    }

    private ColorPicker() {
        this.random.setSeed(System.currentTimeMillis());
        this.colors = Maps.newHashMap();
    }

    public void init() {
        this.random = new Random();
        this.random.setSeed(System.currentTimeMillis());
        this.colors.clear();
        this.colors.put(StatCategory.exception.name(), EventStyles.RULER_ERROR);
        this.colors.put("unknown", EventStyles.BG_LFS);
        EventStyles styles = EventStyles.getInstance();
        for (LfsLevel level : LfsLevel.toList()) {
            org.eclipse.swt.graphics.Color color = styles.getDarkerBackground(level.intLevel());
            this.colors.put(level.toString(), color);
        }
        for (TagVO tag : TagsModel.getInstance().getTags()) {
            this.colors.put(tag.getName(), tag.getColor());
        }
    }

    public Color pickAwt(String key) {
        return Utils.swt2awtColor(this.pick(key));
    }

    public org.eclipse.swt.graphics.Color pick(String key) {
        if (key == null) {
            return this.colors.get("unknown");
        }
        org.eclipse.swt.graphics.Color color = this.colors.get(key);
        if (color != null) {
            return color;
        }
        return this.invent(key);
    }

    public org.eclipse.swt.graphics.Color invent(String key) {
        float hue = this.random.nextInt(360);
        float saturation = (float)(this.random.nextInt(2000) + 1000) / 10000.0f;
        float luminance = 0.9f;
        org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color(null, new RGB(hue, saturation, luminance));
        this.colors.put(key, color);
        return color;
    }
}

