/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.utils;

import com.moonlit.logfaces.client.dialogs.AuthDialog;
import com.moonlit.logfaces.client.model.SourceMappingModel;
import com.moonlit.logfaces.client.model.UrlVO;
import java.net.PasswordAuthentication;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.swt.widgets.Display;

public class BasicAuthenticator {
    private SourceMappingModel sourceMapping = SourceMappingModel.getInstance();
    private PasswordAuthentication last = null;
    private static BasicAuthenticator instance;

    public static BasicAuthenticator getInstance() {
        if (instance == null) {
            instance = new BasicAuthenticator();
        }
        return instance;
    }

    public String getCredentials(final UrlVO location, boolean prompt) {
        if (!prompt) {
            this.last = this.sourceMapping.findAuthentication(location.getUrl());
            if (this.last != null) {
                return this.encode();
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AuthDialog dlg = new AuthDialog(BasicAuthenticator.this.last);
                dlg.create();
                dlg.setNote(String.format("Authentication is required to access this URL:%n%s", location.getUrl()));
                dlg.getShell().setText("Authentication is required");
                if (dlg.open() != 0) {
                    BasicAuthenticator.this.last = null;
                    return;
                }
                BasicAuthenticator.this.last = new PasswordAuthentication(dlg.getUserName(), dlg.getClearPassword().toCharArray());
            }
        });
        return this.encode();
    }

    private String encode() {
        if (this.last == null) {
            return null;
        }
        String auth = String.format("%s:%s", this.last.getUserName(), new String(this.last.getPassword()));
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
        return new String(encodedAuth);
    }

    public void storeLastPassword(UrlVO location) {
        location.setUserName(this.last != null ? this.last.getUserName() : "");
        location.setPassword(this.last != null ? new String(this.last.getPassword()) : "");
    }
}

