/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.joda.time.DateTime;

public enum TimeRange {
    BEFORE_1_MIN,
    BEFORE_5_MIN,
    BEFORE_15_MIN,
    BEFORE_30_MIN,
    BEFORE_1_HOUR,
    BEFORE_2_HOURS,
    BEFORE_4_HOURS,
    BEFORE_8_HOURS,
    BEFORE_1_DAY,
    BEFORE_2_DAY,
    BEFORE_1_WEEK,
    BEFORE_2_WEEKS,
    BEFORE_1_MONTH,
    AFTER_1_MIN,
    AFTER_5_MIN,
    AFTER_15_MIN,
    AFTER_30_MIN,
    AFTER_1_HOUR,
    AFTER_2_HOURS,
    AFTER_4_HOURS,
    AFTER_8_HOURS,
    AFTER_1_DAY,
    RANGE_1_MIN,
    RANGE_5_MIN,
    RANGE_15_MIN,
    RANGE_30_MIN,
    RANGE_1_HOUR,
    RANGE_2_HOURS,
    RANGE_4_HOURS,
    RANGE_8_HOURS,
    RANGE_1_DAY,
    RANGE_1_WEEK,
    RANGE_1_MONTH,
    ALL,
    PARTICULAR_DAY,
    CUSTOM_RANGE,
    TODAY,
    YESTERDAY,
    BEFORE_15_SEC,
    AFTER_15_SEC,
    RANGE_15_SEC;

    private long from;
    private long until;
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long MONTH = 2678400000L;

    public void setCustomRange(long from, long until) {
        this.from = from;
        this.until = until;
    }

    public long getTime(boolean first) {
        return this.getTime(first, System.currentTimeMillis());
    }

    public long getTime(boolean first, long time) {
        switch (this) {
            case BEFORE_15_SEC: {
                return first ? time - 15000L : time;
            }
            case BEFORE_1_MIN: {
                return first ? time - 60000L : time;
            }
            case BEFORE_5_MIN: {
                return first ? time - 300000L : time;
            }
            case BEFORE_15_MIN: {
                return first ? time - 900000L : time;
            }
            case BEFORE_30_MIN: {
                return first ? time - 600000L : time;
            }
            case BEFORE_1_HOUR: {
                return first ? time - 3600000L : time;
            }
            case BEFORE_2_HOURS: {
                return first ? time - 0x6DDD00L : time;
            }
            case BEFORE_4_HOURS: {
                return first ? time - 14400000L : time;
            }
            case BEFORE_8_HOURS: {
                return first ? time - 28800000L : time;
            }
            case BEFORE_1_DAY: {
                return first ? time - 86400000L : time;
            }
            case BEFORE_2_DAY: {
                return first ? time - 172800000L : time;
            }
            case BEFORE_1_WEEK: {
                return first ? time - 604800000L : time;
            }
            case BEFORE_2_WEEKS: {
                return first ? time - 1209600000L : time;
            }
            case BEFORE_1_MONTH: {
                return first ? time - 2419200000L : time;
            }
            case AFTER_15_SEC: {
                return first ? time : time + 15000L;
            }
            case AFTER_1_MIN: {
                return first ? time : time + 60000L;
            }
            case AFTER_5_MIN: {
                return first ? time : time + 300000L;
            }
            case AFTER_15_MIN: {
                return first ? time : time + 900000L;
            }
            case AFTER_30_MIN: {
                return first ? time : time + 600000L;
            }
            case AFTER_1_HOUR: {
                return first ? time : time + 3600000L;
            }
            case AFTER_2_HOURS: {
                return first ? time : time + 0x6DDD00L;
            }
            case AFTER_4_HOURS: {
                return first ? time : time + 14400000L;
            }
            case AFTER_8_HOURS: {
                return first ? time : time + 28800000L;
            }
            case AFTER_1_DAY: {
                return first ? time : time + 86400000L;
            }
            case RANGE_15_SEC: {
                return first ? time - 15000L : time + 15000L;
            }
            case RANGE_1_MIN: {
                return first ? time - 60000L : time + 60000L;
            }
            case RANGE_5_MIN: {
                return first ? time - 300000L : time + 300000L;
            }
            case RANGE_15_MIN: {
                return first ? time - 900000L : time + 900000L;
            }
            case RANGE_30_MIN: {
                return first ? time - 1800000L : time + 1800000L;
            }
            case RANGE_1_HOUR: {
                return first ? time - 3600000L : time + 3600000L;
            }
            case RANGE_2_HOURS: {
                return first ? time - 0x6DDD00L : time + 0x6DDD00L;
            }
            case RANGE_4_HOURS: {
                return first ? time - 14400000L : time + 14400000L;
            }
            case RANGE_8_HOURS: {
                return first ? time - 28800000L : time + 28800000L;
            }
            case RANGE_1_DAY: {
                return first ? time - 86400000L : time + 86400000L;
            }
            case RANGE_1_WEEK: {
                return first ? time - 604800000L : time + 604800000L;
            }
            case RANGE_1_MONTH: {
                return first ? time - 2678400000L : time + 2678400000L;
            }
            case ALL: {
                return first ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            case TODAY: {
                DateTime dt = DateTime.now().withTimeAtStartOfDay();
                this.setCustomRange(dt.getMillis(), dt.plusDays(1).getMillis());
                return first ? this.from : this.until;
            }
            case YESTERDAY: {
                DateTime dt = DateTime.now().withTimeAtStartOfDay().minusDays(1);
                this.setCustomRange(dt.getMillis(), dt.plusDays(1).getMillis());
                return first ? this.from : this.until;
            }
            case PARTICULAR_DAY: 
            case CUSTOM_RANGE: {
                return first ? this.from : this.until;
            }
        }
        return 0L;
    }

    public long getRange() {
        switch (this) {
            case BEFORE_15_SEC: 
            case AFTER_15_SEC: 
            case RANGE_15_SEC: {
                return 15000L;
            }
            case BEFORE_1_MIN: 
            case AFTER_1_MIN: 
            case RANGE_1_MIN: {
                return 60000L;
            }
            case BEFORE_5_MIN: 
            case AFTER_5_MIN: 
            case RANGE_5_MIN: {
                return 300000L;
            }
            case BEFORE_15_MIN: 
            case AFTER_15_MIN: 
            case RANGE_15_MIN: {
                return 900000L;
            }
            case BEFORE_30_MIN: 
            case AFTER_30_MIN: 
            case RANGE_30_MIN: {
                return 1800000L;
            }
            case BEFORE_1_HOUR: 
            case AFTER_1_HOUR: 
            case RANGE_1_HOUR: {
                return 3600000L;
            }
            case BEFORE_2_HOURS: 
            case AFTER_2_HOURS: 
            case RANGE_2_HOURS: {
                return 0x6DDD00L;
            }
            case BEFORE_4_HOURS: 
            case AFTER_4_HOURS: 
            case RANGE_4_HOURS: {
                return 14400000L;
            }
            case BEFORE_8_HOURS: 
            case AFTER_8_HOURS: 
            case RANGE_8_HOURS: {
                return 28800000L;
            }
            case BEFORE_1_DAY: 
            case AFTER_1_DAY: 
            case RANGE_1_DAY: {
                return 86400000L;
            }
            case BEFORE_1_WEEK: 
            case RANGE_1_WEEK: {
                return 604800000L;
            }
            case RANGE_1_MONTH: {
                return 2678400000L;
            }
            case PARTICULAR_DAY: 
            case TODAY: 
            case YESTERDAY: {
                return 86400000L;
            }
            case CUSTOM_RANGE: {
                return this.until - this.from;
            }
            case ALL: {
                return Long.MAX_VALUE;
            }
        }
        return 0L;
    }

    public long getRangeAdjusted(long span, int max) {
        long rate = this.getRange();
        if (span / rate > (long)max) {
            return span / (long)max;
        }
        return rate;
    }

    public TimePeriod toTimePeriod() {
        long now = System.currentTimeMillis();
        return new SimpleTimePeriod(this.getTime(true, now), this.getTime(false, now));
    }

    public String toString() {
        switch (this) {
            case BEFORE_15_SEC: 
            case AFTER_15_SEC: 
            case RANGE_15_SEC: {
                return "15 seconds";
            }
            case BEFORE_1_MIN: 
            case AFTER_1_MIN: 
            case RANGE_1_MIN: {
                return "1 minute";
            }
            case BEFORE_5_MIN: 
            case AFTER_5_MIN: 
            case RANGE_5_MIN: {
                return "5 minutes";
            }
            case BEFORE_15_MIN: 
            case AFTER_15_MIN: 
            case RANGE_15_MIN: {
                return "15 minutes";
            }
            case BEFORE_30_MIN: 
            case AFTER_30_MIN: 
            case RANGE_30_MIN: {
                return "30 minutes";
            }
            case BEFORE_1_HOUR: 
            case AFTER_1_HOUR: 
            case RANGE_1_HOUR: {
                return "1 hour";
            }
            case BEFORE_2_HOURS: 
            case AFTER_2_HOURS: 
            case RANGE_2_HOURS: {
                return "2 hours";
            }
            case BEFORE_4_HOURS: 
            case AFTER_4_HOURS: 
            case RANGE_4_HOURS: {
                return "4 hours";
            }
            case BEFORE_8_HOURS: 
            case AFTER_8_HOURS: 
            case RANGE_8_HOURS: {
                return "8 hours";
            }
            case BEFORE_1_DAY: 
            case AFTER_1_DAY: 
            case RANGE_1_DAY: {
                return "1 day";
            }
            case BEFORE_2_DAY: {
                return "2 days";
            }
            case BEFORE_1_WEEK: 
            case RANGE_1_WEEK: {
                return "1 week";
            }
            case BEFORE_2_WEEKS: {
                return "2 weeks";
            }
            case BEFORE_1_MONTH: 
            case RANGE_1_MONTH: {
                return "1 month";
            }
            case ALL: {
                return "all times";
            }
            case PARTICULAR_DAY: {
                return "particular day";
            }
            case CUSTOM_RANGE: {
                return "custom range";
            }
            case TODAY: {
                return "today";
            }
            case YESTERDAY: {
                return "yesterday";
            }
        }
        return "?";
    }

    public boolean is(String title) {
        return this.toString().equals(title);
    }

    public static TimeRange fromString(String string) {
        TimeRange[] timeRangeArray = TimeRange.values();
        int n = timeRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeRange range = timeRangeArray[n2];
            if (range.toString().equals(string)) {
                return range;
            }
            ++n2;
        }
        return null;
    }

    public static TimeRange fromInteger(int value) {
        if (value >= 0 && value < TimeRange.values().length) {
            return TimeRange.values()[value];
        }
        return BEFORE_1_HOUR;
    }

    public static TimeRange fromLegacy(int value) {
        switch (value) {
            case 0: {
                return BEFORE_1_HOUR;
            }
            case 1: {
                return BEFORE_2_HOURS;
            }
            case 2: {
                return BEFORE_4_HOURS;
            }
            case 3: {
                return BEFORE_8_HOURS;
            }
            case 4: {
                return BEFORE_1_DAY;
            }
            case 5: {
                return BEFORE_2_DAY;
            }
            case 6: {
                return BEFORE_1_WEEK;
            }
            case 7: {
                return BEFORE_2_WEEKS;
            }
            case 8: {
                return BEFORE_1_MONTH;
            }
            case 9: {
                return ALL;
            }
            case 10: {
                return PARTICULAR_DAY;
            }
        }
        return CUSTOM_RANGE;
    }

    public static TimeRange[] getRangesForDashboards() {
        ArrayList list = Lists.newArrayList();
        list.add(BEFORE_5_MIN);
        list.add(BEFORE_15_MIN);
        list.add(BEFORE_1_HOUR);
        list.add(BEFORE_2_HOURS);
        list.add(BEFORE_4_HOURS);
        list.add(BEFORE_8_HOURS);
        list.add(TODAY);
        list.add(YESTERDAY);
        list.add(PARTICULAR_DAY);
        list.add(CUSTOM_RANGE);
        return list.toArray(new TimeRange[list.size()]);
    }

    public String toDashboardLabel() {
        switch (this) {
            case BEFORE_1_MIN: 
            case AFTER_1_MIN: 
            case RANGE_1_MIN: {
                return "display data for the past minute";
            }
            case BEFORE_5_MIN: 
            case AFTER_5_MIN: 
            case RANGE_5_MIN: {
                return "display data for the past 5 minutes";
            }
            case BEFORE_15_MIN: 
            case AFTER_15_MIN: 
            case RANGE_15_MIN: {
                return "display data for the past 15 minutes";
            }
            case BEFORE_30_MIN: 
            case AFTER_30_MIN: 
            case RANGE_30_MIN: {
                return "display data for the past 30 minutes";
            }
            case BEFORE_1_HOUR: 
            case AFTER_1_HOUR: 
            case RANGE_1_HOUR: {
                return "display data for the past hour";
            }
            case BEFORE_2_HOURS: 
            case AFTER_2_HOURS: 
            case RANGE_2_HOURS: {
                return "display data for the past 2 hours";
            }
            case BEFORE_4_HOURS: 
            case AFTER_4_HOURS: 
            case RANGE_4_HOURS: {
                return "display data for the past 4 hours";
            }
            case BEFORE_8_HOURS: 
            case AFTER_8_HOURS: 
            case RANGE_8_HOURS: {
                return "display data for the past 8 hours";
            }
            case BEFORE_1_DAY: 
            case AFTER_1_DAY: 
            case RANGE_1_DAY: {
                return "display data for the past 24 hours";
            }
            case BEFORE_2_DAY: {
                return "display data for the past 2 days";
            }
            case BEFORE_1_WEEK: 
            case RANGE_1_WEEK: {
                return "display data for the past week";
            }
            case BEFORE_2_WEEKS: {
                return "display data for the past 2 weeks";
            }
            case BEFORE_1_MONTH: 
            case RANGE_1_MONTH: {
                return "display data for the past 30 days";
            }
            case ALL: {
                return "display all data";
            }
            case PARTICULAR_DAY: {
                return "display data for specific day";
            }
            case CUSTOM_RANGE: {
                return "display data for custom range";
            }
            case TODAY: {
                return "display today's data";
            }
            case YESTERDAY: {
                return "display yesterday's data";
            }
        }
        return "";
    }
}

