/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.types;

public enum SizeLimit {
    S1,
    S10,
    S100,
    S1K,
    S10K,
    S100K,
    SM,
    ALL;


    public String toString() {
        switch (this) {
            case ALL: {
                return "everything available";
            }
            case S1: {
                return "first available record";
            }
            case S10: {
                return "no more than 10 records";
            }
            case S100: {
                return "no more than 100 records";
            }
            case S1K: {
                return "no more than 1K records";
            }
            case S10K: {
                return "no more than 10K records";
            }
            case S100K: {
                return "no more than 100K records";
            }
            case SM: {
                return "no more than 1000K records";
            }
        }
        return "";
    }

    public static SizeLimit fromString(String string) {
        SizeLimit[] sizeLimitArray = SizeLimit.values();
        int n = sizeLimitArray.length;
        int n2 = 0;
        while (n2 < n) {
            SizeLimit limit = sizeLimitArray[n2];
            if (limit.toString().equals(string)) {
                return limit;
            }
            ++n2;
        }
        return null;
    }

    public int getSizeLimit() {
        switch (this) {
            case S1: {
                return 1;
            }
            case S10: {
                return 10;
            }
            case S100: {
                return 100;
            }
            case S1K: {
                return 1000;
            }
            case S10K: {
                return 10000;
            }
            case S100K: {
                return 100000;
            }
            case SM: {
                return 1000000;
            }
        }
        return -1;
    }

    public static SizeLimit fromInteger(int size) {
        if (size < 0) {
            return ALL;
        }
        if (size <= S1.getSizeLimit()) {
            return S1;
        }
        if (size <= S10.getSizeLimit()) {
            return S10;
        }
        if (size <= S100.getSizeLimit()) {
            return S100;
        }
        if (size <= S1K.getSizeLimit()) {
            return S1K;
        }
        if (size <= S10K.getSizeLimit()) {
            return S10K;
        }
        if (size <= S100K.getSizeLimit()) {
            return S100K;
        }
        if (size <= SM.getSizeLimit()) {
            return SM;
        }
        return ALL;
    }
}

