/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.types;

public enum MaxContributors {
    ALL,
    C5,
    C10,
    C20,
    C100;


    public String toString() {
        switch (this) {
            case C5: {
                return "Display first 5 contributors";
            }
            case C10: {
                return "Display first 10 contributors";
            }
            case C20: {
                return "Display first 20 contributors";
            }
            case C100: {
                return "Display first 100 contributors";
            }
        }
        return "Display all contributors";
    }

    public static MaxContributors fromNumber(int number) {
        switch (number) {
            case 5: {
                return C5;
            }
            case 10: {
                return C10;
            }
            case 20: {
                return C20;
            }
            case 100: {
                return C100;
            }
        }
        return ALL;
    }

    public static MaxContributors fromString(String input) {
        if (input == null) {
            return ALL;
        }
        if (input.contains("5")) {
            return C5;
        }
        if (input.contains("10")) {
            return C10;
        }
        if (input.contains("20")) {
            return C20;
        }
        if (input.contains("100")) {
            return C100;
        }
        return ALL;
    }

    public int toNumber() {
        switch (this) {
            case C5: {
                return 5;
            }
            case C10: {
                return 10;
            }
            case C20: {
                return 20;
            }
            case C100: {
                return 100;
            }
        }
        return 0;
    }
}

