/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.types;

import com.moonlit.logfaces.client.gis.GisLocation;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import java.util.List;

public class LfcEvent {
    private TYPE type;
    private Object context;

    public LfcEvent(TYPE type, Object context) {
        this.type = type;
        this.context = context;
    }

    public LfcEvent(TYPE type) {
        this.type = type;
    }

    public static LfcEvent connection(LfsRemote remote) {
        return remote != null ? new LfcEvent(TYPE.CONNECTED, remote) : new LfcEvent(TYPE.DISCONNECTED);
    }

    public static LfcEvent workspaceLoaded(String name) {
        return new LfcEvent(TYPE.WORKSPACE_LOADED, name);
    }

    public static LfcEvent workspaceRemoved(String name) {
        return new LfcEvent(TYPE.WORKSPACE_REMOVED, name);
    }

    public static LfcEvent dashboardsModel() {
        return new LfcEvent(TYPE.DASHBOARDS_MODEL);
    }

    public static LfcEvent alerts(List<?> alerts) {
        return new LfcEvent(TYPE.ALERTS, alerts);
    }

    public static LfcEvent gis(GisLocation location, boolean rightClick) {
        return new LfcEvent(rightClick ? TYPE.GIS_CONTEXT : TYPE.GIS_SELECT, (Object)location);
    }

    public static LfcEvent pins() {
        return new LfcEvent(TYPE.PINS);
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public boolean is(TYPE type) {
        return this.type.equals((Object)type);
    }

    public static enum TYPE {
        CONNECTED,
        DISCONNECTED,
        WORKSPACE_LOADED,
        WORKSPACE_REMOVED,
        DASHBOARDS_MODEL,
        ALERTS,
        GIS_SELECT,
        GIS_CONTEXT,
        PINS;

    }
}

