/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.text;

import com.moonlit.logfaces.client.model.EventStyles;
import java.util.Vector;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class PatternsLineStyler
implements LineStyleListener {
    private int[] tokenColors;
    private Color[] colors;
    private Bullet bullet;
    public static final int EOF = -1;
    public static final int EOL = 10;
    public static final int WORD = 0;
    public static final int WHITE = 1;
    public static final int KEY = 2;
    public static final int COMMENT = 3;
    public static final int STRING = 5;
    public static final int OTHER = 6;
    public static final int NUMBER = 7;
    public static final int CURRENT = 8;
    public static final int BULLET = 9;
    public static final int MAXIMUM_TOKEN = 10;

    public PatternsLineStyler() {
        this.initializeColors();
        StyleRange style = new StyleRange();
        style.metrics = new GlyphMetrics(0, 0, 60);
        style.foreground = Display.getDefault().getSystemColor(16);
        this.bullet = new Bullet(18, style);
        this.bullet.text = " |";
    }

    private Color getColor(int type) {
        if (type < 0 || type >= this.tokenColors.length) {
            return null;
        }
        return this.colors[this.tokenColors[type]];
    }

    private void initializeColors() {
        Display display = Display.getDefault();
        this.colors = new Color[]{new Color((Device)display, new RGB(0, 0, 0)), new Color((Device)display, new RGB(63, 127, 95)), new Color((Device)display, new RGB(42, 0, 255)), new Color((Device)display, new RGB(127, 0, 85)), new Color((Device)display, new RGB(255, 240, 240)), new Color((Device)display, new RGB(166, 200, 241)), new Color((Device)display, new RGB(214, 214, 207))};
        this.tokenColors = new int[10];
        this.tokenColors[0] = 0;
        this.tokenColors[1] = 0;
        this.tokenColors[2] = 3;
        this.tokenColors[3] = 1;
        this.tokenColors[5] = 2;
        this.tokenColors[6] = 0;
        this.tokenColors[7] = 0;
        this.tokenColors[8] = 5;
        this.tokenColors[9] = 6;
    }

    public void dispose() {
        int i = 0;
        while (i < this.colors.length) {
            this.colors[i].dispose();
            ++i;
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        Vector<StyleRange> styles = new Vector<StyleRange>();
        Color background = null;
        int line = ((StyledText)event.widget).getLineAtOffset(event.lineOffset) + 1;
        event.bullet = this.bullet;
        event.bulletIndex = line - 1;
        if (event.lineText.startsWith("#")) {
            styles.addElement(new StyleRange(event.lineOffset, event.lineText.length(), this.getColor(3), background));
            event.styles = new StyleRange[styles.size()];
            styles.copyInto(event.styles);
            return;
        }
        StyleRange styleRange = new StyleRange(event.lineOffset, event.lineText.indexOf(" "), this.getColor(2), null);
        styleRange.fontStyle = 1;
        styles.add(styleRange);
        int from = event.lineText.indexOf("%{");
        while (from != -1) {
            int to = event.lineText.indexOf("}", from);
            if (to == -1) break;
            styleRange = new StyleRange(event.lineOffset + from, to - from + 1, EventStyles.BG_DRILL, null);
            String token = event.lineText.substring(from, to + 1);
            if (token.contains(":")) {
                styleRange.fontStyle = 1;
            }
            styles.add(styleRange);
            from = event.lineText.indexOf("%{", to);
        }
        event.styles = new StyleRange[styles.size()];
        styles.copyInto(event.styles);
    }
}

