/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.text;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.model.EventStyles;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class MessageBodyStyler
implements LineStyleListener,
MouseMoveListener {
    private StyledText styledText;
    private Cursor defaultCursor;
    private Pattern pattern;
    public static final String URI_REGEX = "\\w+:(\\/?\\/?)[^\\s]+";

    public MessageBodyStyler(StyledText text) {
        this.styledText = text;
        this.defaultCursor = text.getCursor();
        this.pattern = Pattern.compile((String)URI_REGEX);
    }

    public void lineGetStyle(LineStyleEvent event) {
        List<Point> list = this.getURILocations(event.lineText);
        if (list.isEmpty()) {
            return;
        }
        ArrayList styles = Lists.newArrayList();
        for (Point p : list) {
            StyleRange styleRange = new StyleRange(event.lineOffset + p.x, p.y, EventStyles.BG_DRILL, null);
            styleRange.underline = true;
            styles.add(styleRange);
            event.styles = styles.toArray(new StyleRange[0]);
        }
    }

    public void mouseMove(MouseEvent e) {
        Point point = new Point(e.x, e.y);
        int offset = this.styledText.getOffsetAtPoint(point);
        int line = this.styledText.getLineIndex(point.y);
        if (offset < 0 || offset >= this.styledText.getCharCount()) {
            this.styledText.setCursor(this.defaultCursor);
            return;
        }
        String lineText = this.styledText.getLine(line);
        List<Point> list = this.getURILocations(lineText);
        if (list.isEmpty()) {
            this.styledText.setCursor(this.defaultCursor);
            return;
        }
        Cursor theCursor = this.defaultCursor;
        int lineOffset = this.styledText.getOffsetAtLine(line);
        for (Point p : list) {
            if (offset < lineOffset + p.x || offset > lineOffset + p.x + p.y) continue;
            try {
                new URI(this.styledText.getText(lineOffset + p.x, lineOffset + p.x + p.y - 1));
                theCursor = Display.getCurrent().getSystemCursor(21);
            }
            catch (Exception exception) {}
            break;
        }
        this.styledText.setCursor(theCursor);
    }

    public URI getUriAt(Point point) {
        int offset = this.styledText.getOffsetAtPoint(point);
        int line = this.styledText.getLineIndex(point.y);
        if (offset < 0 || offset >= this.styledText.getCharCount()) {
            return null;
        }
        String lineText = this.styledText.getLine(line);
        List<Point> list = this.getURILocations(lineText);
        if (list.isEmpty()) {
            return null;
        }
        int lineOffset = this.styledText.getOffsetAtLine(line);
        for (Point p : list) {
            if (offset < lineOffset + p.x || offset > lineOffset + p.x + p.y) continue;
            try {
                String text = this.styledText.getText(lineOffset + p.x, lineOffset + p.x + p.y - 1);
                return new URI(text);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected List<Point> getURILocations(String text) {
        ArrayList list = Lists.newArrayList();
        Matcher matcher = this.pattern.matcher((CharSequence)text);
        while (matcher.find()) {
            list.add(new Point(matcher.start(), matcher.end() - matcher.start()));
        }
        return list;
    }
}

