/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.text;

import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class JavaLineStyler
implements LineStyleListener {
    JavaScanner scanner = new JavaScanner();
    int[] tokenColors;
    Color[] colors;
    Vector blockComments = new Vector();
    Bullet bullet;
    public static final int EOF = -1;
    public static final int EOL = 10;
    public static final int WORD = 0;
    public static final int WHITE = 1;
    public static final int KEY = 2;
    public static final int COMMENT = 3;
    public static final int STRING = 5;
    public static final int OTHER = 6;
    public static final int NUMBER = 7;
    public static final int CURRENT = 8;
    public static final int BULLET = 9;
    public static final int MAXIMUM_TOKEN = 10;

    public JavaLineStyler() {
        this.initializeColors();
        this.scanner = new JavaScanner();
        StyleRange style = new StyleRange();
        style.metrics = new GlyphMetrics(0, 0, 50);
        style.foreground = Display.getDefault().getSystemColor(16);
        this.bullet = new Bullet(18, style);
        this.bullet.text = " |";
    }

    Color getColor(int type) {
        if (type < 0 || type >= this.tokenColors.length) {
            return null;
        }
        return this.colors[this.tokenColors[type]];
    }

    boolean inBlockComment(int start, int end) {
        int i = 0;
        while (i < this.blockComments.size()) {
            int[] offsets = (int[])this.blockComments.elementAt(i);
            if (offsets[0] >= start && offsets[0] <= end) {
                return true;
            }
            if (offsets[1] >= start && offsets[1] <= end) {
                return true;
            }
            if (offsets[0] <= start && offsets[1] >= end) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void initializeColors() {
        Display display = Display.getDefault();
        this.colors = new Color[]{new Color((Device)display, new RGB(0, 0, 0)), new Color((Device)display, new RGB(63, 127, 95)), new Color((Device)display, new RGB(42, 0, 255)), new Color((Device)display, new RGB(127, 0, 85)), new Color((Device)display, new RGB(255, 240, 240)), new Color((Device)display, new RGB(166, 200, 241)), new Color((Device)display, new RGB(214, 214, 207))};
        this.tokenColors = new int[10];
        this.tokenColors[0] = 0;
        this.tokenColors[1] = 0;
        this.tokenColors[2] = 3;
        this.tokenColors[3] = 1;
        this.tokenColors[5] = 2;
        this.tokenColors[6] = 0;
        this.tokenColors[7] = 0;
        this.tokenColors[8] = 5;
        this.tokenColors[9] = 6;
    }

    public void dispose() {
        int i = 0;
        while (i < this.colors.length) {
            this.colors[i].dispose();
            ++i;
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        Vector<StyleRange> styles = new Vector<StyleRange>();
        Color background = null;
        int line = ((StyledText)event.widget).getLineAtOffset(event.lineOffset) + 1;
        event.bullet = this.bullet;
        event.bulletIndex = line - 1;
        Object obj = ((StyledText)event.widget).getData("currentLine");
        if (obj != null && line == (Integer)obj) {
            background = this.getColor(8);
            styles.addElement(new StyleRange(event.lineOffset, event.lineText.length(), null, background));
        }
        if (this.inBlockComment(event.lineOffset, event.lineOffset + event.lineText.length())) {
            styles.addElement(new StyleRange(event.lineOffset, event.lineText.length(), this.getColor(3), background));
            event.styles = new StyleRange[styles.size()];
            styles.copyInto(event.styles);
            return;
        }
        Color defaultFgColor = ((Control)event.widget).getForeground();
        this.scanner.setRange(event.lineText);
        int token = this.scanner.nextToken();
        while (token != -1) {
            if (token != 6) {
                StyleRange lastStyle;
                if (token != 1) {
                    Color color = this.getColor(token);
                    if (!color.equals((Object)defaultFgColor) || token == 2) {
                        StyleRange style = new StyleRange(this.scanner.getStartOffset() + event.lineOffset, this.scanner.getLength(), color, background);
                        if (token == 2) {
                            style.fontStyle = 1;
                        }
                        if (styles.isEmpty()) {
                            styles.addElement(style);
                        } else {
                            lastStyle = (StyleRange)styles.lastElement();
                            if (lastStyle.similarTo(style) && lastStyle.start + lastStyle.length == style.start) {
                                lastStyle.length += style.length;
                            } else {
                                styles.addElement(style);
                            }
                        }
                    }
                } else if (!styles.isEmpty()) {
                    lastStyle = (StyleRange)styles.lastElement();
                    if (lastStyle.fontStyle == 1) {
                        int start = this.scanner.getStartOffset() + event.lineOffset - 1;
                        lastStyle = (StyleRange)styles.lastElement();
                        if (lastStyle.start + lastStyle.length == start) {
                            lastStyle.length += this.scanner.getLength();
                        }
                    }
                }
            }
            token = this.scanner.nextToken();
        }
        event.styles = new StyleRange[styles.size()];
        styles.copyInto(event.styles);
    }

    public void parseBlockComments(String text) {
        this.blockComments = new Vector();
        StringReader buffer = new StringReader(text);
        boolean blkComment = false;
        int cnt = 0;
        int[] offsets = new int[2];
        boolean done = false;
        try {
            while (!done) {
                int ch = buffer.read();
                switch (ch) {
                    case -1: {
                        if (blkComment) {
                            offsets[1] = cnt;
                            this.blockComments.addElement(offsets);
                        }
                        done = true;
                        break;
                    }
                    case 47: {
                        ch = buffer.read();
                        if (ch == 42 && !blkComment) {
                            offsets = new int[2];
                            offsets[0] = cnt++;
                            blkComment = true;
                        } else {
                            ++cnt;
                        }
                        ++cnt;
                        break;
                    }
                    case 42: {
                        if (blkComment) {
                            ch = buffer.read();
                            ++cnt;
                            if (ch == 47) {
                                blkComment = false;
                                offsets[1] = cnt;
                                this.blockComments.addElement(offsets);
                            }
                        }
                        ++cnt;
                        break;
                    }
                    default: {
                        ++cnt;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class JavaScanner {
        protected Hashtable fgKeys = null;
        protected StringBuffer fBuffer = new StringBuffer();
        protected String fDoc;
        protected int fPos;
        protected int fEnd;
        protected int fStartToken;
        protected boolean fEofSeen = false;
        private String[] fgKeywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "#include", "using", "namespace"};

        public JavaScanner() {
            this.initialize();
        }

        public final int getLength() {
            return this.fPos - this.fStartToken;
        }

        void initialize() {
            this.fgKeys = new Hashtable();
            Integer k = 2;
            int i = 0;
            while (i < this.fgKeywords.length) {
                this.fgKeys.put(this.fgKeywords[i], k);
                ++i;
            }
        }

        public final int getStartOffset() {
            return this.fStartToken;
        }

        public int nextToken() {
            this.fStartToken = this.fPos;
            int c = this.read();
            switch (c) {
                case -1: {
                    return -1;
                }
                case 47: {
                    c = this.read();
                    if (c == 47) {
                        while ((c = this.read()) != -1 && c != 10) {
                        }
                        this.unread(c);
                        return 3;
                    }
                    this.unread(c);
                    return 6;
                }
                case 39: {
                    while (true) {
                        c = this.read();
                        switch (c) {
                            case 39: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                            }
                        }
                    }
                }
                case 34: {
                    while (true) {
                        c = this.read();
                        switch (c) {
                            case 34: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                            }
                        }
                    }
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (Character.isDigit((char)(c = this.read()))) {
                    }
                    this.unread(c);
                    return 7;
                }
            }
            if (Character.isWhitespace((char)c)) {
                while (Character.isWhitespace((char)(c = this.read()))) {
                }
                this.unread(c);
                return 1;
            }
            if (Character.isJavaIdentifierStart((char)c)) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                } while (Character.isJavaIdentifierPart((char)(c = this.read())));
                this.unread(c);
                Integer i = (Integer)this.fgKeys.get(this.fBuffer.toString());
                if (i != null) {
                    return i;
                }
                return 0;
            }
            return 6;
        }

        protected int read() {
            if (this.fPos <= this.fEnd) {
                return this.fDoc.charAt(this.fPos++);
            }
            return -1;
        }

        public void setRange(String text) {
            this.fDoc = text;
            this.fPos = 0;
            this.fEnd = this.fDoc.length() - 1;
        }

        protected void unread(int c) {
            if (c != -1) {
                --this.fPos;
            }
        }
    }
}

