/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.text;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.model.EventStyles;
import java.util.ArrayList;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class ExceptionStyler
implements LineStyleListener,
MouseMoveListener {
    private StyledText styledText;
    private Cursor defaultCursor;
    public static final String JAVA_STACK_RX = ".*at .*(.*:[1-9].*)";
    public static final String DNET_STACK_RX = ".*at .* in .*:line [1-9].*";

    public ExceptionStyler(StyledText text) {
        this.styledText = text;
        this.defaultCursor = text.getCursor();
    }

    public void lineGetStyle(LineStyleEvent event) {
        Point p = this.getLinkLocation(event.lineText);
        if (p != null) {
            ArrayList styles = Lists.newArrayList();
            StyleRange styleRange = new StyleRange(event.lineOffset + p.x, p.y, EventStyles.BG_DRILL, null);
            styleRange.underline = true;
            styleRange.fontStyle = 1;
            styles.add(styleRange);
            event.styles = styles.toArray(new StyleRange[0]);
        }
    }

    public void mouseMove(MouseEvent e) {
        Point point = new Point(e.x, e.y);
        int offset = this.styledText.getOffsetAtPoint(point);
        int line = this.styledText.getLineIndex(point.y);
        if (offset < 0 || offset >= this.styledText.getCharCount()) {
            this.styledText.setCursor(this.defaultCursor);
            return;
        }
        String lineText = this.styledText.getLine(line);
        Point p = this.getLinkLocation(lineText);
        if (p == null) {
            this.styledText.setCursor(this.defaultCursor);
            return;
        }
        int lineOffset = this.styledText.getOffsetAtLine(line);
        this.styledText.setCursor(offset >= lineOffset + p.x && offset <= lineOffset + p.x + p.y ? Display.getCurrent().getSystemCursor(21) : this.defaultCursor);
    }

    protected Point getLinkLocation(String lineText) {
        if (lineText.matches(JAVA_STACK_RX)) {
            int from = lineText.indexOf("(") + 1;
            int to = lineText.indexOf(")");
            int len = to - from;
            return from <= 0 || len <= 0 ? null : new Point(from, len);
        }
        if (lineText.matches(DNET_STACK_RX)) {
            int from = lineText.indexOf(") in ") + 5;
            int len = lineText.length() - from;
            return from <= 0 || len <= 0 ? null : new Point(from, len);
        }
        return null;
    }
}

