/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.prefs;

import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.widgets.TagsComposite;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TagsEditor
extends FieldEditor {
    TagsComposite composite;

    public TagsEditor(Composite parent) {
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void createControl(Composite parent) {
        this.composite = new TagsComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 8;
        parent.setLayout((Layout)layout);
        this.doFillIntoGrid(parent, layout.numColumns);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = this.composite.getSize().x + 120;
        parent.setLayoutData((Object)gd);
        this.composite.setLayoutData(gd);
        this.composite.pack();
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
        this.composite.applyCriteria();
        for (TagVO tag : TagsModel.getInstance().getTags()) {
            try {
                tag.getCriteria().prepare();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TagsModel.getInstance().fireContextChanged();
    }

    public int getNumberOfControls() {
        return 1;
    }
}

