/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.prefs;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.model.SourceIndexModel;
import com.moonlit.logfaces.client.model.SourceMappingModel;
import com.moonlit.logfaces.client.model.UrlVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class SourceUrlsEditor
extends ListEditor {
    public SourceUrlsEditor(Composite parent) {
        this.createControl(parent);
    }

    protected String createList(String[] items) {
        StringBuffer list = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            list.append(items[i]);
            if (i < items.length - 1) {
                list.append(";");
            }
            ++i;
        }
        return list.toString();
    }

    public void load() {
        this.doLoad();
        this.refreshValidState();
    }

    public void loadDefault() {
        this.doLoad();
        this.refreshValidState();
    }

    public void store() {
        this.doStore();
    }

    protected void doLoad() {
        org.eclipse.swt.widgets.List list = this.getList();
        list.removeAll();
        for (UrlVO vo : SourceMappingModel.getInstance().getUrls()) {
            list.add(vo.getUrl());
        }
    }

    protected void doLoadDefault() {
        this.doLoad();
    }

    protected void doStore() {
        ArrayList store = Lists.newArrayList();
        List<UrlVO> current = SourceMappingModel.getInstance().getUrls();
        String[] stringArray = this.getList().getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            UrlVO vo = this.findUrl(current, item);
            store.add(vo != null ? vo : new UrlVO(item));
            ++n2;
        }
        SourceMappingModel.getInstance().setUrls(store);
    }

    private UrlVO findUrl(Collection<UrlVO> collection, String url) {
        for (UrlVO vo : collection) {
            if (!url.equals(vo.getUrl())) continue;
            return vo;
        }
        return null;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        this.setLabelText("Sources base URL's");
        final org.eclipse.swt.widgets.List list = this.getList();
        GridData gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.widthHint = 400;
        gd.grabExcessHorizontalSpace = true;
        list.setLayoutData((Object)gd);
        list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int index = list.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                String location = list.getSelection()[0];
                InputDialog input = new InputDialog(SourceUrlsEditor.this.getShell(), "New value", "Sources URL base", location, null);
                if (input.open() == 0) {
                    list.remove(index);
                    list.add(input.getValue(), index);
                    SourceIndexModel.getInstance().clearCache();
                }
            }
        });
    }

    protected String getNewInputObject() {
        InputDialog input = new InputDialog(this.getShell(), "New value", "Sources URL base", null, null);
        if (input.open() == 0) {
            return input.getValue();
        }
        return null;
    }

    protected String[] parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, ";\n\r");
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreElements()) {
            v.add(st.nextElement().toString());
        }
        return v.toArray(new String[v.size()]);
    }
}

