/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.prefs;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.model.SourceMappingModel;
import com.moonlit.logfaces.client.model.UrlVO;
import com.moonlit.logfaces.client.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.List;

public class SourcePathEditor
extends PathEditor {
    public SourcePathEditor(Composite parent) {
        this.createControl(parent);
    }

    protected String createList(String[] items) {
        StringBuffer list = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            list.append(items[i]);
            if (i < items.length - 1) {
                list.append(";");
            }
            ++i;
        }
        return list.toString();
    }

    public void load() {
        this.doLoad();
        this.refreshValidState();
    }

    public void loadDefault() {
        this.doLoad();
        this.refreshValidState();
    }

    public void store() {
        this.doStore();
    }

    protected void doLoad() {
        List list = this.getList();
        for (UrlVO vo : SourceMappingModel.getInstance().getDirs()) {
            list.add(vo.getUrl());
        }
    }

    protected void doLoadDefault() {
        this.doLoad();
    }

    protected void doStore() {
        ArrayList ret = Lists.newArrayList();
        String[] stringArray = this.getList().getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            ret.add(new UrlVO(item));
            ++n2;
        }
        SourceMappingModel.getInstance().setDirs(ret);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        this.setLabelText("Source base directories");
        final List list = this.getList();
        GridData gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.widthHint = 400;
        gd.grabExcessHorizontalSpace = true;
        list.setLayoutData((Object)gd);
        list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                String dir;
                int index = list.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                String path = list.getSelection()[0];
                DirectoryDialog dialog = new DirectoryDialog(SourcePathEditor.this.getShell(), 0x10000000);
                dialog.setMessage("Select source directory");
                if (new File(path).exists()) {
                    dialog.setFilterPath(path);
                }
                if (StringUtils.hasText(dir = dialog.open())) {
                    list.remove(index);
                    list.add(dir.trim(), index);
                }
            }
        });
    }
}

