/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.prefs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import java.io.IOException;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PerspectivesPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String LFS_PREFETCH = "lfs_prefetch";
    public static final String LFS_PREFETCH_TIME = "lfs_prefetch_time";
    public static final String LFS_PRESPECTIVE_SIZE = "lfs_perspective_size";
    public static final String LFS_PRESPECTIVE_CLEAR = "lfs_perspective_clear";
    public static final String LFS_PRESPECTIVE_TRIM = "lfs_perspective_trim";
    public static final String LFS_SOUND_LEVEL = "sound_level";
    public static final String LFS_SOUND_LIMIT = "sound_limit";
    private ScopedPreferenceStore preferences = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "com.moonlit.logfaces.client.plugin");
    private BooleanFieldEditor prefetch;
    private BooleanFieldEditor clear;
    private BooleanFieldEditor trim;
    private IntegerFieldEditor prefetchTime;
    private IntegerFieldEditor perspectiveSize;
    private ComboFieldEditor soundLevel;
    private StringFieldEditor soundLimit;

    public PerspectivesPrefPage() {
        super(1);
        this.preferences.setDefault(LFS_PREFETCH, true);
        this.preferences.setDefault(LFS_PRESPECTIVE_CLEAR, false);
        this.preferences.setDefault(LFS_PREFETCH_TIME, "10");
        this.preferences.setDefault(LFS_PRESPECTIVE_SIZE, "2000");
        this.preferences.setDefault(LFS_PRESPECTIVE_TRIM, false);
        this.preferences.setDefault(LFS_SOUND_LEVEL, 30000);
        this.preferences.setDefault(LFS_SOUND_LIMIT, 10);
        this.setPreferenceStore((IPreferenceStore)this.preferences);
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/filter.gif"));
    }

    protected void createFieldEditors() {
        if (!Application.isServerMode()) {
            this.prefetch = new BooleanFieldEditor(LFS_PREFETCH, "Prefetch events when perspective activated", this.getFieldEditorParent());
            this.addField((FieldEditor)this.prefetch);
            this.prefetchTime = new IntegerFieldEditor(LFS_PREFETCH_TIME, "Time range to prefetch (minutes)", this.getFieldEditorParent());
            this.addField((FieldEditor)this.prefetchTime);
        }
        this.perspectiveSize = new IntegerFieldEditor(LFS_PRESPECTIVE_SIZE, "Max. number of events to display", this.getFieldEditorParent());
        this.addField((FieldEditor)this.perspectiveSize);
        this.clear = new BooleanFieldEditor(LFS_PRESPECTIVE_CLEAR, "Automatically clear the perspective when it fills up", this.getFieldEditorParent());
        this.addField((FieldEditor)this.clear);
        this.trim = new BooleanFieldEditor(LFS_PRESPECTIVE_TRIM, "Remove line separators in event tables ", this.getFieldEditorParent());
        this.addField((FieldEditor)this.trim);
        Label label = new Label(this.getFieldEditorParent(), 256);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 4));
        String[][] values = new String[][]{{"WARN", Integer.toString(30000)}, {"ERROR", Integer.toString(40000)}, {"FATAL", Integer.toString(50000)}, {"Disable sound alarms gloablly", Integer.toString(Integer.MAX_VALUE)}};
        String toolip = "Specifies the minimum level at which the sound\nwill be made by perspectives configured to sound alarms";
        this.soundLevel = new ComboFieldEditor(LFS_SOUND_LEVEL, "Alarm sound threshold level", values, this.getFieldEditorParent());
        this.soundLevel.getLabelControl(this.getFieldEditorParent()).setToolTipText(toolip);
        this.addField((FieldEditor)this.soundLevel);
        this.soundLimit = new StringFieldEditor(LFS_SOUND_LIMIT, "Sound alarm frequency limitation (in sec):", this.getFieldEditorParent());
        toolip = "This option prevents the aplication to play sounds too often.\nWhen non-zero value specified, the sounds will never\nbe raised more often than specified in seconds\nTo disable sounds completely specify 0";
        this.soundLimit.getTextControl(this.getFieldEditorParent()).setToolTipText(toolip);
        this.soundLimit.getLabelControl(this.getFieldEditorParent()).setToolTipText(toolip);
        this.addField((FieldEditor)this.soundLimit);
    }

    protected void initialize() {
        super.initialize();
        if (!Application.isServerMode()) {
            this.prefetchTime.setEnabled(this.prefetch.getBooleanValue(), this.getFieldEditorParent());
            this.prefetch.setPropertyChangeListener((IPropertyChangeListener)new ChangeListener());
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        try {
            this.preferences.save();
            super.performOk();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    class ChangeListener
    implements IPropertyChangeListener {
        ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            PerspectivesPrefPage.this.prefetchTime.setEnabled(PerspectivesPrefPage.this.prefetch.getBooleanValue(), PerspectivesPrefPage.this.getFieldEditorParent());
        }
    }
}

