/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.prefs;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.prefs.ParsersEditor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ParsersPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static Logger log = LogManager.getLogger(ParsersPrefPage.class);
    public static final String id = "com.moonlit.logfaces.client.prefs.parsers";
    public static final String LFS_PARSERS = "lfs_parsers";
    private ScopedPreferenceStore preferences = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "com.moonlit.logfaces.client.plugin");
    private ParsersEditor editor;

    public ParsersPrefPage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)this.preferences);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setVisible(false);
    }

    protected void createFieldEditors() {
        Label label = new Label(this.getFieldEditorParent(), 64);
        label.setText("In order to parse log files you will need to define regular expression patterns and time formats. Here you can assign a name to each set of parameters and use it whenever opening raw text file for parsing.");
        GridData gd = new GridData(4, 128, true, false, 1, 1);
        gd.widthHint = 200;
        label.setLayoutData((Object)gd);
        this.editor = new ParsersEditor(this.getFieldEditorParent());
        this.addField(this.editor);
    }

    public void init(IWorkbench workbench) {
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/dashboard.gif"));
    }

    public boolean performOk() {
        try {
            this.editor.store();
            this.preferences.putValue(LFS_PARSERS, "" + System.currentTimeMillis());
            this.preferences.save();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return super.performOk();
    }
}

