/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.prefs;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.actions.ShowAdminConsoleAction;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.conf.MdcMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class MdcPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static Logger log = LogManager.getLogger(MdcPrefPage.class);
    public static final String PREFIX = "mdc";
    private ScopedPreferenceStore preferences;
    private boolean serverMode;
    private List<StringFieldEditor> fields = Lists.newArrayList();

    public MdcPrefPage() {
        super(1);
        this.preferences = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "com.moonlit.logfaces.client.plugin");
        this.setPreferenceStore((IPreferenceStore)this.preferences);
        this.serverMode = this.preferences.getBoolean("server_mode");
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/prop_ps.gif"));
    }

    protected void createFieldEditors() {
        if (!this.serverMode) {
            Link link = new Link(this.getFieldEditorParent(), 64);
            link.setText("Those are MDC names currently mapped between applications and logFaces server. Note that these values are initialized only during connection. If mapping was modified after you connected <a>click to synchronize</a>.");
            GridData gd = new GridData(4, 128, true, false, 3, 1);
            gd.widthHint = 200;
            link.setLayoutData((Object)gd);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        MdcMap.setMap((Map)LfsConnector.getInstance().getConnection().getMdcMapping());
                        int i = 0;
                        while (i < MdcPrefPage.this.fields.size()) {
                            String value = MdcMap.getName((int)i);
                            MdcPrefPage.this.preferences.putValue(String.format("%s%d", MdcPrefPage.PREFIX, i), value != null ? value : "");
                            StringFieldEditor field = MdcPrefPage.this.fields.get(i);
                            field.getTextControl(MdcPrefPage.this.getFieldEditorParent()).setText(value != null ? value : "");
                            ++i;
                        }
                        MdcPrefPage.this.preferences.save();
                        Utils.displayPopup("Done", "You should be seeing the updated values now", false);
                    }
                    catch (Exception e) {
                        Utils.displayPopup("Failed", "Unable to synchronize MDC mapping", true);
                    }
                }
            });
            Label label = new Label(this.getFieldEditorParent(), 0);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 4));
            int i = 0;
            while (i < 10) {
                String value = MdcMap.getName((int)i);
                this.preferences.putValue(String.format("%s%d", PREFIX, i), value != null ? value : "");
                StringFieldEditor field = new StringFieldEditor(String.format("%s%d", PREFIX, i), "", this.getFieldEditorParent());
                field.setEnabled(false, this.getFieldEditorParent());
                field.getTextControl(this.getFieldEditorParent()).setText(value != null ? value : "");
                this.addField((FieldEditor)field);
                this.fields.add(field);
                ++i;
            }
            link = new Link(this.getFieldEditorParent(), 0);
            link.setText("You can <a>modify MDC mapping</a> on server, but keep in mind that this will affect all other users and applications using this server.");
            gd = new GridData(4, 128, true, false, 3, 1);
            gd.widthHint = 200;
            link.setLayoutData((Object)gd);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MdcPrefPage.this.performOk();
                    new ShowAdminConsoleAction("/contextTab").run();
                }
            });
        } else {
            Link link = new Link(this.getFieldEditorParent(), 0);
            link.setText("Those are MDC names currently mapped between applications and logFaces.");
            link.setLayoutData((Object)new GridData(4, 4, true, false, 3, 4));
            Label label = new Label(this.getFieldEditorParent(), 0);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 4));
            int size = MdcMap.getSize();
            int i = 0;
            while (i < size) {
                this.addField((FieldEditor)new StringFieldEditor(String.format("%s%d", PREFIX, i), "", this.getFieldEditorParent()));
                ++i;
            }
        }
    }

    public boolean performOk() {
        super.performOk();
        try {
            if (this.serverMode) {
                this.preferences.save();
                LfsConnector.getInstance().getConnection().getMdcMapping();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

