/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.prefs;

import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.model.EventStyle;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.widgets.LevelStylesComposite;
import java.util.Map;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LevelsPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String LFS_LEVELS = "lfs_levels";
    private ScopedPreferenceStore preferences = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "com.moonlit.logfaces.client.plugin");
    private LevelStylesComposite stylesComposite;

    public LevelsPrefPage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)this.preferences);
    }

    protected void createFieldEditors() {
        Label label = new Label(this.getFieldEditorParent(), 0);
        label.setText("Customize foreground, background and icons for severity levels.");
        label.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.stylesComposite = new LevelStylesComposite(this.getFieldEditorParent(), this.getFieldEditorParent().getStyle());
        this.stylesComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/level_debug3.gif"));
    }

    protected void initialize() {
        super.initialize();
    }

    public boolean performOk() {
        try {
            Map<Integer, EventStyle> styles = this.stylesComposite.getStyles();
            boolean dirty = EventStyles.getInstance().setStyles(styles);
            if (dirty) {
                this.preferences.putValue(LFS_LEVELS, "" + System.currentTimeMillis());
            }
            this.preferences.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.performOk();
    }
}

