/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.prefs;

import com.moonlit.logfaces.client.MainPlugin;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class JiraPrefsPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static Logger log = LogManager.getLogger(JiraPrefsPage.class);
    private ScopedPreferenceStore preferences = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "com.moonlit.logfaces.client.plugin");
    private StringFieldEditor urlEditor;
    private StringFieldEditor userEditor;
    private StringFieldEditor tokenEditor;
    private BooleanFieldEditor enabled;
    public static final String JIRA_ENABLED = "jira_enabled";
    public static final String JIRA_URL = "jira_url";
    public static final String JIRA_USER = "jira_user";
    public static final String JIRA_TOKEN = "jira_token";

    public JiraPrefsPage() {
        super(1);
        this.preferences.setDefault(JIRA_ENABLED, false);
        this.preferences.setDefault(JIRA_URL, "https://your-site.atlassian.net/rest/api/3/issue");
        this.preferences.setDefault(JIRA_USER, "your-email@company.com");
        this.preferences.setDefault(JIRA_TOKEN, "your-jira-access-token");
        this.setPreferenceStore((IPreferenceStore)this.preferences);
        this.setImageDescriptor(MainPlugin.getImageDescriptor("/icons/jira.png"));
    }

    protected void initialize() {
        super.initialize();
        this.enabled.setPropertyChangeListener((IPropertyChangeListener)new ChangeListener());
        this.urlEditor.setEnabled(this.enabled.getBooleanValue(), this.getFieldEditorParent());
        this.userEditor.setEnabled(this.enabled.getBooleanValue(), this.getFieldEditorParent());
        this.tokenEditor.setEnabled(this.enabled.getBooleanValue(), this.getFieldEditorParent());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Link link = new Link(parent, 64);
        link.setText("This integration allows direct creation of JIRA issues and attaching loggin data to them. Please refer to <a>JIRA API documentation</a> for the details.");
        GridData gd = new GridData(4, 128, true, false, 3, 1);
        gd.widthHint = 200;
        link.setLayoutData((Object)gd);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Program.launch((String)"https://developer.atlassian.com/cloud/jira/platform/rest/");
            }
        });
        this.enabled = new BooleanFieldEditor(JIRA_ENABLED, "Enable JIRA API integration", parent);
        this.addField((FieldEditor)this.enabled);
        new Label(parent, 0).setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Label label = new Label(parent, 0);
        label.setText("URL for creating JIRA issues:");
        label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 2));
        this.urlEditor = new StringFieldEditor(JIRA_URL, "", parent);
        this.addField((FieldEditor)this.urlEditor);
        new Label(parent, 0).setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        label = new Label(parent, 0);
        label.setText("User name for authentication:");
        label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 2));
        this.userEditor = new StringFieldEditor(JIRA_USER, "", parent);
        this.addField((FieldEditor)this.userEditor);
        new Label(parent, 0).setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        label = new Label(parent, 0);
        label.setText("API token for authentication:");
        label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 2));
        this.tokenEditor = new StringFieldEditor(JIRA_TOKEN, "", parent);
        this.addField((FieldEditor)this.tokenEditor);
    }

    public boolean performOk() {
        super.performOk();
        try {
            this.preferences.save();
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    class ChangeListener
    implements IPropertyChangeListener {
        ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            JiraPrefsPage.this.urlEditor.setEnabled(JiraPrefsPage.this.enabled.getBooleanValue(), JiraPrefsPage.this.getFieldEditorParent());
            JiraPrefsPage.this.userEditor.setEnabled(JiraPrefsPage.this.enabled.getBooleanValue(), JiraPrefsPage.this.getFieldEditorParent());
            JiraPrefsPage.this.tokenEditor.setEnabled(JiraPrefsPage.this.enabled.getBooleanValue(), JiraPrefsPage.this.getFieldEditorParent());
        }
    }
}

