/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.prefs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.prefs.SimpleFileFieldEditor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class FilesPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.moonlit.logfaces.client.prefs.files";
    public static final String LFS_PATTERN_LAYOUT = "lfs_pattern_layout";
    public static final String LFS_TEXT_EDITOR = "lfs_text_editor";
    public static final String LFS_EDITOR_PARAMS = "lfs_editor_params";
    public static final String LFS_EDITOR_SRC = "lfs_editor_src";
    public static final String LOG4J_URL = "http://logging.apache.org/log4j/1.2/apidocs/org/apache/log4j/PatternLayout.html";
    private ScopedPreferenceStore preferences = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "com.moonlit.logfaces.client.plugin");

    public FilesPrefPage() {
        super(1);
        this.preferences.setDefault(LFS_PATTERN_LAYOUT, "[%-5p] %d{dd MMM yyyy HH:mm:ss} %-20C{1} - %m%n");
        this.preferences.setDefault(LFS_TEXT_EDITOR, Util.isMac() ? "/usr/bin/open" : "");
        this.preferences.setDefault(LFS_EDITOR_PARAMS, "${file}");
        this.preferences.setDefault(LFS_EDITOR_SRC, false);
        this.setPreferenceStore((IPreferenceStore)this.preferences);
    }

    public void init(IWorkbench workbench) {
        this.setImageDescriptor(MainPlugin.getImageDescriptor("icons/eclipse3_edit.gif"));
    }

    protected void createFieldEditors() {
        Link link = new Link(this.getFieldEditorParent(), 64);
        link.setText("This layout pattern will be used for generating log files. More detailed information on the format can be found in <a>log4j documentation</a>");
        GridData gd = new GridData(4, 128, true, false, 3, 1);
        gd.widthHint = 200;
        link.setLayoutData((Object)gd);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Program.launch((String)FilesPrefPage.LOG4J_URL);
            }
        });
        StringFieldEditor editor = new StringFieldEditor(LFS_PATTERN_LAYOUT, "", this.getFieldEditorParent());
        editor.getTextControl(this.getFieldEditorParent());
        this.addField((FieldEditor)editor);
        Label label = new Label(this.getFieldEditorParent(), 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 2));
        label = new Label(this.getFieldEditorParent(), 0);
        label.setText("This external text editor will be used for displaying text:");
        label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 2));
        SimpleFileFieldEditor fileEditor = new SimpleFileFieldEditor(LFS_TEXT_EDITOR, "", this.getFieldEditorParent());
        this.addField((FieldEditor)fileEditor);
        label = new Label(this.getFieldEditorParent(), 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 2));
        label = new Label(this.getFieldEditorParent(), 0);
        label.setText("External editor command line parameters:");
        label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 2));
        editor = new StringFieldEditor(LFS_EDITOR_PARAMS, "", this.getFieldEditorParent());
        editor.getTextControl(this.getFieldEditorParent());
        this.addField((FieldEditor)editor);
        label = new Label(this.getFieldEditorParent(), 64);
        label.setText("Command line parameters will be appended when external editor launched. Use ${file} and ${line} placeholders to indicate file to open and text line to focus on.");
        label.setLayoutData((Object)gd);
        BooleanFieldEditor sources = new BooleanFieldEditor(LFS_EDITOR_SRC, "Always use external editor to display source code", this.getFieldEditorParent());
        this.addField((FieldEditor)sources);
    }

    public boolean performOk() {
        try {
            this.preferences.save();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Application.getShell(), (String)"FilesPrefPage saving failed", (String)e.getMessage());
        }
        return super.performOk();
    }
}

